/***************************************************************************
                          labelutils.cpp  -  description
                             -------------------
    begin                : Sam Okt 26 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "labelutils.h"
#include "dsrichtext.h" 

// TQt includes
#include <tqbitmap.h>
#include <tqimage.h>
#include <tqpaintdevicemetrics.h>
#include <tqpainter.h>
#include <tqsimplerichtext.h>

// KDE includes
#include <kapplication.h>
#include <kglobal.h>
#include <klocale.h>

// own includes
#include "printersettings.h"

#define CONVERSION_FACTOR 25.4000508001016

LabelUtils::LabelUtils()
{
}

LabelUtils::~LabelUtils()
{ }

double LabelUtils::pixelToMm( double pixel, const TQPaintDevice* device, int mode )
{
    TQPaintDeviceMetrics pdm( device ? device : TQT_TQPAINTDEVICE(KApplication::desktop()) );
    if( mode == DpiX )
	return (pixel * CONVERSION_FACTOR) / (double)pdm.logicalDpiX();
    else
	return (pixel * CONVERSION_FACTOR) / (double)pdm.logicalDpiY();
}

double LabelUtils::mmToPixel( double mm, const TQPaintDevice* device, int mode )
{
    if( !mm )
        return 0;

    // We don't get valid metrics from the printer - and we want a better resolution
    // anyway (it's the PS driver that takes care of the printer resolution).

    TQPaintDeviceMetrics pdm( device ? device : TQT_TQPAINTDEVICE(KApplication::desktop()) );
    
//    qDebug("DpiX=%i", pdm.logicalDpiX());
//    qDebug("DpiY=%i", pdm.logicalDpiY());
    if( mode == DpiX )
	return (mm / CONVERSION_FACTOR) * (double)pdm.logicalDpiX();
    else
	return (mm / CONVERSION_FACTOR) * (double)pdm.logicalDpiY();
}

double LabelUtils::pixelToPixelX( double unit, const TQPaintDevice* src, const TQPaintDevice* dest )
{
    TQPaintDeviceMetrics p1( src );
    TQPaintDeviceMetrics p2( dest );

    return ( unit * (double)p2.logicalDpiX() ) / (double)p1.logicalDpiX();
}

double LabelUtils::pixelToPixelY( double unit, const TQPaintDevice* src, const TQPaintDevice* dest )
{
    TQPaintDeviceMetrics p1( src );
    TQPaintDeviceMetrics p2( dest );

    //return pixelToPixelX( unit, src, dest );
    return ( unit * (double)p2.logicalDpiY() ) / (double)p1.logicalDpiY();
}

const TQString LabelUtils::getTypeFromCaption( const TQString & cap )
{
    // TODO: remove this function
    TQString search = cap.right( cap.length() - cap.find(":") - 1 ).lower().stripWhiteSpace();
    return search;
}

const TQString LabelUtils::getModeFromCaption( const TQString & cap )
{
    return cap.left( cap.find(":") ).lower().stripWhiteSpace();
}

TQSize LabelUtils::stringSize( const TQString & t )
{
    TQSimpleRichText srt( t, KApplication::font() );
    TQSize s;
    s.setWidth( srt.widthUsed() );
    s.setHeight( srt.height() );

    return s;
}

void LabelUtils::renderString( TQPainter* painter, const TQString & t, const TQRect & rect, double scalex, double scaley )
{
    // DSRichText cannot calculate the width on its own
    TQSimpleRichText srt( t, KApplication::font() );
    int width = (rect.width() > 0) ? rect.width() : srt.widthUsed();
    int height = (rect.height() > 0) ? rect.height() : srt.height();
    
    DSRichText r( t );
    r.setX( rect.x() );
    r.setY( rect.y() );
    r.setWidth( width );
    r.setHeight( height );
    r.setScale( scalex, scaley );
    r.draw( painter );    
}

TQPixmap* LabelUtils::drawString( const TQString & t, int w, int h, double rot )
{
    TQSimpleRichText srt( t, KApplication::font() );

    int width = (w > 0) ? w : srt.widthUsed();
    int height = (h > 0) ? h : srt.height();
    srt.setWidth( width );
    
    TQPixmap* pix;
    TQPainter painter;
    if( rot == 0.0 ) {
        TQBitmap bm( width, height );
        bm.fill( TQt::color0 ); //transparent
        painter.begin( &bm );
    
          painter.save();
            painter.setPen( TQt::color1 );
            TQColorGroup cg;
            cg.setColor( TQColorGroup::Foreground, TQt::color1 );
              cg.setColor( TQColorGroup::Text, TQt::color1 );
              cg.setColor( TQColorGroup::Base, TQt::color0 );
    
            srt.draw( &painter, 0, 0, bm.rect(), cg );
          painter.restore();
        painter.end();
        
        pix = new TQPixmap( width, height );
        pix->fill( TQt::white );
        pix->setMask( bm );
            
        if( !pix->isNull() ) {
            painter.begin( pix );
            painter.setPen( TQt::black );
            TQColorGroup cg;
            srt.draw( &painter, 0, 0, pix->rect(), cg );
            painter.end();
        } 
    } else {
        int w2 = (w > 0) ? w : srt.widthUsed();
        int h2 = (h > 0) ? h : srt.height();

        TQWMatrix wm;
        wm.rotate( rot );

        TQSize s = LabelUtils::stringSize( t );
        TQPixmap* tmp = LabelUtils::drawString( t, s.width(), s.height() );

        TQPixmap* p = new TQPixmap( w2, h2 );
        p->fill( TQt::white );
        painter.begin( p );
        painter.drawPixmap( 0, 0, tmp->xForm( wm ) );
        painter.end();

        p->setMask( p->createHeuristicMask() );

        pix = p;
        delete tmp;
    }
    
    return pix;
}

