/***************************************************************************
                          label.cpp  -  description
                             -------------------
    begin                : Mon Apr 29 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "label.h"
#include "measurements.h"
#include "kbarcode.h"
#include "printersettings.h"
#include "sqltables.h"
#include "documentitem.h"
#include "barcodeitem.h"
#include "rectitem.h"
#include "lineitem.h"
#include "imageitem.h"
#include "textitem.h"

// TQt includes
#include <tqimage.h>
#include <tqiodevice.h>
#include <tqpaintdevicemetrics.h>
#include <tqpainter.h>
#include <tqpen.h>
#include <tqsqlcursor.h>
#include <tqxml.h>

// KDE includes
#include <kapplication.h>
#include <klocale.h>
#include <kprinter.h>

Label::Label( Definition* _def, TQIODevice* device, TQString labelname, TQPaintDevice* _printer, TQString customer_id, TQString _article_no, TQString _group )
    : TokenProvider( _printer )
{
    m_sequence = false;
    m_printer = _printer;
   
    setCustomerNo( customer_id );
    setArticleNo( _article_no );
    setGroup( _group );
    setLabelName( labelname.right( labelname.length() - labelname.findRev( "/" ) - 1 ) );

    d = _def;

    load( device );
}

Label::Label( Definition* _def, TQIODevice* device, TQString labelname, TQPaintDevice* _printer )
    : TokenProvider( _printer )
{
    m_sequence = false;
    m_printer = _printer;
   
    setLabelName( labelname.right( labelname.length() - labelname.findRev( "/" ) - 1 ) );

    d = _def;

    load( device );
}

Label::~Label()
{
}

void Label::epcl( TQTextStream* stream )
{
    *stream << EPCLUtils::header();
    
    DocumentItem* item;
    for( item = m_list.first();item;item=m_list.next())
	if( drawThisItem( item ) )
	    item->drawEPcl( stream );
    
    *stream << EPCLUtils::footer();
}

void Label::ipl( TQTextStream* stream )
{
    IPLUtils utils;
    *stream << utils.header();
    
    DocumentItem* item;
    for( item = m_list.first();item;item=m_list.next())
	if( drawThisItem( item ) )
	    item->drawIpl( stream, &utils );
    
    *stream << utils.footer();
}


void Label::zpl( TQTextStream* stream )
{
    *stream << ZPLUtils::header();
    
    DocumentItem* item;
    for( item = m_list.first();item;item=m_list.next())
	if( drawThisItem( item ) )
	    item->drawZpl( stream );
    
    *stream << ZPLUtils::footer();
}

void Label::InitBarcodes()
{
    bool firstbarcode = true;
    
    DocumentItem* item;
    for( item = m_list.first();item;item=m_list.next())
    {
        if( item->rtti() == eRtti_Barcode )
        {
	    /*
	      TODO: I am not sure wether this should be done
	    if( !drawThisItem( item ) )
		continue;
	    */

            BarcodeItem* bc = static_cast<BarcodeItem*>(item);
            bc->setIndex( index() );
            setBarcodeValue( bc );
            bc->updateBarcode();
            
            if( firstbarcode )
            {
                // set some values of the first barcode
                firstbarcode = false;
        
                m_sequence = bc->sequenceEnabled() || m_sequence;
                setBarcodeNo( bc->parsedValue() );
                setEncodingTypeName( bc->type() ); 
            }
        }
    }
    
    updateDone();    
}

void Label::draw( TQPainter* painter, int x, int y )
{
    TQSize label( (int)d->getMeasurements().width( TQT_TQPAINTDEVICE(painter->device()) ),
		 (int)d->getMeasurements().height( TQT_TQPAINTDEVICE(painter->device()) ) );

    InitBarcodes();

    DocumentItem* item;
    for( item = m_list.first();item;item=m_list.next())
	if( drawThisItem( item ) )
	{
	    // add x and y to clip coordinates
	    // as clip has its top left corner
	    // at (0,0)
	    TQRect clip( item->boundingRect() );
	    if( x + clip.x() < x )
		clip.setX( 0 );

	    if( y + clip.y() < y )
		clip.setY( 0 );

	    if( clip.x() + clip.width() > label.width() )
		clip.setWidth( label.width() - clip.x() );

	    if( clip.y() + clip.height() > label.height() )
		clip.setHeight( label.height() - clip.y() );
	    
	    painter->save();
	    painter->translate( x,y );
	    painter->setClipRect( clip, TQPainter::CoordPainter );
	    item->draw( painter );
	    painter->restore();
	}
}

void Label::setBarcodeValue( Barkode* barcode )
{
    // use the same i18n() for static as in BarcodeSettingsDlg
    if( barcode->databaseMode().lower() != "static" && barcode->databaseMode().lower() != i18n("Static") ) 
    {
        TQString encoding_type = getTypeFromCaption( barcode->databaseMode() );
        TQString mode = getModeFromCaption( barcode->databaseMode() );

        TQSqlQuery query( "select barcode_no, encoding_type from " TABLE_BASIC 
                         " where article_no = '" + articleNo() + "'" ); 
        while ( query.next() ) 
        {
            barcode->setValue( query.value(0).toString() );
            barcode->setType( query.value(1).toString() );
        }

        if( mode.lower() != "main" ) 
        {
            TQSqlQuery query1( "select barcode_no from " TABLE_CUSTOMER_TEXT " where customer_no ='"+ mode +
                             "' and article_no='" + articleNo() + "'" );
            while ( query1.next() ) 
            {
                if( !query1.value(0).toString().isEmpty() ) 
                {
                    barcode->setValue( query.value(0).toString() );
                    barcode->setType( encoding_type );
                }
            }
        }
    }
}

void Label::load( TQIODevice* device )
{
    if( !device ) return;

    if( !device->isOpen() )
        device->open( IO_ReadOnly );

    TQDomDocument doc( "KBarcodeLabel" );        
    doc.setContent( device );
    
    bool kbarcode18;
    TQString description;
    Definition* definition = NULL;
    readXMLHeader( &doc, description, kbarcode18, &definition );
    delete definition;
    
    readDocumentItems( &m_list, &doc, NULL, kbarcode18 );
    m_list.setAutoDelete( true );
                
    // sort the list by z index
    m_list.sort();
    
    DocumentItem* item;
    for( item = m_list.first();item;item=m_list.next())
    {
        // set the paint device for all items
        item->setPaintDevice( m_printer );
        item->setTokenProvider( this );
    }
    
    device->close();    
}

void Label::getXLabel( double x, double y, double width, double height, TQPainter* painter, int mode, TQString value )
{
    painter->save();
    if( mode == LABEL_X ) {
        painter->setPen( TQPen( TQt::black, 5) );
        painter->drawLine( (int)x, (int)y, int(x+width), int(y+height) );
        painter->drawLine( (int)x, int(y+height), int(x+width), (int)y );
    } else if( mode == ARTICLE_GROUP_NO ) {
        painter->setPen( TQPen( TQPen::black, 1 ) );
        TQFont f( "helvetica", 15 );
        int w = 0;
        do {
            f.setPointSize( f.pointSize() - 1 );
            painter->setFont( f );
            w = painter->fontMetrics().width( value );
        } while( w > width && f.pointSize() > 0 );

        painter->drawText( int(x + (width-w)/2), int(y + (height-f.pointSize())/2), value);
    }

    painter->restore();
    return;
}

int Label::getId() const
{
    if( d )
        return d->getId();

    return -1;
};

bool Label::drawThisItem( const DocumentItem* item )
{
    TQString script = item->visibilityScript();

    // make things go faster if the script is just "true"
    if( script.isEmpty() || script == "true" )
	return true;

    script = parse( script );
    
    return jsParseToBool( script );
}

bool Label::update() 
{
    DocumentItem* item;
    for( item = m_list.first();item;item=m_list.next())
	if( !item->visibilityScript().isEmpty() && item->visibilityScript() != "true" )
	    return true;
	    
    return TokenProvider::update();
}
