/***************************************************************************
                          kbarcode.h  -  description
                             -------------------
    begin                : Don Apr 18 12:34:56 CEST 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBARCODE_H
#define KBARCODE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqstring.h>

enum linebreak {
    NO_BREAK,
    LINE_BREAK,
    LABEL_X,
    NEW_PAGE,
    ARTICLE_GROUP_NO
};

#include "dsmainwindow.h"
#include "kbarcodeiface.h"

class KAction;
class KPushButton;
/** The main window of KBarcode. All submodules
  * are started from here. Submodules are the LabelEditor
  * LabelPrinter (Batchprinting), DatabaseBrowser and BarcodeDialog.
  * There are also a few smaller modules.
  */
class KBarcode: public DSMainWindow, public KBarcodeIface {
    Q_OBJECT
  TQ_OBJECT
    public:
        KBarcode( TQWidget *parent=0, const char *name="kbarcode", WFlags f = WType_TopLevel | WDestructiveClose );
        ~KBarcode();

        /** Parse all commandline options and start batchprinting
         *  if necessary. 
         *  \returns true if the application should exit after this function
         */          
        bool parseCmdLine();

    private slots:
        void startBarcode();
        void startLabelEditor();
        void startBatchPrint();

        void editArticles();
        void editCustomers();
        void editCustomerText();
        void editLabelDef();

        void enableData();

        void importCSV();

    private:
        void setupActions();

        /** allow the DCOP interface
          * to check for an SQL connection.
          */
        bool isSQLConnected() const;
        /** allow the DCOP interface
          * to connect to the databases.
          */
        bool connectSQL();
        /** allow DCOP interface
          * to start the configuration wizard.
          */
        void showWizard();
        /** show preferences from DCOP.
          */
        void showConfigure();


        KAction* connectAct;
        KPushButton* buttonSingle;
        KPushButton* buttonEditor;
        KPushButton* buttonBatch;
        KPushButton* buttonData;
};

#endif
