#ifndef DEFINITIONDIALOG_H
#define DEFINITIONDIALOG_H

#include <tqwidget.h>
#include <tqdialog.h>
#include "measurements.h"

class TQVBoxLayout; 
class TQHBoxLayout; 
class TQGridLayout; 
class KComboBox;
class KPushButton;
class KRestrictedLine;
class TQLabel;
class TQStringList;
class TQRect;
class TQPaintEvent;
/** Displays a preview of the given label measurements.
  * The current page size setting of the user is used.
  * The labels are drawn using TQPainter. Only one page is previewed.
  */
class LabelPreview : public TQWidget {
    Q_OBJECT
  TQ_OBJECT
    public:
        LabelPreview( TQWidget* parent = 0, const char* name = 0 );
        ~LabelPreview();

        void setRect( TQRect label ) { size = label; }
        void setMeasurements( const Measurements & m ) { measure = m; }
        
        void setPrvEnabled( bool b ) { m_prv_enabled = b; }

    protected:
        void paintEvent( TQPaintEvent* );
        TQRect size;
        Measurements measure;
        
        bool m_prv_enabled;
};

/** A dialog which allows the user to create his/her own
  * label definitions easily.
  */
class DefinitionDialog : public TQDialog
{ 
    Q_OBJECT
  TQ_OBJECT

public:
    DefinitionDialog( TQWidget* parent = 0, const char* name = 0, bool modal = true, WFlags fl = 0 );
    ~DefinitionDialog();
private:
    const Measurements getCurrentMeasure();

private slots:
    void add();
    void updateType();
    void updateText();
    void updatePreview();
    void toggleExtension();
    void drawGraphic();

protected:
    TQLabel* l;
    TQLabel* TextLabel1;
    TQLabel* TextLabel2;
    TQLabel* TextLabel3;
    TQLabel* TextLabel4;
    TQLabel* TextLabel5;
    TQLabel* TextLabel6;
    TQLabel* TextLabel7;
    TQLabel* TextLabel8;
    TQLabel* TextLabel9;
    TQLabel* TextLabel10;
    KComboBox* comboProducer;
    KComboBox* comboType;
    KRestrictedLine* editWidth;
    KRestrictedLine* editHeight;
    KRestrictedLine* editHGap;
    KRestrictedLine* editVGap;
    KRestrictedLine* editTGap;
    KRestrictedLine* editLGap;
    KRestrictedLine* editNumH;
    KRestrictedLine* editNumV;
    KPushButton* buttonAdd;
    KPushButton* buttonCancel;
    KPushButton* buttonInfo;

    TQStringList* types;
    LabelPreview* preview;

protected:
    TQVBoxLayout* DefinitionDialogLayout;
    TQHBoxLayout* Layout17;
    TQVBoxLayout* Layout13;
    TQVBoxLayout* Layout14;
    TQHBoxLayout* Layout16;
};

#endif // DEFINITIONDIALOG_H
