/***************************************************************************
 *   Copyright (C) 2005 by Joe Ferris                                      *
 *   jferris@optimistictech.com                                            *
 *                                                                         *
 *   This document is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This document is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this document; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef DOCUMENTCATALOG_H
#define DOCUMENTCATALOG_H

#include <kgenericfactory.h>

#include <tqstring.h>
#include <tqstringlist.h>
#include <tqptrlist.h>
#include <tqdir.h>

#include "katapultcatalog.h"

class TQWidget;
class Document;

/**
@author Joe Ferris
*/
class DocumentCatalog : public KatapultCatalog
{
	Q_OBJECT
  TQ_OBJECT
public:
	DocumentCatalog(TQObject *, const char *, const TQStringList&);
	virtual ~DocumentCatalog();

	virtual void initialize();
	virtual void queryChanged();
	virtual void readSettings(KConfigBase *);
	virtual void writeSettings(KConfigBase *);
	virtual unsigned int minQueryLen() const;
	virtual TQWidget * configure();
	
public slots:
	void minQueryLenChanged(int);
	void toggleshowPreview(bool);
	
private:
	void refreshFolders();
	void refreshFiles();

	TQPtrList<Document> files;
	Document *currentDirDoc;
	TQStringList folders;
	TQString currentPath;
	TQDir dir;
	bool filesListed;
	int _minQueryLen;
	int queryMatched;
	bool _showPreview;
};

#endif
