/***************************************************************************
 *   Copyright (C) 2005  Tobi Vollebregt                                   *
 *   tobivollebregt@gmail.com                                              *
 *                                                                         *
 *   Copyright (C) 2005 by Joe Ferris                                      *
 *   jferris@optimistictech.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef EXPRESSION_H
#define EXPRESSION_H

#include <katapultitem.h>

class CalculatorCatalog;

/**
@author Tobi Vollebregt
*/
class Expression : public KatapultItem
{
	Q_OBJECT
  TQ_OBJECT
	public:
		Expression(CalculatorCatalog*, const TQString&);

		virtual TQPixmap icon(int) const;
		virtual TQString text() const;

		void setText(const TQString&);
		double result() const;
		bool parseError() const;

		//evaluate() must be const, or ActionEvaluateExpression::execute() can't call it.
		//It makes sense because evaluate() does _not_ change the expression,
		//it just calculates the result and remembers that.
		void evaluate(bool assignments = false) const;

		CalculatorCatalog* catalog() const;

	private:
		CalculatorCatalog* const _catalog;
		TQString _text;
		mutable double _result;
		mutable bool _parseError;
};

#endif
