/*
 * startwindow.cpp
 *
 * Copyright (C) 2004-2005 Jürgen Kofler <kaffeine@gmx.net>
 * Copyright (C) 2006-2007 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdebug.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqhbox.h>
#include <tqcolor.h>
#include <tqtooltip.h>

#include "version.h"
#include "startwindow.h"
#include "startwindow.moc"



MToolButton::MToolButton( TQWidget *parent, const TQString& targ ) : TQToolButton( parent )
{
	target = targ;
	connect( this, TQT_SIGNAL(clicked()), TQT_SLOT(mClicked()) );
}

MToolButton::~MToolButton()
{
}

void MToolButton::mClicked()
{
	emit executed( target );
}



SLabel::SLabel( TQWidget *parent ) : TQLabel( parent )
{
}



void SLabel::paintEvent( TQPaintEvent *pe )
{
	TQLabel::paintEvent( pe );
	TQColorGroup cg = parentWidget()->colorGroup();
	TQColor base = cg.base();
	TQColor selection = cg.highlight();
	int r = (base.red() + selection.red()) / 2;
	int b = (base.blue() + selection.blue()) / 2;
	int g = (base.green() + selection.green()) / 2;
	setPaletteBackgroundColor( TQColor(r, g, b) );
}



StartWindow::StartWindow(TQWidget* parent, const char* name) : TQWidget(parent, name)
{
	TQVBoxLayout* mainLayout = new TQVBoxLayout(this);
	mainLayout->setAutoAdd(true);
	mainLayout->setSpacing(0);

	label1 = new SLabel(this);
	//label1->setPaletteBackgroundColor(TQColor(238, 246, 255));
	label1->setText("<center><font size=\"7\"><b>"+i18n("[Kaffeine Player]")+"</b></font></center>");
	label2 = new SLabel(this);
	//label2->setPaletteBackgroundColor(TQColor(238, 246, 255));
	label2->setText(TQString("<center><font  size=\"5\">") + KAFFEINE_VERSION + "</font></center>");

	panel = new TQWidget( this );
	panel->setPaletteBackgroundColor(TQColor("White"));
	panel->setSizePolicy( TQSizePolicy( TQSizePolicy::Preferred, TQSizePolicy::MinimumExpanding ) );

	buttons.setAutoDelete( true );
}



StartWindow::~StartWindow()
{
	buttons.clear();
}



void StartWindow::registerTarget( const TQString& uiName, const TQString& pixName, const TQString& targetName )
{
	MToolButton *btn = new MToolButton( panel, targetName );
	//TQFont f = btn->font();
	//f.setPointSize( f.pointSize()+2 );
	//f.setBold(true);
	//btn->setFont( f );
	btn->setTextLabel( TQString("&%1 %2").arg(buttons.count() + 1).arg(uiName));
	TQToolTip::add(btn, uiName);
	btn->setTextPosition( TQToolButton::Under );
	btn->setUsesTextLabel( true );
	btn->setIconSet( KGlobal::iconLoader()->loadIconSet(pixName, KIcon::Panel) );
	TQSize size = btn->sizeHint();
	size.setHeight( size.height()+5 );
	btn->resize( size );
	connect( btn, TQT_SIGNAL(executed(const TQString&)), this, TQT_SIGNAL(execTarget(const TQString&)) );
	buttons.append( btn );
	btn->show();
	arrangeButtons( TQSize( width(),height() ) );
}



void StartWindow::execTarget(int index)
{
	if ( index<1 || index>buttons.count() )
		return;
	buttons.at( index-1 )->animateClick();
}



void StartWindow::unregisterTarget( const TQString& targetName )
{
	int i;
	MToolButton *btn;

	for ( i=0; i<(int)buttons.count(); i++ ) {
		btn = buttons.at(i);
		if ( btn->target==targetName ) {
			buttons.remove( btn );
			arrangeButtons( TQSize( width(),height() ) );
			return;
		}
	}
}



void StartWindow::arrangeButtons( TQSize e )
{
	MToolButton *btn;
	int x, y;
	int i, j, k, nb, nw, nh, mw, mh;
	int bw=0, bh=0, iter=20;
	int nnh;
	int ew = e.width();
	int eh = e.height()-label1->height()-label2->height();
	TQPtrListIterator<MToolButton> it(buttons);

	nb = buttons.count();
	if ( !nb )
		return;
	it.toFirst();
	while ( it.current() ) {
		if ( it.current()->width()>bw )
			bw = it.current()->width();
		if ( it.current()->height()>bh )
			bh = it.current()->height();
		++it;
	}

	nw = nb;
	nh = 1;
	while ( (ew-(nw*(bw+iter)))<(eh-(nh*(bh+iter))) ) {
		if ( nw==1 )
			break;
		--nw;
		++nh;
	}

	nnh=0;
	while ( (nnh*nw)<nb )
		++nnh;

	mh = (eh-((nnh*bh)+((nnh-1)*iter)))/2;
	mw = (ew-((nw*bw)+((nw-1)*iter)))/2;

	k = 0;
	y = mh;
	for ( i=0; i<nh; i++ ) {
		x = mw;
		for ( j=0; j<nw; j++ ) {
			btn = buttons.at(k);
			if ( !btn )
				return;
			btn->resize(bw,bh);
			btn->move( x, y );
			++k;
			x = x+iter+bw;
		}
		y = y+iter+bh;
	}
}



void StartWindow::resizeEvent( TQResizeEvent *e )
{
	arrangeButtons( e->size() );
}
