/*
 * deinterlacequality.h - dialog for selecting the quality of deinterlacing
 *
 * Copyright (C) 2004-2005 Jürgen Kofler <kaffeine@gmx.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef DEINTERLACEQUALITY_H
#define DEINTERLACEQUALITY_H

#include <kdialogbase.h>

/**
  *@author Juergen  Kofler
  */

class TQCheckBox;
class TQSlider;
class TQString;
class TQStringList;
class KPushButton;    

class DeinterlacerConfigDialog : public KDialogBase
{
  Q_OBJECT
  TQ_OBJECT
public:
  DeinterlacerConfigDialog(TQWidget *parent=0, const char *name=0)
  : KDialogBase( parent, name, true, i18n("Configure tvtime Deinterlace Plugin"), KDialogBase::Close )
  {
    setInitialSize(TQSize(450,400), true);

    mainWidget = makeVBoxMainWidget();
  }

  ~DeinterlacerConfigDialog() {}
  TQWidget* getMainWidget() const { return (TQWidget*)mainWidget; }

private:
  TQVBox* mainWidget;
};

class DeinterlaceQuality : public KDialogBase  {
   Q_OBJECT
  TQ_OBJECT
public: 
  DeinterlaceQuality(TQWidget* filterDialog, TQWidget *parent=0, const char *name=0);
  ~DeinterlaceQuality();  

  void setQuality(uint);
  uint getQuality() const;
  
signals:
  void signalSetDeinterlaceConfig(const TQString&);

private slots:
  void slotLevelChanged(int);
  void slotCustomBoxToggled(bool);

private:
  TQStringList m_configStrings;
  TQSlider* m_qualitySlider;
  TQCheckBox* m_customBox;
  KPushButton* m_customConfigButton;
};

#endif /* DEINTERLACEQUALITY_H */
