/*
 * mrl.h
 *
 * Copyright (C) 2004-2005 Jürgen Kofler <kaffeine@gmx.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef MRL_H
#define MRL_H

#include <tqdatetime.h>
#include <tqstringlist.h>

#include <kurl.h>

/*
 * media resource locator
 * holds url and meta info
 */

class KDE_EXPORT MRL
{
public:
   MRL();
   /* don't use this constructor to prevent encoding problems */
   MRL(const KURL& url, const TQString& title = TQString(), const TQTime& length = TQTime(), const TQString& mime = TQString(),
       const TQString& artist = TQString(), const TQString& album = TQString(), const TQString& track = TQString(),
       const TQString& year = TQString(), const TQString& genre = TQString(), const TQString& comment = TQString(),
       const TQStringList& subtitleFiles = TQStringList(), const int currentSubtitle = -1);
   MRL(const TQString& url, const TQString& title = TQString(), const TQTime& length = TQTime(), const TQString& mime = TQString(),
       const TQString& artist = TQString(), const TQString& album = TQString(), const TQString& track = TQString(),
       const TQString& year = TQString(), const TQString& genre = TQString(), const TQString& comment = TQString(),
       const TQStringList& subtitleFiles = TQStringList(), const int currentSubtitle = -1);
   virtual ~MRL();

   void reset() { m_url = TQString(); m_kurl = KURL(); }
   bool isEmpty() { return (m_url == TQString()); }

   const TQString& url() const { return m_url; }
   const KURL& kurl() const { return m_kurl; }
   const TQString& title() const { return m_title; }
   const TQString& artist() const { return m_artist; }
   const TQString& album() const { return m_album; }
   const TQString& track() const { return m_track; }
   const TQString& year() const { return m_year; }
   const TQString& genre() const { return m_genre; }
   const TQString& comment() const { return m_comment; }
   const TQString& mime() const { return m_mime; }
   const TQTime& length() const { return m_length; }
   const TQStringList& subtitleFiles() const { return m_subtitleFiles; }
   int currentSubtitle() const { return m_currentSubtitle; }

   void setURL(const TQString& url) { m_url = url; m_kurl = KURL(url); }
   void setTitle(const TQString& title) { m_title = title; }
   void setArtist(const TQString& artist) { m_artist = artist; }
   void setAlbum(const TQString& album) { m_album = album; }
   void setTrack(const TQString& track) { m_track = track; }
   void setYear(const TQString& year) { m_year = year; }
   void setGenre(const TQString& genre) { m_genre = genre; }
   void setComment(const TQString& comment) { m_comment = comment; }
   void setMime(const TQString& mime) { m_mime = mime; }
   void setLength(const TQTime& length) { m_length = length; }
   void setSubtitleFiles(const TQStringList& urls) { m_subtitleFiles = urls; }
   void addSubtitleFile(const TQString& url) { m_subtitleFiles.append(url); }
   void setCurrentSubtitle(int sub) { m_currentSubtitle = sub; }

private:
   TQString m_url;
   KURL m_kurl;
   TQString m_title;
   TQString m_artist;
   TQString m_album;
   TQString m_track;
   TQString m_year;
   TQString m_genre;
   TQString m_comment;
   TQString m_mime;
   TQTime m_length;
   TQStringList m_subtitleFiles;
   int m_currentSubtitle; /* -1 -> off */
};

#endif /* MRL_H */
