/*
 * cdwidget.h
 *
 * Copyright (C) 2005 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef CDWIDGET_H
#define CDWIDGET_H

#include <tqlistbox.h>
#include <tqpixmap.h>
#include <tqptrlist.h>
#include <tqvbox.h>
#include <tqsplitter.h>

#include <kconfig.h>

#include "cddump.h"
#include "cdlisten.h"
#include "cdcleaner.h"
#include "kaffeineinput.h"



class CdWidget : public KaffeineInput
{
	Q_OBJECT
  TQ_OBJECT

public:

	CdWidget( const TQString &ad, int port, int info, const TQString &tspath, TQWidget *parent, TQObject *objParent, const char *name );
	~CdWidget();
	void setParam( const TQString &ad, int port, int info, const TQString &tspath );
	void enableLive( bool b );
	void playNumChannel( int num );
	void next();
	void previous();

	// Reimplemented from KaffeineInput
	TQWidget *wantPlayerWindow();
	TQWidget *inputMainWidget();
	bool nextTrack( MRL& );
	bool previousTrack( MRL& );
	bool currentTrack( MRL& );
	bool trackNumber( int, MRL& );
	bool playbackFinished( MRL& );
	void getTargets( TQStringList &uiNames, TQStringList &iconNames, TQStringList &targetNames );
	void togglePanel();
	bool execTarget( const TQString& );
	void saveConfig();
	//***************************************

	TQListBox *channelsLb;
	TQVBox *mainWidget;
	TQVBox *playerBox;

public slots:

	void playLastChannel();
	void stopLive();
	void pauseLiveTV();

private:
	void loadConfig( KConfig* config );
	void saveConfig( KConfig* config );

	TQSplitter *split;
	CdDump *dump;
	CdListen *listen;
	TQString cdAddress;
	int cdPort;
	int cdInfo;
	TQString cdShiftDir;
	TQPixmap tvPix, raPix;
	TQPtrList<CdChannel> chan;
	TQString fifoName;
	TQString timeShiftFileName;
	CdCleaner *cleaner;
	int lastChannel;

private slots:

	void updateList( const TQString &list );
	void channelSelected( const TQString &name );

signals:

	void dvbOpen(const TQString&, const TQString&, int);
	void dvbStop();
	void setTimeShiftFilename( const TQString& );
};

#endif /* CDWIDGET_H */
