//
// C++ Interface: k9copy
//
// Description:
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//


#ifndef _K9COPY_H_
#define _K9COPY_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "k9common.h"
#include "k9cddrive.h"
#include <kapplication.h>
#include <kmdimainfrm.h>

enum eStatusBarId {sbMessage=0,sbFactor=1};

class k9Import;
class k9Main;
class kViewMPEG2;
class k9PlaybackOptions;
class k9LangSelect;
class k9MP4Title;
class k9TitleFactor;
class k9MenuEdit;
class k9NewTitle;
class k9ChapterEdit;
class k9Copy : public KMdiMainFrm {
    Q_OBJECT
  TQ_OBJECT
public:
    /**
     * Default Constructor
     */
    k9Copy();

    void clone(TQString _input,TQString _output);
    void setInput(TQString _input);
    void setOutput(TQString _output);

    KDockWidget* getVisibleDock();
    KMdiToolViewAccessor * setToolWindow(TQWidget *_widget,KDockWidget::DockPosition _pos,const TQString &tabToolTip,const TQString &tabCaption) ;
    void removeToolWindow(KMdiToolViewAccessor *toolWin);

    /**
     * Default Destructor
     */
    virtual ~k9Copy();

protected:
    bool queryClose( );
    void closeEvent( TQCloseEvent* ce );

private slots:
    void ActionCopy();
    void ActionMP4();
    void ActionEject();
    void ActionMpeg2();
    void ActionBackup();
    void ActionAuthor();
    void ActionPlayTitle();
    void ActionCreate();
    void changeStatusbar(const TQString& text,int id);
    void changeCaption(const TQString& text);
    void optionsConfigureKeys();
    void optionsConfigureToolbars();
    void newToolbarConfig();
    void addMp4TitleOptions();
public slots:
    void fileOpen();
    void preferences();
    void quit();
    void setActions(bool enabled);
    void setEnabledCreateDVD(bool _state);
private:
    void setupAccel();
    void setupActions();
    void initCodecs();
    void createImportWindows();
    void createCopyWindows();
    void removeToolWindows();
    void saveDock();
    KAction *CopyAction;
    KAction *PlayTitleAction;
    KAction *mkMP4Action;
    KAction *mkMpeg2Action;
    KAction *ejectAction;
    KRadioAction *backupAction;
    KRadioAction *authorAction;
private:
    k9Main  *m_k9Main;
    KMdiChildView *m_k9MainView,*m_k9ImportView;
    KMdiToolViewAccessor *m_previewAcc;
    k9PlaybackOptions *m_options;
    k9TitleFactor *m_factors;
    k9LangSelect *m_lang;
    k9MP4Title *m_mp4;
    TQWidget *m_mp2;
    k9MenuEdit *m_menuEdit;
    k9NewTitle *m_newTitle;
    k9ChapterEdit *m_chapterEdit;
    k9Import *m_k9Import;
    bool m_useXine;
    bool m_useDvdAuthor;
    TQMap  <TQString,KAction*> m_actions;
    TQPtrList <KMdiToolViewAccessor> m_ToolViews;
    k9CdDrives m_drives;
};



#endif
