//
// C++ Implementation: k9tools
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "k9tools.h"
#include <kstandarddirs.h>
#include <tqdir.h>

bool k9Tools::checkProgram(TQString _progName) {
   return KStandardDirs::findExe( _progName,NULL,false) !=NULL ;
}

void k9Tools::clearOutput(TQString name) {
    TQDir dir(name);
    //delete files in directory
    TQStringList lst = dir.entryList( "*",TQDir::Files |TQDir::Hidden );
    for ( TQStringList::Iterator it = lst.begin(); it != lst.end(); ++it ) {
        //TQString c(( *it ).latin1() );
        dir.remove (*it);
    }
    //scanning subdir
    TQStringList lstdir = dir.entryList( "*",TQDir::Dirs );
    for ( TQStringList::Iterator it = lstdir.begin(); it != lstdir.end(); ++it ) {
        TQString c=*it;
        if ((c!=".") && c!="..") {
            clearOutput(dir.absFilePath(c));
            dir.rmdir(c);
        }
    }

}
