//
// C++ Interface: k9plaympeg2
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef K9PLAYMPEG2_H
#define K9PLAYMPEG2_H

#include "k9common.h"
#include "k9dvdtitle.h"


#include <tqthread.h>
#include <tqobject.h>
#include <tqmutex.h>
#include <tqwidget.h>
#include "k9decodethread.h"
/**
	@author Jean-Michel PETIT <k9copy@free.fr>
*/
class k9PlayMPEG2 : public TQObject,public TQThread
{
Q_OBJECT
  TQ_OBJECT
private:
   k9DVDTitle *m_title;
   TQString m_device;
   k9DecodeThread m_decoder;
   uint32_t m_idxLect;
   uint32_t m_startSector;
   uint32_t m_lastSector;
   bool m_stopped;
   dvd_file_t *dvdfile;
   TQMutex mutex;
   dvd_reader_t *m_dvd;
   int m_chapter;
public:
    k9PlayMPEG2();
    void open (dvd_reader_t *dvd,const TQString & device,k9DVDTitle * title,int chapter);
    kDecMPEG2 *getDecoder();
    void setDvd(dvd_reader_t* _value) { m_dvd = _value;}
    dvd_reader_t* getDvd() const {return m_dvd;}
    ~k9PlayMPEG2();
protected:
    void run();
    void playTitle();
public slots:
  void stop();
  void play();
  void updatePos(uint32_t _position);	
	
signals:
  void setPosition(uint32_t _position);
  void setMin(uint32_t _sector);
  void setMax(uint32_t _sector);

  void setError(const TQString & err);

};

#endif
