// vim: set tabstop=4 shiftwidth=4 noexpandtab
/*
Gwenview - A simple image viewer for KDE
Copyright 2000-2004 Aurlien Gteau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/
#ifndef BOOKMARKOWNER_H
#define BOOKMARKOWNER_H


// KDE includes
#include <kbookmarkmanager.h>
#include <kurl.h>
namespace Gwenview {


class BookmarkOwner : public TQObject, public KBookmarkOwner {
Q_OBJECT
  TQ_OBJECT
public:
	BookmarkOwner(TQWidget* parent);

	// KBookmarkOwner interface
	void openBookmarkURL(const TQString&);
	TQString currentURL() const;
	
public slots:
	void setURL(const KURL&);

signals:
	void openURL(const KURL&);

private:
	KURL mURL;
};


} // namespace
#endif

