/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2005-04-02
 * Description : setup showfoto tab.
 *
 * Copyright (C) 2005-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 * Copyright (C) 2008 by Arnd Baecker <arnd dot baecker at web dot de>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// TQt includes.

#include <tqlayout.h>
#include <tqcolor.h>
#include <tqhbox.h>
#include <tqvgroupbox.h>
#include <tqlabel.h>
#include <tqwhatsthis.h>
#include <tqcheckbox.h>
#include <tqcombobox.h>

// KDE includes.

#include <klocale.h>
#include <kdialog.h>
#include <kcolorbutton.h>
#include <knuminput.h>
#include <kconfig.h>
#include <kapplication.h>

// Local includes.

#include "setupeditor.h"
#include "setupeditor.moc"

namespace ShowFoto
{

class SetupEditorPriv
{
public:

    SetupEditorPriv()
    {
        backgroundColor       = 0;
        hideToolBar           = 0;
        hideThumbBar          = 0;
        horizontalThumbBar    = 0;
        showSplash            = 0;
        useTrash              = 0;
        exifRotateBox         = 0;
        exifSetOrientationBox = 0;
        overExposureColor     = 0;
        underExposureColor    = 0;
        themebackgroundColor  = 0;
        colorBox              = 0;
        sortOrderComboBox     = 0;
        sortReverse           = 0;
        useRawImportTool      = 0;
    }

    TQHBox        *colorBox;

    TQCheckBox    *sortReverse;
    TQCheckBox    *hideToolBar;
    TQCheckBox    *hideThumbBar;
    TQCheckBox    *horizontalThumbBar;
    TQCheckBox    *showSplash;
    TQCheckBox    *useTrash;
    TQCheckBox    *exifRotateBox;
    TQCheckBox    *exifSetOrientationBox;
    TQCheckBox    *themebackgroundColor;
    TQCheckBox    *useRawImportTool;

    TQComboBox    *sortOrderComboBox;

    KColorButton *backgroundColor;
    KColorButton *underExposureColor;
    KColorButton *overExposureColor;
};

SetupEditor::SetupEditor(TQWidget* parent )
           : TQWidget(parent)
{
    d = new SetupEditorPriv;
    TQVBoxLayout *layout = new TQVBoxLayout( parent, 0, KDialog::spacingHint() );

    // --------------------------------------------------------

    TQVGroupBox *interfaceOptionsGroup = new TQVGroupBox(i18n("Interface Options"), parent);

    d->themebackgroundColor = new TQCheckBox(i18n("&Use theme background color"),
                                            interfaceOptionsGroup);

    TQWhatsThis::add( d->themebackgroundColor, i18n("<p>Enable this option to use background theme "
                                              "color in image editor area") );

    d->colorBox                  = new TQHBox(interfaceOptionsGroup);
    TQLabel *backgroundColorlabel = new TQLabel( i18n("&Background color:"), d->colorBox);
    d->backgroundColor           = new KColorButton(d->colorBox);
    backgroundColorlabel->setBuddy(d->backgroundColor);
    TQWhatsThis::add( d->backgroundColor, i18n("<p>Select background color to use "
                                              "for image editor area.") );

    d->hideToolBar        = new TQCheckBox(i18n("H&ide toolbar in fullscreen mode"), interfaceOptionsGroup);
    d->hideThumbBar       = new TQCheckBox(i18n("Hide &thumbbar in fullscreen mode"), interfaceOptionsGroup);
    d->horizontalThumbBar = new TQCheckBox(i18n("Use &horizontal thumbbar (need to restart showFoto)"), interfaceOptionsGroup);
    TQWhatsThis::add( d->horizontalThumbBar, i18n("<p>If this option is enabled, the thumbnails bar will be displayed horizontally behind "
                                                 "the image area. You need to restart showFoto for this option take effect.<p>"));
    d->useTrash   = new TQCheckBox(i18n("&Deleting items should move them to trash"), interfaceOptionsGroup);
    d->showSplash = new TQCheckBox(i18n("&Show splash screen at startup"), interfaceOptionsGroup);

    d->useRawImportTool = new TQCheckBox(i18n("Use Raw Import Tool to handle Raw image"), interfaceOptionsGroup);
    TQWhatsThis::add(d->useRawImportTool, i18n("<p>Set on this option to use Raw Import "
                                              "tool before to load a Raw image, "
                                              "to customize indeep decoding settings."));

    // --------------------------------------------------------

    TQVGroupBox *exposureOptionsGroup = new TQVGroupBox(i18n("Exposure Indicators"), parent);

    TQHBox *underExpoBox         = new TQHBox(exposureOptionsGroup);
    TQLabel *underExpoColorlabel = new TQLabel( i18n("&Under-exposure color:"), underExpoBox);
    d->underExposureColor       = new KColorButton(underExpoBox);
    underExpoColorlabel->setBuddy(d->underExposureColor);
    TQWhatsThis::add( d->underExposureColor, i18n("<p>Customize color used in image editor to identify "
                                                 "under-exposed pixels.") );

    TQHBox *overExpoBox         = new TQHBox(exposureOptionsGroup);
    TQLabel *overExpoColorlabel = new TQLabel( i18n("&Over-exposure color:"), overExpoBox);
    d->overExposureColor       = new KColorButton(overExpoBox);
    overExpoColorlabel->setBuddy(d->overExposureColor);
    TQWhatsThis::add( d->overExposureColor, i18n("<p>Customize color used in image editor to identify "
                                                "over-exposed pixels.") );

    // --------------------------------------------------------

    TQVGroupBox *ExifGroupOptions = new TQVGroupBox(i18n("EXIF Actions"), parent);

    d->exifRotateBox = new TQCheckBox(ExifGroupOptions);
    d->exifRotateBox->setText(i18n("Show images/thumbs &rotated according to orientation tag"));

    d->exifSetOrientationBox = new TQCheckBox(ExifGroupOptions);
    d->exifSetOrientationBox->setText(i18n("Set orientation tag to normal after rotate/flip"));

     // --------------------------------------------------------

    TQVGroupBox *sortOptionsGroup = new TQVGroupBox(i18n("Sort order for images"), parent);

    TQHBox* sortBox       = new TQHBox(sortOptionsGroup);
    new TQLabel(i18n("Sort images by:"), sortBox);
    d->sortOrderComboBox = new TQComboBox(false, sortBox);
    d->sortOrderComboBox->insertItem(i18n("File Date"), 0);
    d->sortOrderComboBox->insertItem(i18n("File Name"), 1);
    d->sortOrderComboBox->insertItem(i18n("File size"), 2);
    TQWhatsThis::add(d->sortOrderComboBox, i18n("<p>Here, select whether newly-loaded "
                                               "images are sorted by file-date, file-name, or file-size."));

    d->sortReverse = new TQCheckBox(i18n("Reverse ordering"), sortOptionsGroup);
    TQWhatsThis::add(d->sortReverse, i18n("<p>If this option is enabled, newly-loaded "
                                         "images will be sorted in descending order."));

    // --------------------------------------------------------

    layout->addWidget(interfaceOptionsGroup);
    layout->addWidget(exposureOptionsGroup);
    layout->addWidget(ExifGroupOptions);
    layout->addWidget(sortOptionsGroup);
    layout->addStretch();

    // --------------------------------------------------------

    connect(d->themebackgroundColor, TQT_SIGNAL(toggled(bool)),
            this, TQT_SLOT(slotThemeBackgroundColor(bool)));

    readSettings();
}

SetupEditor::~SetupEditor()
{
    delete d;
}

void SetupEditor::slotThemeBackgroundColor(bool e)
{
    d->colorBox->setEnabled(!e);
}

void SetupEditor::readSettings()
{
    KConfig* config = kapp->config();
    TQColor Black(TQt::black);
    TQColor White(TQt::white);
    config->setGroup("ImageViewer Settings");
    d->themebackgroundColor->setChecked(config->readBoolEntry("UseThemeBackgroundColor", true));
    d->backgroundColor->setColor( config->readColorEntry("BackgroundColor", &Black ) );
    d->hideToolBar->setChecked(config->readBoolEntry("FullScreen Hide ToolBar", false));
    d->hideThumbBar->setChecked(config->readBoolEntry("FullScreenHideThumbBar", true));
    d->horizontalThumbBar->setChecked(config->readBoolEntry("HorizontalThumbbar", false));
    d->useTrash->setChecked(config->readBoolEntry("DeleteItem2Trash", false));
    d->showSplash->setChecked(config->readBoolEntry("ShowSplash", true));
    d->exifRotateBox->setChecked(config->readBoolEntry("EXIF Rotate", true));
    d->exifSetOrientationBox->setChecked(config->readBoolEntry("EXIF Set Orientation", true));
    d->underExposureColor->setColor(config->readColorEntry("UnderExposureColor", &White));
    d->overExposureColor->setColor(config->readColorEntry("OverExposureColor", &Black));
    d->sortOrderComboBox->setCurrentItem(config->readNumEntry("SortOrder", 0));
    d->sortReverse->setChecked(config->readBoolEntry("ReverseSort", false));
    d->useRawImportTool->setChecked(config->readBoolEntry("UseRawImportTool", false));
}

void SetupEditor::applySettings()
{
    KConfig* config = kapp->config();
    config->setGroup("ImageViewer Settings");
    config->writeEntry("UseThemeBackgroundColor", d->themebackgroundColor->isChecked());
    config->writeEntry("BackgroundColor",         d->backgroundColor->color());
    config->writeEntry("FullScreen Hide ToolBar", d->hideToolBar->isChecked());
    config->writeEntry("FullScreenHideThumbBar",  d->hideThumbBar->isChecked());
    config->writeEntry("HorizontalThumbbar",      d->horizontalThumbBar->isChecked());
    config->writeEntry("DeleteItem2Trash",        d->useTrash->isChecked());
    config->writeEntry("ShowSplash",              d->showSplash->isChecked());
    config->writeEntry("EXIF Rotate",             d->exifRotateBox->isChecked());
    config->writeEntry("EXIF Set Orientation",    d->exifSetOrientationBox->isChecked());
    config->writeEntry("UnderExposureColor",      d->underExposureColor->color());
    config->writeEntry("OverExposureColor",       d->overExposureColor->color());
    config->writeEntry("SortOrder",               d->sortOrderComboBox->currentItem());
    config->writeEntry("ReverseSort",             d->sortReverse->isChecked());
    config->writeEntry("UseRawImportTool",        d->useRawImportTool->isChecked());
    config->sync();
}

}   // namespace ShowFoto
