/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2006-02-22
 * Description : a generic widget to display metadata
 *
 * Copyright (C) 2006-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef METADATAWIDGET_H
#define METADATAWIDGET_H

// TQt includes.

#include <tqwidget.h>
#include <tqstring.h>

// KDE includes.

#include <kurl.h>

// Local includes.

#include "dmetadata.h"
#include "digikam_export.h"

namespace Digikam
{

class MetadataListView;
class MetadataWidgetPriv;

class DIGIKAM_EXPORT MetadataWidget : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT

public:

    enum Mode
    {
        SIMPLE=0,
        FULL
    };

public:

    MetadataWidget(TQWidget* parent, const char* name=0);
    ~MetadataWidget();

    int     getMode();
    void    setMode(int mode);

    TQString getCurrentItemKey() const;
    void    setCurrentItemByKey(const TQString& itemKey);

    void    setUserAreaWidget(TQWidget *w);

    virtual TQString getTagTitle(const TQString& key);
    virtual TQString getTagDescription(const TQString& key);

    virtual bool loadFromData(const TQString &fileName, const TQByteArray& data=TQByteArray());
    virtual bool loadFromURL(const KURL& url)=0;

private slots:

    void slotModeChanged(int);
    void slotCopy2Clipboard();
    void slotPrintMetadata();
    
protected slots:    
    
    virtual void slotSaveMetadataToFile()=0;
    
protected:

    void   enabledToolButtons(bool);
    void   setFileName(const TQString& fileName);
    MetadataListView* view();

    bool   setMetadata(const TQByteArray& data=TQByteArray());
    const  TQByteArray& getMetadata();

    void   setMetadataMap(const DMetadata::MetaDataMap& data=DMetadata::MetaDataMap());
    const  DMetadata::MetaDataMap& getMetadataMap();

    void   setIfdList(const DMetadata::MetaDataMap &ifds, const TQStringList& tagsFilter=TQStringList());
    void   setIfdList(const DMetadata::MetaDataMap &ifds, const TQStringList& keysFilter,
                      const TQStringList& tagsFilter);

    KURL   saveMetadataToFile(const TQString& caption, const TQString& fileFilter);
    bool   storeMetadataToFile(const KURL& url);

    virtual void buildView();
    virtual bool decodeMetadata()=0;
    virtual TQString getMetadataTitle()=0;
    virtual void setMetadataEmpty();

private:

    MetadataWidgetPriv* d;
};

}  // namespace Digikam

#endif /* METADATAWIDGET_H */
