/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2004-08-19
 * Description : Album item file tip adapted from kfiletip 
 *               (konqueror - konq_iconviewwidget.cc)
 *
 * Copyright (C) 1998-1999 by Torben Weis <weis@kde.org>
 * Copyright (C) 2000-2002 by David Faure <david@mandrakesoft.com>
 * Copyright (C) 2004-2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright (C) 2006-2007 by Gilles Caulier <caulier dot gilles at gmail dot com> 
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef ALBUMFILETIP_H
#define ALBUMFILETIP_H

// TQt includes.

#include <tqframe.h>
#include <tqstring.h>

namespace Digikam
{

class AlbumIconView;
class AlbumIconItem;
class AlbumFileTipPriv;

class AlbumFileTip : public TQFrame
{
public:

    AlbumFileTip(AlbumIconView* view);
    ~AlbumFileTip();

    void setIconItem(AlbumIconItem* iconItem);

protected:

    bool event(TQEvent *e);
    void resizeEvent(TQResizeEvent* e);
    void drawContents(TQPainter *p);

private:

    void    reposition();
    void    renderArrows();
    void    updateText();
    TQString breakString(const TQString& str);

private:

    AlbumFileTipPriv *d;
};

}  // namespace Digikam

#endif /* ALBUMFILETIP_H */
