//
// AmarokSystray
//
// Author: Stanislav Karchebny <berkus@users.sf.net>, (C) 2003
//
// Copyright: like rest of Amarok
//

#ifndef AMAROKSYSTRAY_H
#define AMAROKSYSTRAY_H

#include "engineobserver.h" //baseclass
#include <ksystemtray.h>
#include <tqpixmap.h>

class App;

namespace Amarok {

class TrayIcon : public KSystemTray, public EngineObserver
{
public:
    TrayIcon( TQWidget* );
    friend class ::App;

protected:
    // reimpl from engineobserver
    virtual void engineStateChanged( Engine::State state, Engine::State oldState = Engine::Empty );
    virtual void engineNewMetaData( const MetaBundle &bundle, bool trackChanged );
    virtual void engineTrackPositionChanged( long position, bool /*userSeek*/ );
    // get notified of 'highlight' color change
    virtual void paletteChange( const TQPalette & oldPalette );
    void resizeEvent ( TQResizeEvent * );

private:
    bool event( TQEvent* );
    void setLastFm( bool );

    // repaints trayIcon showing progress (and overlay if present)
    void paintIcon( int mergePixels = -1, bool force = false );
    // blend an overlay icon over 'sourcePixmap' and repaint trayIcon
    void blendOverlay( TQPixmap &sourcePixmap );

    long trackLength, mergeLevel;
    TQPixmap baseIcon, grayedIcon, alternateIcon;
    TQPixmap playOverlay, pauseOverlay;
    TQPixmap *overlay;   // the current overlay (may be NULL)
    int blinkTimerID;   // timer ID returned by TQObject::startTimer()
    bool overlayVisible;// used for blinking / hiding overlay
    /** whether the last.fm icons are visible **/
    bool m_lastFmMode;
};

}

#endif
