// (c) 2004 Christian Muehlhaeuser <chris@chris.de>
// (c) 2005 Reigo Reinmets <xatax@hot.ee>
// (c) 2005 Mark Kretschmann <markey@web.de>
// (c) 2006 Peter C. Ndikuwera <pndiku@gmail.com>
// License: GNU General Public License V2


#ifndef AMAROK_CONTEXTBROWSER_H
#define AMAROK_CONTEXTBROWSER_H

#include "amarokdcophandler.h"
#include "clicklineedit.h"
#include "engineobserver.h"

#include <ktabwidget.h>
#include <ktoolbarbutton.h>
#include <kurl.h>

class ClickLineEdit;
class CollectionDB;
class Color;
class HTMLView;
class KPopupMenu;
class MetaBundle;
class TQPalette;
class TQVBox;
class TQLineEdit;
class TQComboBox;
class KDialogBase;
class KTabBar;
class KTextEdit;

class CueFile;

namespace Browser { class ToolBar; }
namespace KIO { class Job; class TransferJob; }


class ContextBrowser : public KTabWidget, public EngineObserver
{
    Q_OBJECT
  TQ_OBJECT

        friend class CurrentTrackJob;
        friend class Amarok::DcopContextBrowserHandler;

        static ContextBrowser *s_instance;

    public:
        ContextBrowser( const char *name );
       ~ContextBrowser();

        static ContextBrowser *instance() { return s_instance; }

        void setFont( const TQFont& );
        void reloadStyleSheet();
        static KURL::List expandURL( const KURL &url ); // expand urls (album, compilation, ...)
        static bool hasContextProtocol( const KURL &url ); // is url expandable by context browser?

        virtual bool eventFilter( TQObject *o, TQEvent *e ); //required by the labels dialog

    public slots:
        void openURLRequest(const KURL &url );
        void collectionScanStarted();
        void collectionScanDone( bool changed );
        void renderView();
        void lyricsChanged( const TQString& );
        void lyricsScriptChanged();
        void lyricsResult( TQCString cXmlDoc, bool cached = false );

    protected:
        void engineNewMetaData( const MetaBundle&, bool );
        void engineStateChanged( Engine::State, Engine::State = Engine::Empty );
        void paletteChange( const TQPalette& );

    protected slots:
        void wheelDelta( int delta );

    private slots:
        void tabChanged( TQWidget *page );
        void slotContextMenu( const TQString& urlString, const TQPoint& point );
        void showContext( const KURL& url, bool fromHistory = false );
        void showCurrentTrack();
        void showLyrics( const TQString& url = TQString() );
        void showWikipedia( const TQString& url = TQString(), bool fromHistory = false, bool replaceHistory = false );
        void showWikipediaEntry( const TQString& entry, bool replaceHistory = false );
        void reloadWikipedia();
        void showLabelsDialog();

        void coverFetched( const TQString &artist, const TQString &album );
        void coverRemoved( const TQString &artist, const TQString &album );
        void similarArtistsFetched( const TQString &artist );
        void imageFetched( const TQString &remoteURL );
        void tagsChanged( const MetaBundle &bundle );
        void tagsChanged( const TQString &oldArtist, const TQString &oldAlbum );
        void ratingOrScoreOrLabelsChanged( const TQString &path );
        void refreshCurrentTrackPage();

        void contextHistoryBack();

        void lyricsAdd();
        void lyricsEditToggle();
        void lyricsSearch();
        void lyricsRefresh();
        void lyricsExternalPage();

	void lyricsSearchText( const TQString &text );
	void lyricsSearchTextNext();
	void lyricsSearchTextHide();
	void lyricsSearchTextShow();
	void lyricsSearchTextToggle();

        void wikiHistoryBack();
        void wikiHistoryForward();
        void wikiBackPopupActivated( int id );
        void wikiForwardPopupActivated( int id );
        void wikiArtistPage();
        void wikiAlbumPage();
        void wikiTitlePage();
        void wikiExternalPage();
        void wikiResult( KIO::Job* job );
        void wikiConfigApply();
        void wikiConfig();
        void wikiConfigChanged( int activeItem );

    private:
        enum { CONTEXT_BACK, CONTEXT_FORWARD, CONTEXT_CURRENT, CONTEXT_HOME, CONTEXT_SEARCH };
        enum { LYRICS_ADD, LYRICS_EDIT, LYRICS_SEARCH, LYRICS_REFRESH, LYRICS_BROWSER };
        enum { WIKI_BACK, WIKI_FORWARD, WIKI_ARTIST, WIKI_ALBUM, WIKI_TITLE, WIKI_BROWSER, WIKI_CONFIG };
        typedef enum {SHOW_ALBUM_NORMAL, SHOW_ALBUM_SCORE, SHOW_ALBUM_LEAST_PLAY} T_SHOW_ALBUM_TYPE;
        static const uint WIKI_MAX_HISTORY = 20;
        static const uint CONTEXT_MAX_HISTORY = 20;

        void showIntroduction();
        void saveHtmlData();
        void showScanning();

        static TQString getEncodedImage( const TQString &imageUrl );

        static TQString wikiLocale();
        static void setWikiLocale( const TQString &locale );
        static TQString wikiURL( const TQString &item );
        TQString wikiArtistPostfix() const;
        TQString wikiAlbumPostfix() const;
        TQString wikiTrackPostfix() const;

        HTMLView    *m_currentTrackPage;
        HTMLView    *m_lyricsPage;
        HTMLView    *m_wikiPage;

        TQVBox        *m_contextTab;
        TQVBox        *m_lyricsTab;
        TQVBox        *m_wikiTab;
        // These controls are used to dictate whether the page should be rebuilt
        // true -> need rebuild
        bool          m_dirtyCurrentTrackPage;
        bool          m_dirtyLyricsPage;
        bool          m_dirtyWikiPage;

        TQStringList   m_contextBackHistory;
        KURL          m_contextURL;

        TQString       m_styleSheet;
        bool          m_emptyDB;
        TQString       m_lyricAddUrl;
        TQString       m_lyricSearchUrl;
        TQString       m_lyricCurrentUrl;
        Browser::ToolBar* m_lyricsToolBar;
        KTextEdit*    m_lyricsTextEdit;
        TQString       m_lyricsBeingEditedUrl;
        TQString       m_lyricsBeingEditedArtist;
        TQString       m_lyricsBeingEditedTitle;
        ClickLineEdit* m_lyricsSearchText;
        KToolBar*     m_lyricsTextBar;
        bool          m_lyricsTextBarShowed;


        TQString       m_wiki;
        TQString       m_wikiLanguages;
        static TQString s_wikiLocale;
        TQString       m_wikiBaseUrl;
        TQString       m_wikiCurrentUrl;
        TQString       m_wikiCurrentEntry;
        TQStringList   m_wikiBackHistory;
        TQStringList   m_wikiForwardHistory;
        KPopupMenu*   m_wikiBackPopup;
        KPopupMenu*   m_wikiForwardPopup;
        KIO::TransferJob* m_wikiJob;
        Browser::ToolBar* m_wikiToolBar;
        TQLineEdit*    m_wikiLocaleEdit;
        TQComboBox*    m_wikiLocaleCombo;
        KDialogBase*  m_wikiConfigDialog;

        TQString       m_HTMLSource;
        TQStringList   m_metadataHistory;
        KURL          m_currentURL;

        bool          m_relatedOpen;
        bool          m_suggestionsOpen;
        bool          m_favoritesOpen;
        bool          m_labelsOpen;
        bool          m_showRelated;
        bool          m_showSuggested;
        bool          m_showFaves;
        bool          m_showLabels;

        bool          m_showFreshPodcasts;
        bool          m_showFavoriteAlbums;
        bool          m_showNewestAlbums;

        bool          m_browseArtists;
        TQString       m_artist;
        TQStringList   m_shownAlbums;

        bool          m_browseLabels;
        TQString       m_label;
        ClickLineEdit* m_addLabelEdit;
        TQListView*    m_labelListView;

        CueFile      *m_cuefile;
};

#endif /* AMAROK_CONTEXTBROWSER_H */
