/***************************************************************************
 *   Copyright (C) 2004, 2005 Max Howell <max.howell@methylblue.com>       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BROWSERBAR_H
#define BROWSERBAR_H

#include "amarok_export.h"  //LIBAMAROK_EXPORT
#include "engineobserver.h" //baseclass

#include <tqwidget.h>        //baseclass
#include <tqvaluevector.h>   //stack allocated
#include <tqmap.h>           //stack allocated
#include <tqpushbutton.h>

typedef TQValueVector<TQWidget*> BrowserList;
typedef TQMap<TQString,int> BrowserIdMap;

class MultiTabBar;
class MultiTabBarTab;
class DropProxyTarget;
class KURL;
class TQSignalMapper;
class TQVBox;


class BrowserBar : public TQWidget, public EngineObserver
{
    Q_OBJECT
  TQ_OBJECT

public:
    BrowserBar( TQWidget *parent );
   ~BrowserBar();

    LIBAMAROK_EXPORT static BrowserBar* instance() { return s_instance; }
    TQVBox *container() const { return m_playlistBox; }
    TQVBox *browserBox() const { return m_browserBox; }

    TQWidget *browser( const TQString& ) const;
    TQWidget *browser( int index ) const { if( index < 0 ) index = 0; return m_browsers[index]; }
    TQWidget *currentBrowser() const { return m_currentIndex < 0 ? 0 : browser( m_currentIndex ); }

    int count() const { return m_browsers.count(); }
    int visibleCount() const;

    void addBrowser( const TQString &identifier, TQWidget*, const TQString&, const TQString& );
    void removeMediaBrowser( TQWidget *widget );
    int indexForName( const TQString& ) const;
    int restoreWidth();

    /// for internal use
    void mouseMovedOverSplitter( TQMouseEvent* );
    void makeDropProxy( const TQString &browserName, DropProxyTarget *finalTarget );

protected:
    virtual bool event( TQEvent* );
    virtual void polish();

protected:
    virtual void engineStateChanged( Engine::State, Engine::State = Engine::Empty );

public slots:
    void showBrowser( const TQString& name ) { showBrowser( indexForName( name ) ); }
    void showBrowser( int index ) { if( index != m_currentIndex ) showHideBrowser( index ); }
    void showHideBrowser( int );
    void showHideVisibleBrowser( int );
    void closeCurrentBrowser() { showHideBrowser( m_currentIndex ); }
    void showBrowserSelectionMenu();

signals:
    void browserActivated( int );

private:
    void adjustWidgetSizes();
    uint maxBrowserWidth() const { return width() * 2 / 3; }

    static const int DEFAULT_HEIGHT = 50;

    LIBAMAROK_EXPORT static BrowserBar    *s_instance;
    uint           m_pos;         ///the x-axis position of m_divider
    TQVBox         *m_playlistBox; ///parent to playlist, playlist filter and toolbar
    TQWidget       *m_divider;     ///a qsplitter like widget
    MultiTabBar   *m_tabBar;
    BrowserList    m_browsers;
    BrowserIdMap   m_browserIds;
    TQVBox         *m_browserBox;  ///parent widget to the browsers
    int            m_currentIndex;
    int            m_lastIndex;
    TQSignalMapper *m_mapper;      ///maps tab clicks to browsers

    TQPushButton   *m_tabManagementButton;


    
};

#endif
