#################################################
#
#  (C) 2010 Serghei Amelian
#  serghei (DOT) amelian (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

if( BUILD_TRANSLATIONS AND NOT DEFINED MSGFMT_EXECUTABLE )
  find_program( MSGFMT_EXECUTABLE msgfmt )
  if( NOT MSGFMT_EXECUTABLE )
    tde_message_fatal( "msgfmt program is required, but was not found on your system" )
  endif( )
endif( )

check_type_size( "int" SIZEOF_INT BUILTIN_TYPES_ONLY )
check_type_size( "long" SIZEOF_LONG BUILTIN_TYPES_ONLY )

check_include_file( stdint.h HAVE_STDINT_H )
check_include_file( systems.h HAVE_SYSTEMS_H )

##### check for inotify ###########################

if( WITH_INOTIFY )
  check_include_file( "inotify.h" INOTIFY_FOUND )
  check_include_file( "sys/inotify.h" INOTIFY_SYS_FOUND )
  if( NOT INOTIFY_FOUND )
    if( NOT INOTIFY_SYS_FOUND )
      message(FATAL_ERROR "\ninotify support was requested, but inotify was not found on your system" )
    endif( NOT INOTIFY_SYS_FOUND )
  endif( NOT INOTIFY_FOUND )
  if( INOTIFY_FOUND )
      set( HAVE_INOTIFY 1 )
  endif( INOTIFY_FOUND )
  if( INOTIFY_SYS_FOUND )
      set( HAVE_INOTIFY 1 )
      set( HAVE_SYS_INOTIFY 1 )
  endif( INOTIFY_SYS_FOUND )
endif( )

check_function_exists( statvfs HAVE_STATVFS )


# sched_setaffinity buggy glibc check
check_c_source_compiles("
  #define _GNU_SOURCE
  #include <sched.h>
  int main() {
    cpu_set_t mask;
    CPU_ZERO(&mask);
    CPU_SET(0, &mask);
    sched_setaffinity(0, sizeof(mask), &mask);
    return 0;
  } "
  SCHEDAFFINITY_3PARAMS )

if( SCHEDAFFINITY_3PARAMS )
  set( SCHEDAFFINITY_SUPPORT 1 )
else( )
  check_c_source_compiles("
  #define _GNU_SOURCE
  #include <sched.h>
  int main() {
    cpu_set_t mask;
    CPU_ZERO(&mask);
    CPU_SET(0, &mask);
    sched_setaffinity(0, &mask);
    return 0;
  } "
  SCHEDAFFINITY_SUPPORT )
endif( )


# fabsf
tde_save( CMAKE_REQUIRED_LIBRARIES )
set( CMAKE_REQUIRED_LIBRARIES m )
check_function_exists( fabsf HAVE_FABSF )
tde_restore( CMAKE_REQUIRED_LIBRARIES )


# taglib
pkg_search_module( TAGLIB taglib )
if( TAGLIB_FOUND )
  if( ${TAGLIB_VERSION} VERSION_LESS "1.5" )
    tde_message_fatal( "taglib version must be at least 1.5" )
  else( )
    set( TAGLIB_15 1 )
  endif( )
else( )
  tde_message_fatal( "taglib are required, but not found on your system" )
endif( )


# sqlite3
pkg_search_module( SQLITE sqlite3 )
if( NOT SQLITE_FOUND )
  tde_message_fatal( "sqlite3 are required, but not found on your system" )
endif( )


# libvisual
if( WITH_LIBVISUAL )

  pkg_search_module( SDL sdl )
  if( NOT SDL_FOUND )
    check_include_file( SDL/SDL.h HAVE_SDL_H )
    if( NOT HAVE_SDL_H )
      tde_message_fatal( "SDL are required, but not found on your system" )
    endif ( )
    set ( SDL_INCLUDE_DIRS /usr/include/SDL )
    set ( SDL_LIBRARIES SDL pthread )
  endif( )

  pkg_search_module( LIBVISUAL libvisual-0.4 )
  if( LIBVISUAL_FOUND )
    if( ${LIBVISUAL_VERSION} VERSION_LESS "0.4.0" )
      tde_message_fatal( "libvisual version must be at least 0.4.0" )
    endif( )
  else( )
    tde_message_fatal( "libvisual are requested, but not found on your system" )
  endif( )
  set( HAVE_LIBVISUAL 1 )

endif( )


# xine-engine
if( WITH_XINE )
  pkg_search_module( XINE libxine )
  if( XINE_FOUND )
    if( ${XINE_VERSION} VERSION_LESS "1.0.2" )
      tde_message_fatal( "your xine version is too old; at least 1.0.2 is required" )
    endif( )
  else( )
    tde_message_fatal( "xine is requested, but was not found on your system" )
  endif( )
endif( )

# akode-engine
if( WITH_AKODE )
  pkg_search_module( AKODE akode )
  if( AKODE_FOUND )
    if( ${AKODE_VERSION} VERSION_LESS "2.0.0" )
      tde_message_fatal( "your akode version is too old; at least 2.0.0 is required" )
    endif( )
  else( )
    tde_message_fatal( "akode is requested, but was not found on your system" )
  endif( )
endif( )


# iPod
if( WITH_IPOD )

  pkg_search_module( GPOD libgpod-1.0 )
  if( GPOD_FOUND )
    if( ${GPOD_VERSION} VERSION_LESS "0.4.2" )
      tde_message_fatal( "your libgpod version is too old; at least 0.4.2 is required" )
    elseif( NOT ${GPOD_VERSION} VERSION_LESS "0.6.0" )
      set( HAVE_GPOD_060 1 )
    endif( )
  else( )
    tde_message_fatal( "libgpod-1.0 is requested, but was not found on your system" )
  endif( )

  tde_save( CMAKE_REQUIRED_INCLUDES )
  set( CMAKE_REQUIRED_INCLUDES ${GPOD_INCLUDE_DIRS} )
  check_struct_has_member( "struct _Itdb_Track" mediatype "gpod/itdb.h" HAVE_ITDB_MEDIATYPE )
  tde_restore( CMAKE_REQUIRED_INCLUDES )

  set( GPOD_LIBRARY gpod )

endif( )


# common required stuff
find_package( TQt )
find_package( TDE )


# check for Qt with OpenGL support
tde_save( CMAKE_REQUIRED_INCLUDES CMAKE_REQUIRED_LIBRARIES )
set( CMAKE_REQUIRED_INCLUDES ${QT_INCLUDE_DIRS} )
set( CMAKE_REQUIRED_LIBRARIES -L${QT_LIBRARY_DIRS} ${QT_LIBRARIES} )
check_cxx_source_compiles("
  #include <qgl.h>
  int main(int, char**) { (void)new QGLWidget((QWidget*)0, \"qgl\"); return 0; } "
  HAVE_QGLWIDGET )
tde_restore( CMAKE_REQUIRED_INCLUDES CMAKE_REQUIRED_LIBRARIES )


# konqsidebarplugin.h
if( WITH_KONQSIDEBAR )
  tde_save( CMAKE_REQUIRED_DEFINITIONS CMAKE_REQUIRED_FLAGS CMAKE_REQUIRED_INCLUDES CMAKE_REQUIRED_LIBRARIES )
  set( CMAKE_REQUIRED_DEFINITIONS ${TQT_CFLAGS_OTHER} )
  set( CMAKE_REQUIRED_INCLUDES ${TDE_INCLUDE_DIR};${TQT_INCLUDE_DIRS};${CMAKE_INCLUDE_PATH} )
  set( CMAKE_REQUIRED_FLAGS "-include tqt.h" )
  set( CMAKE_REQUIRED_LIBRARIES -L${TQT_LIBRARY_DIRS} -L${QT_LIBRARY_DIRS} ${TQT_LIBRARIES} )
  check_cxx_source_compiles("
    #include <konqsidebarplugin.h>
    int main(int, char**) { return 0; } "
    HAVE_KONQSIDEBARPLUGIN_H )
  tde_restore( CMAKE_REQUIRED_DEFINITIONS CMAKE_REQUIRED_FLAGS CMAKE_REQUIRED_INCLUDES CMAKE_REQUIRED_LIBRARIES )
  if( NOT HAVE_KONQSIDEBARPLUGIN_H )
    tde_message_fatal( "konqsidebarplugin.h are requested, but not found on your system" )
  endif( )
endif( )

##### check for mp4v2 ###########################

if( WITH_MP4V2 )
  check_include_file( "mp4v2/mp4v2.h" MP4V2_H_FOUND )
  if( MP4V2_H_FOUND )
    set( HAVE_MP4V2_H 1)
  else( MP4V2_H_FOUND )
    check_include_file( "mp4.h" MP4_H_FOUND )
    if( MP4_H_FOUND )
      set( HAVE_MP4_H 1)
    endif( MP4_H_FOUND )
  endif( MP4V2_H_FOUND )

  if( HAVE_MP4V2_H OR HAVE_MP4_H )
    set( HAVE_MP4V2 1 )
  else( )
    tde_message_fatal( "MP4V2 support was requested, but not found on your system" )
  endif( )
endif( )
