//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQIODevice;
import org.trinitydesktop.qt.TQIODeviceInterface;

/**

   This class implements a tdeioslave to access zip files from KDE.
   You can use it in IO_ReadOnly or in IO_WriteOnly mode, and it
   behaves just as expected.
   It can also be used in IO_ReadWrite mode, in this case one can
   append files to an existing zip archive. When you append new files, which
   are not yet in the zip, it works as expected, i.e. the files are appended at the end.
   When you append a file, which is already in the file, the reference to the
   old file is dropped and the new one is added to the zip - but the
   old data from the file itself is not deleted, it is still in the
   zipfile. so when you want to have a small and garbage-free zipfile,
   just read the contents of the appended zip file and write it to a new one
   in IO_WriteOnly mode. This is especially important when you don't want
   to leak information of how intermediate versions of files in the zip
   were looking.
   For more information on the zip fileformat go to
   http://www.pkware.com/products/enterprise/white_papers/appnote.html
		@author Holger Schroeder <holger-kde@holgis.net>

		@short A class for reading/writing zip archives.

*/
public class KZip extends KArchive  {
	protected KZip(Class dummy){super((Class) null);}
	/**
		 Describes the contents of the "extra field" for a given file in the Zip archive.
		     		@short    Describes the contents of the "extra field" for a given file in the Zip archive.
	*/
	public static final int NoExtraField = 0;
	public static final int ModificationTime = 1;
	public static final int DefaultExtraField = 1;

	/**
		 Describes the compression type for a given file in the Zip archive.
		     		@short    Describes the compression type for a given file in the Zip archive.
	*/
	public static final int NoCompression = 0;
	public static final int DeflateCompression = 1;

	/**
		 Creates an instance that operates on the given filename.
		 using the compression filter associated to given mimetype.
			@param filename is a local path (e.g. "/home/holger/myfile.zip")
		     		@short    Creates an instance that operates on the given filename.
	*/
	public KZip(String filename) {
		super((Class) null);
		newKZip(filename);
	}
	private native void newKZip(String filename);
	/**
		 Creates an instance that operates on the given device.
		 The device can be compressed (KFilterDev) or not (TQFile, etc.).
		 @warning Do not assume that giving a TQFile here will decompress the file,
		 in case it's compressed!
			@param dev the device to access
		     		@short    Creates an instance that operates on the given device.
	*/
	public KZip(TQIODeviceInterface dev) {
		super((Class) null);
		newKZip(dev);
	}
	private native void newKZip(TQIODeviceInterface dev);
	/**
		 The name of the zip file, as passed to the constructor.
		 Null if you used the TQIODevice constructor.
				@return the zip's file name, or null if a TQIODevice is used

		@short    The name of the zip file, as passed to the constructor.
	*/
	public native String fileName();
	/**
		 Call this before writeFile or prepareWriting, to define what the next
		 file to be written should have in its extra field.
			@param ef the type of "extra field"
				@short    Call this before writeFile or prepareWriting, to define what the next  file to be written should have in its extra field.
		@see #extraField
	*/
	public native void setExtraField(int ef);
	/**
		 The current type of "extra field" that will be used for new files.
				@return the current type of "extra field"

		@short    The current type of "extra field" that will be used for new files.
		@see #setExtraField
	*/
	public native int extraField();
	/**
		 Call this before writeFile or prepareWriting, to define whether the next
		 files to be written should be compressed or not.
			@param c the new compression mode
				@short    Call this before writeFile or prepareWriting, to define whether the next  files to be written should be compressed or not.
		@see #compression
	*/
	public native void setCompression(int c);
	/**
		 The current compression mode that will be used for new files.
				@return the current compression mode

		@short    The current compression mode that will be used for new files.
		@see #setCompression
	*/
	public native int compression();
	/**
		 If an archive is opened for writing then you can add a new file
		 using this function.
		 This method takes the whole data at once.
			@param name can include subdirs e.g. path/to/the/file
			@param user the user owning the file
			@param group the group owning the file
			@param size the size of the file
			@param data a pointer to the data
				@return true if successful, false otherwise

		@short    If an archive is opened for writing then you can add a new file  using this function.
	*/
	public native boolean writeFile(String name, String user, String group, int size, String data);
	/**
		 Alternative method for writing: call prepareWriting(), then feed the data
		 in small chunks using writeData(), and call doneWriting() when done.
			@param name can include subdirs e.g. path/to/the/file
			@param user the user owning the file
			@param group the group owning the file
			@param size unused argument
				@return true if successful, false otherwise

		@short    Alternative method for writing: call prepareWriting(), then feed the data  in small chunks using writeData(), and call doneWriting() when done.
	*/
	public native boolean prepareWriting(String name, String user, String group, int size);
	public native boolean writeSymLink(String name, String target, String user, String group, long perm, int atime, int mtime, int ctime);
	public native boolean prepareWriting(String name, String user, String group, int size, long perm, int atime, int mtime, int ctime);
	public native boolean writeFile(String name, String user, String group, int size, long perm, int atime, int mtime, int ctime, String data);
	/**
		 Write data to a file that has been created using prepareWriting().
			@param data a pointer to the data
			@param size the size of the chunk
				@return true if successful, false otherwise

		@short    Write data to a file that has been created using prepareWriting().
	*/
	public native boolean writeData(String data, int size);
	/**
		 Write data to a file that has been created using prepareWriting().
			@param size the size of the file
				@return true if successful, false otherwise

		@short    Write data to a file that has been created using prepareWriting().
	*/
	public native boolean doneWriting(int size);
	/**
		 Opens the archive for reading.
		 Parses the directory listing of the archive
		 and creates the KArchiveDirectory/KArchiveFile entries.
			@param mode the mode of the file
		     		@short    Opens the archive for reading.
	*/
	protected native boolean openArchive(int mode);
	protected native boolean closeArchive();
	/**
			     		@short
	*/
	public native boolean writeDir(String name, String user, String group);
	/**	 @internal for virtual_hook 		@short   @internal for virtual_hook
	*/
	protected native boolean writeData_impl(String data, int size);
	protected native boolean prepareWriting_impl(String name, String user, String group, int size, long perm, int atime, int mtime, int ctime);
	protected native boolean writeSymLink_impl(String name, String target, String user, String group, long perm, int atime, int mtime, int ctime);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
