//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import org.trinitydesktop.qt.TQHideEvent;
import org.trinitydesktop.qt.TQMetaObject;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQCloseEvent;
import org.trinitydesktop.qt.TQObject;
import org.trinitydesktop.qt.TQPixmap;
import org.trinitydesktop.qt.TQSize;
import org.trinitydesktop.qt.TQGrid;
import org.trinitydesktop.qt.TQKeyEvent;
import org.trinitydesktop.qt.TQPushButton;
import org.trinitydesktop.qt.TQWidget;
import org.trinitydesktop.qt.TQVBox;
import org.trinitydesktop.qt.TQFrame;
import org.trinitydesktop.qt.TQHBox;

/**

 Provides basic functionality needed by nearly all dialogs.
 It offers the standard action buttons you'd expect to find in a
 dialog as well as the capability to define at most three configurable
 buttons. You can define a main widget that contains your specific
 dialog layout or you can use a predefined layout. Currently, <code>TreeList</code>/Paged, <code>Tabbed</code>, <code>Plain</code>, <code>Swallow</code> and <code>IconList</code>
 mode layouts (faces) are available.
 The class takes care of the geometry management. You only need to define
 a minimum size for the widget you want to use as the main widget.
 You can set a background tile (pixmap) for parts of the dialog. The
 tile you select is shared by all instances of this class in your
 application so that they all get the same look and feel.
 There is a tutorial available on http://developer.kde.org/ (NOT YET)
 that contains
 copy/paste examples as well a screenshots on how to use this class.
 <li><b>Standard buttons (action buttons):</b></li>
 You select which buttons should be displayed, but you do not choose the
 order in which they are displayed. This ensures a standard interface in
 KDE. The button order can be changed, but this ability is only available
 for a central KDE control tool. The following buttons are available:
 OK, Cancel/Close, Apply/Try, Default, Help and three user definable
 buttons: User1, User2 and User3. You must specify the text of the UserN
 buttons. Each button has a slot so you can overload the method
 when required. The default slots emit a signal as well, so you can choose
 to connect a signal instead of overriding the slot.
 The default implementation of slotHelp() will automatically enable
 the help system if you have provided a path to the help text.
 slotCancel() and slotClose() will run TQDialog.reject()
 while slotOk() will run TQDialog.accept(). You define a default
 button in the constructor.
 If you don't want any buttons at all because your dialog is special
 in some way, then set the buttonMask argument in the constructor to zero
 (0). The optional button box separator line should not be enabled
 in this case. Note that the KDialogBase will animate a button press
 when the user press Escape. The button that is enabled is either Cancel,
 Close or the button that is defined by setEscapeButton() The
 animation will not take place when the buttonMask is zero. Your
 custom dialog code should reimplement the keyPressEvent and
 animate the cancel button so that the dialog behaves like regular
 dialogs. NOTE: None of the regular slots (like slotOk() ) or
 signals that are related to the standard action buttons will be used
 when you don't use these buttons.
 <li><b>Dialog shapes:</b></li>
 You can either use one of the prebuilt, easy to use, faces or
 define your own main widget. The dialog provides ready to use
 TreeList, Tabbed, Plain, Swallow and IconList faces. KDialogBase uses
 the KJanusWidget class internally to accomplish this. If you
 use TreeList, Tabbed or IconList mode, then add pages with addPage().
 Pages that have been added can be removed again by simply deleting
 the page.
 If you want complete control of how the dialog contents should look,
 then you can define a main widget by using setMainWidget(). You
 only need to set the minimum size of that widget and the dialog will
 resize itself to fit this minimum size.  The dialog is resizeable, but
 cannot be made smaller than its minimum size.
 <li><b>Layout:</b></li>
 The dialog consists of a help area on top (becomes visible if you define
 a help path and use enableLinkedHelp()), the main area which is
 the built-in dialog face or your own widget in the middle and by default
 a button box at the bottom. The button box can also be placed at the
 right edge (to the right of the main widget). Use
 setButtonBoxOrientation() to control this behavior. A separator
 can be placed above the button box (or to the left when the button box
 is at the right edge). Normally you specify that you want a separator
 in the constructor, but you can use enableButtonSeparator() as well.
 <li><b>Standard compliance:</b></li>
 The class is derived from KDialog, so you get automatic access to
 the KDialog.marginHint(), KDialog.spacingHint() and the
 extended KDialog.setCaption() method. NOTE: The main widget you
 use will be positioned inside the dialog using a margin (or border)
 equal to KDialog.marginHint(). You should not add a margin yourself,
 since one will be added automatically.
 The example below (from kedit) shows how you use the top level widget
 and its layout. The second argument (the border) to TQVBoxLayout
 is 0. This situation is valid for addPage , addVBoxPage ,
 addHBoxPage , addGridPage , makeMainWidget ,
 makeVBoxMainWidget , makeHBoxMainWidget and
 makeGridMainWidget as well.
 Example:
 <pre>
 UrlDlg.UrlDlg( TQWidget parent, String caption,
                 String urltext)
 {
   TQWidget page = new TQWidget( this );
   setMainWidget(page);
   TQVBoxLayout topLayout = new TQVBoxLayout( page, 0, spacingHint() );
   TQLabel label = new TQLabel( caption, page, "caption" );
   topLayout.addWidget( label );
   lineedit = new TQLineEdit( urltext, page, "lineedit" );
   lineedit.setMinimumWidth(fontMetrics().maxWidth()*20);
   topLayout.addWidget( lineedit );
   topLayout.addStretch(10);
 }
 </pre>
 If you use makeVBoxMainWidget(), then the dialog above can be made
 simpler but you lose the ability to add a stretchable area:
 <pre>
 UrlDlg.UrlDlg( TQWidget parent, String caption,
                 String urltext)
 {
   TQVBox page = makeVBoxMainWidget();
   TQLabel label = new TQLabel( caption, page, "caption" );
   lineedit = new TQLineEdit( urltext, page, "lineedit" );
   lineedit.setMinimumWidth(fontMetrics().maxWidth()*20);
 }
 </pre>
 This class can be used in many ways. Note that most KDE ui widgets
 and many of KDE core applications use the KDialogBase so for more
 inspiration you should study the code for these.
 See {@link KDialogBaseSignals} for signals emitted by KDialogBase
		@author Mirko Boehm (mirko@kde.org) and Espen Sand (espen@kde.org)

		@short A dialog base class with standard buttons and predefined layouts.

*/
public class KDialogBase extends KDialog  {
	protected KDialogBase(Class dummy){super((Class) null);}
	public static final int Help = 0x00000001;
	public static final int Default = 0x00000002;
	public static final int Ok = 0x00000004;
	public static final int Apply = 0x00000008;
	public static final int Try = 0x00000010;
	public static final int Cancel = 0x00000020;
	public static final int Close = 0x00000040;
	public static final int User1 = 0x00000080;
	public static final int User2 = 0x00000100;
	public static final int User3 = 0x00000200;
	public static final int No = 0x00000080;
	public static final int Yes = 0x00000100;
	public static final int Details = 0x00000400;
	public static final int Filler = 0x40000000;
	public static final int Stretch = 0x80000000;
	public static final int NoDefault = 0;

	public static final int ActionStyle0 = 0;
	public static final int ActionStyle1 = 1;
	public static final int ActionStyle2 = 2;
	public static final int ActionStyle3 = 3;
	public static final int ActionStyle4 = 4;
	public static final int ActionStyleMAX = 5;

	/**

			<li>
			<code>TreeList</code> - A dialog with a tree on the left side and a
			                    representation of the contents on the right side.
			</li>

			<li>
			<code>Tabbed</code> -   A dialog using a TQTabWidget.
			</li>

			<li>
			<code>Plain</code> -    A normal dialog. Use plainPage() as parent for widgets.
			</li>

			<li>
			<code>Swallow</code> -  Simplifes the usage of existing widgets. You specify
			                    the widget to be displayed by setMainWidget().
			</li>

			<li>
			<code>IconList</code> - A dialog with an iconlist on the left side and a
			                    representation of the contents on the right side.

			</li>		@short
	*/
	public static final int TreeList = KJanusWidget.TreeList;
	public static final int Tabbed = KJanusWidget.Tabbed;
	public static final int Plain = KJanusWidget.Plain;
	public static final int Swallow = KJanusWidget.Swallow;
	public static final int IconList = KJanusWidget.IconList;

	public native TQMetaObject metaObject();
	public native String className();
	/**
		 Constructor for the standard mode where you must specify the main
		 widget with setMainWidget() .
			@param parent Parent of the dialog.
			@param name Dialog name (for internal use only)
			@param modal Controls dialog modality. If <code>false</code>, the rest of the
		        program interface (example: other dialogs) is accessible while
		        the dialog is open.
			@param caption The dialog caption. Do not specify the application name
		        here. The class will take care of that.
			@param buttonMask Specifies which buttons will be visible. If zero
		        (0) no button box will be made.
			@param defaultButton Specifies which button will be marked as
		        the default. Use ButtonCode.NoDefault to indicate that no button
		        should be marked as the default button.
			@param separator If <code>true</code>, a separator line is drawn between the
		        action buttons and the main widget.
			@param user1 User button1 item.
			@param user2 User button2 item.
			@param user3 User button3 item.
		     		@short    Constructor for the standard mode where you must specify the main  widget with setMainWidget() .
	*/
	public KDialogBase(TQWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton, boolean separator, KGuiItem user1, KGuiItem user2, KGuiItem user3) {
		super((Class) null);
		newKDialogBase(parent,name,modal,caption,buttonMask,defaultButton,separator,user1,user2,user3);
	}
	private native void newKDialogBase(TQWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton, boolean separator, KGuiItem user1, KGuiItem user2, KGuiItem user3);
	public KDialogBase(TQWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton, boolean separator, KGuiItem user1, KGuiItem user2) {
		super((Class) null);
		newKDialogBase(parent,name,modal,caption,buttonMask,defaultButton,separator,user1,user2);
	}
	private native void newKDialogBase(TQWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton, boolean separator, KGuiItem user1, KGuiItem user2);
	public KDialogBase(TQWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton, boolean separator, KGuiItem user1) {
		super((Class) null);
		newKDialogBase(parent,name,modal,caption,buttonMask,defaultButton,separator,user1);
	}
	private native void newKDialogBase(TQWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton, boolean separator, KGuiItem user1);
	public KDialogBase(TQWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton, boolean separator) {
		super((Class) null);
		newKDialogBase(parent,name,modal,caption,buttonMask,defaultButton,separator);
	}
	private native void newKDialogBase(TQWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton, boolean separator);
	public KDialogBase(TQWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton) {
		super((Class) null);
		newKDialogBase(parent,name,modal,caption,buttonMask,defaultButton);
	}
	private native void newKDialogBase(TQWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton);
	public KDialogBase(TQWidget parent, String name, boolean modal, String caption, int buttonMask) {
		super((Class) null);
		newKDialogBase(parent,name,modal,caption,buttonMask);
	}
	private native void newKDialogBase(TQWidget parent, String name, boolean modal, String caption, int buttonMask);
	public KDialogBase(TQWidget parent, String name, boolean modal, String caption) {
		super((Class) null);
		newKDialogBase(parent,name,modal,caption);
	}
	private native void newKDialogBase(TQWidget parent, String name, boolean modal, String caption);
	public KDialogBase(TQWidget parent, String name, boolean modal) {
		super((Class) null);
		newKDialogBase(parent,name,modal);
	}
	private native void newKDialogBase(TQWidget parent, String name, boolean modal);
	public KDialogBase(TQWidget parent, String name) {
		super((Class) null);
		newKDialogBase(parent,name);
	}
	private native void newKDialogBase(TQWidget parent, String name);
	public KDialogBase(TQWidget parent) {
		super((Class) null);
		newKDialogBase(parent);
	}
	private native void newKDialogBase(TQWidget parent);
	public KDialogBase() {
		super((Class) null);
		newKDialogBase();
	}
	private native void newKDialogBase();
	/**
		 In KDE4 a WFlag paramater should be added after modal and next
		 function can be removed.
			 Constructor for the predefined layout mode where you specify the
		 kind of layout (face).
			@param dialogFace You can use TreeList, Tabbed, Plain, Swallow or
		        IconList.
			@param caption The dialog caption. Do not specify the application name
		        here. The class will take care of that.
			@param buttonMask Specifies which buttons will be visible. If zero
		        (0) no button box will be made.
			@param defaultButton Specifies which button will be marked as
		        the default. Use ButtonCode.NoDefault to indicate that no button
		        should be marked as the default button.
			@param parent Parent of the dialog.
			@param name Dialog name (for internal use only).
			@param modal Controls dialog modality. If <code>false</code>, the rest of the
		        program interface (example: other dialogs) is accessible while
		        the dialog is open.
			@param separator If <code>true</code>, a separator line is drawn between the
		        action buttons and the main widget.
			@param user1 User button1 text item.
			@param user2 User button2 text item.
			@param user3 User button3 text item.
		     		@short    In KDE4 a WFlag paramater should be added after modal and next  function can be removed.
	*/
	public KDialogBase(int dialogFace, String caption, int buttonMask, int defaultButton, TQWidget parent, String name, boolean modal, boolean separator, KGuiItem user1, KGuiItem user2, KGuiItem user3) {
		super((Class) null);
		newKDialogBase(dialogFace,caption,buttonMask,defaultButton,parent,name,modal,separator,user1,user2,user3);
	}
	private native void newKDialogBase(int dialogFace, String caption, int buttonMask, int defaultButton, TQWidget parent, String name, boolean modal, boolean separator, KGuiItem user1, KGuiItem user2, KGuiItem user3);
	public KDialogBase(int dialogFace, String caption, int buttonMask, int defaultButton, TQWidget parent, String name, boolean modal, boolean separator, KGuiItem user1, KGuiItem user2) {
		super((Class) null);
		newKDialogBase(dialogFace,caption,buttonMask,defaultButton,parent,name,modal,separator,user1,user2);
	}
	private native void newKDialogBase(int dialogFace, String caption, int buttonMask, int defaultButton, TQWidget parent, String name, boolean modal, boolean separator, KGuiItem user1, KGuiItem user2);
	public KDialogBase(int dialogFace, String caption, int buttonMask, int defaultButton, TQWidget parent, String name, boolean modal, boolean separator, KGuiItem user1) {
		super((Class) null);
		newKDialogBase(dialogFace,caption,buttonMask,defaultButton,parent,name,modal,separator,user1);
	}
	private native void newKDialogBase(int dialogFace, String caption, int buttonMask, int defaultButton, TQWidget parent, String name, boolean modal, boolean separator, KGuiItem user1);
	public KDialogBase(int dialogFace, String caption, int buttonMask, int defaultButton, TQWidget parent, String name, boolean modal, boolean separator) {
		super((Class) null);
		newKDialogBase(dialogFace,caption,buttonMask,defaultButton,parent,name,modal,separator);
	}
	private native void newKDialogBase(int dialogFace, String caption, int buttonMask, int defaultButton, TQWidget parent, String name, boolean modal, boolean separator);
	public KDialogBase(int dialogFace, String caption, int buttonMask, int defaultButton, TQWidget parent, String name, boolean modal) {
		super((Class) null);
		newKDialogBase(dialogFace,caption,buttonMask,defaultButton,parent,name,modal);
	}
	private native void newKDialogBase(int dialogFace, String caption, int buttonMask, int defaultButton, TQWidget parent, String name, boolean modal);
	public KDialogBase(int dialogFace, String caption, int buttonMask, int defaultButton, TQWidget parent, String name) {
		super((Class) null);
		newKDialogBase(dialogFace,caption,buttonMask,defaultButton,parent,name);
	}
	private native void newKDialogBase(int dialogFace, String caption, int buttonMask, int defaultButton, TQWidget parent, String name);
	public KDialogBase(int dialogFace, String caption, int buttonMask, int defaultButton, TQWidget parent) {
		super((Class) null);
		newKDialogBase(dialogFace,caption,buttonMask,defaultButton,parent);
	}
	private native void newKDialogBase(int dialogFace, String caption, int buttonMask, int defaultButton, TQWidget parent);
	public KDialogBase(int dialogFace, String caption, int buttonMask, int defaultButton) {
		super((Class) null);
		newKDialogBase(dialogFace,caption,buttonMask,defaultButton);
	}
	private native void newKDialogBase(int dialogFace, String caption, int buttonMask, int defaultButton);
	/**
		 Constructor for the predefined layout mode where you specify the
		 kind of layout (face).
			@param dialogFace You can use TreeList, Tabbed, Plain, Swallow or
		        IconList.
			@param f widget flags, by default it is just set to WStyle_DialogBorder.
			@param caption The dialog caption. Do not specify the application name
		        here. The class will take care of that.
			@param parent Parent of the dialog.
			@param name Dialog name (for internal use only).
			@param modal Controls dialog modality. If <code>false</code>, the rest of the
		        program interface (example: other dialogs) is accessible while
		        the dialog is open.
			@param buttonMask Specifies which buttons will be visible. If zero
		        (0) no button box will be made.
			@param defaultButton Specifies which button will be marked as
		        the default. Use ButtonCode.NoDefault to indicate that no button
		        should be marked as the default button.
			@param separator If <code>true</code>, a separator line is drawn between the
		        action buttons and the main widget.
			@param user1 User button1 text item.
			@param user2 User button2 text item.
			@param user3 User button3 text item.
				@short    Constructor for the predefined layout mode where you specify the  kind of layout (face).
	*/
	public KDialogBase(int dialogFace, int f, TQWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton, boolean separator, KGuiItem user1, KGuiItem user2, KGuiItem user3) {
		super((Class) null);
		newKDialogBase(dialogFace,f,parent,name,modal,caption,buttonMask,defaultButton,separator,user1,user2,user3);
	}
	private native void newKDialogBase(int dialogFace, int f, TQWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton, boolean separator, KGuiItem user1, KGuiItem user2, KGuiItem user3);
	public KDialogBase(int dialogFace, int f, TQWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton, boolean separator, KGuiItem user1, KGuiItem user2) {
		super((Class) null);
		newKDialogBase(dialogFace,f,parent,name,modal,caption,buttonMask,defaultButton,separator,user1,user2);
	}
	private native void newKDialogBase(int dialogFace, int f, TQWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton, boolean separator, KGuiItem user1, KGuiItem user2);
	public KDialogBase(int dialogFace, int f, TQWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton, boolean separator, KGuiItem user1) {
		super((Class) null);
		newKDialogBase(dialogFace,f,parent,name,modal,caption,buttonMask,defaultButton,separator,user1);
	}
	private native void newKDialogBase(int dialogFace, int f, TQWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton, boolean separator, KGuiItem user1);
	public KDialogBase(int dialogFace, int f, TQWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton, boolean separator) {
		super((Class) null);
		newKDialogBase(dialogFace,f,parent,name,modal,caption,buttonMask,defaultButton,separator);
	}
	private native void newKDialogBase(int dialogFace, int f, TQWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton, boolean separator);
	public KDialogBase(int dialogFace, int f, TQWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton) {
		super((Class) null);
		newKDialogBase(dialogFace,f,parent,name,modal,caption,buttonMask,defaultButton);
	}
	private native void newKDialogBase(int dialogFace, int f, TQWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton);
	public KDialogBase(int dialogFace, int f, TQWidget parent, String name, boolean modal, String caption, int buttonMask) {
		super((Class) null);
		newKDialogBase(dialogFace,f,parent,name,modal,caption,buttonMask);
	}
	private native void newKDialogBase(int dialogFace, int f, TQWidget parent, String name, boolean modal, String caption, int buttonMask);
	public KDialogBase(int dialogFace, int f, TQWidget parent, String name, boolean modal, String caption) {
		super((Class) null);
		newKDialogBase(dialogFace,f,parent,name,modal,caption);
	}
	private native void newKDialogBase(int dialogFace, int f, TQWidget parent, String name, boolean modal, String caption);
	public KDialogBase(int dialogFace, int f, TQWidget parent, String name, boolean modal) {
		super((Class) null);
		newKDialogBase(dialogFace,f,parent,name,modal);
	}
	private native void newKDialogBase(int dialogFace, int f, TQWidget parent, String name, boolean modal);
	public KDialogBase(int dialogFace, int f, TQWidget parent, String name) {
		super((Class) null);
		newKDialogBase(dialogFace,f,parent,name);
	}
	private native void newKDialogBase(int dialogFace, int f, TQWidget parent, String name);
	public KDialogBase(int dialogFace, int f, TQWidget parent) {
		super((Class) null);
		newKDialogBase(dialogFace,f,parent);
	}
	private native void newKDialogBase(int dialogFace, int f, TQWidget parent);
	public KDialogBase(int dialogFace, int f) {
		super((Class) null);
		newKDialogBase(dialogFace,f);
	}
	private native void newKDialogBase(int dialogFace, int f);
	/**
		 Constructor for a message box mode where the <code>buttonMask</code> can only
		 contain Yes, No, or Cancel.
			 If you need other names you can rename
		 the buttons with setButtonText(). The dialog box is not resizable
		 by default but this can be changed by setInitialSize(). If you
		 select 'modal' to be true, the dialog will return Yes, No, or Cancel
		 when closed otherwise you can use the signals yesClicked(),
		 noClicked(), or cancelClicked() to determine the state.
			@param caption The dialog caption. Do not specify the application name
		        here. The class will take care of that.
			@param buttonMask Specifies which buttons will be visible. If zero
		        (0) no button box will be made.
			@param defaultButton Specifies which button will be marked as
		        the default. Use ButtonCode.NoDefault to indicate that no button
		        should be marked as the default button.
			@param escapeButton Specifies which button will be activated by
		        when the dialog receives a <code>Key_Escape</code> keypress.
			@param parent Parent of the dialog.
			@param name Dialog name (for internal use only).
			@param modal Controls dialog modality. If <code>false</code>, the rest of the
		        program interface (example: other dialogs) is accessible
		        while the dialog is open.
			@param separator If <code>true</code>, a separator line is drawn between the
		        action buttons and the main widget.
			@param yes Text to use for the first button (defaults to i18n("Yes"))
			@param no Text to use for the second button (defaults to i18n("No"))
			@param cancel Text to use for the third button (defaults to i18n("Cancel"))
		     		@short    Constructor for a message box mode where the <code>buttonMask</code> can only  contain Yes, No, or Cancel.
	*/
	public KDialogBase(String caption, int buttonMask, int defaultButton, int escapeButton, TQWidget parent, String name, boolean modal, boolean separator, KGuiItem yes, KGuiItem no, KGuiItem cancel) {
		super((Class) null);
		newKDialogBase(caption,buttonMask,defaultButton,escapeButton,parent,name,modal,separator,yes,no,cancel);
	}
	private native void newKDialogBase(String caption, int buttonMask, int defaultButton, int escapeButton, TQWidget parent, String name, boolean modal, boolean separator, KGuiItem yes, KGuiItem no, KGuiItem cancel);
	public KDialogBase(String caption, int buttonMask, int defaultButton, int escapeButton, TQWidget parent, String name, boolean modal, boolean separator, KGuiItem yes, KGuiItem no) {
		super((Class) null);
		newKDialogBase(caption,buttonMask,defaultButton,escapeButton,parent,name,modal,separator,yes,no);
	}
	private native void newKDialogBase(String caption, int buttonMask, int defaultButton, int escapeButton, TQWidget parent, String name, boolean modal, boolean separator, KGuiItem yes, KGuiItem no);
	public KDialogBase(String caption, int buttonMask, int defaultButton, int escapeButton, TQWidget parent, String name, boolean modal, boolean separator, KGuiItem yes) {
		super((Class) null);
		newKDialogBase(caption,buttonMask,defaultButton,escapeButton,parent,name,modal,separator,yes);
	}
	private native void newKDialogBase(String caption, int buttonMask, int defaultButton, int escapeButton, TQWidget parent, String name, boolean modal, boolean separator, KGuiItem yes);
	public KDialogBase(String caption, int buttonMask, int defaultButton, int escapeButton, TQWidget parent, String name, boolean modal, boolean separator) {
		super((Class) null);
		newKDialogBase(caption,buttonMask,defaultButton,escapeButton,parent,name,modal,separator);
	}
	private native void newKDialogBase(String caption, int buttonMask, int defaultButton, int escapeButton, TQWidget parent, String name, boolean modal, boolean separator);
	public KDialogBase(String caption, int buttonMask, int defaultButton, int escapeButton, TQWidget parent, String name, boolean modal) {
		super((Class) null);
		newKDialogBase(caption,buttonMask,defaultButton,escapeButton,parent,name,modal);
	}
	private native void newKDialogBase(String caption, int buttonMask, int defaultButton, int escapeButton, TQWidget parent, String name, boolean modal);
	public KDialogBase(String caption, int buttonMask, int defaultButton, int escapeButton, TQWidget parent, String name) {
		super((Class) null);
		newKDialogBase(caption,buttonMask,defaultButton,escapeButton,parent,name);
	}
	private native void newKDialogBase(String caption, int buttonMask, int defaultButton, int escapeButton, TQWidget parent, String name);
	public KDialogBase(String caption, int buttonMask, int defaultButton, int escapeButton, TQWidget parent) {
		super((Class) null);
		newKDialogBase(caption,buttonMask,defaultButton,escapeButton,parent);
	}
	private native void newKDialogBase(String caption, int buttonMask, int defaultButton, int escapeButton, TQWidget parent);
	public KDialogBase(String caption, int buttonMask, int defaultButton, int escapeButton) {
		super((Class) null);
		newKDialogBase(caption,buttonMask,defaultButton,escapeButton);
	}
	private native void newKDialogBase(String caption, int buttonMask, int defaultButton, int escapeButton);
	public KDialogBase(String caption, int buttonMask, int defaultButton) {
		super((Class) null);
		newKDialogBase(caption,buttonMask,defaultButton);
	}
	private native void newKDialogBase(String caption, int buttonMask, int defaultButton);
	public KDialogBase(String caption, int buttonMask) {
		super((Class) null);
		newKDialogBase(caption,buttonMask);
	}
	private native void newKDialogBase(String caption, int buttonMask);
	public KDialogBase(String caption) {
		super((Class) null);
		newKDialogBase(caption);
	}
	private native void newKDialogBase(String caption);
	/**
		 Sets the orientation of the button box.
			 It can be <code>Vertical</code> or <code>Horizontal.</code> If <code>Horizontal</code>
		 (default), the button box is positioned at the bottom of the
		 dialog. If <code>Vertical</code> it will be placed at the right edge of the
		 dialog.
			@param orientation The button box orientation.
		     		@short    Sets the orientation of the button box.
	*/
	public native void setButtonBoxOrientation(int orientation);
	/**
		 Sets the button that will be activated when the Escape key
		 is pressed.
			 Normally you should not use this function. By default,
		 the Escape key is mapped to either the Cancel or the Close button
		 if one of these buttons are defined. The user expects that Escape will
		 cancel an operation so use this function with caution.
			@param id The button code.
		     		@short    Sets the button that will be activated when the Escape key  is pressed.
	*/
	public native void setEscapeButton(int id);
	/**
		 Adjust the size of the dialog to fit the contents just before
		 TQDialog.exec() or TQDialog.show() is called.
			 This method will not be called if the dialog has been explicitly
		 resized before showing it.
				@short    Adjust the size of the dialog to fit the contents just before  TQDialog.exec() or TQDialog.show() is called.
	*/
	public native void adjustSize();
	public native TQSize sizeHint();
	public native TQSize minimumSizeHint();
	/**
		 Retrieve the empty page when the predefined layout is used in <code>Plain</code>
		 mode.
			 This widget must be used as the toplevel widget of your dialog
		 code.
				@return The widget or 0 if the predefined layout mode is not <code>Plain</code>
         or if you don't use any predefined layout.

		@short    Retrieve the empty page when the predefined layout is used in <code>Plain</code>  mode.
	*/
	public native TQFrame plainPage();
	/**
		 Add a page to the dialog when the class is used in <code>TreeList</code> ,
		 <code>IconList</code> or <code>Tabbed</code> mode.
			 The returned widget must be used as the
		 toplevel widget for this particular page.
		 Note: The returned frame widget has no
		 layout manager associated with it. In order to use it you must
		 create a layout yourself as the example below illustrates:
			 <pre>
		 TQFrame page = addPage( i18n("Layout") );
		 TQVBoxLayout topLayout = new TQVBoxLayout( page, 0, KDialog.spacingHint() );
		 TQLabel label = new TQLabel( i18n("Layout type"), page );
		 topLayout.addWidget( label );
		 ..
		 </pre>
			@param itemName String used in the list or as tab item name.
			@param header Header text use in the list modes. Ignored in <code>Tabbed</code>
		        mode. If empty, the item text is used instead.
			@param pixmap Used in <code>IconList</code> mode. You should prefer a pixmap
		        with size 32x32 pixels.
				@return The page widget which must be used as the toplevel widget for
         the page.

		@short    Add a page to the dialog when the class is used in <code>TreeList</code> ,  <code>IconList</code> or <code>Tabbed</code> mode.
	*/
	public native TQFrame addPage(String itemName, String header, TQPixmap pixmap);
	public native TQFrame addPage(String itemName, String header);
	public native TQFrame addPage(String itemName);
	/**
		 This is like addPage() just above, with the difference that the first
		 element is a list of strings.
			 These strings are used to form a path
		 of folders down to the given page. The initial elements are names
		 for the folders, while the last element is the name of the page.
		 Note: This does yet only work for the <code>TreeList</code> face. Later this may
		 be added for the <code>IconList</code> face too. In other faces than the
		 <code>TreeList</code>, all the strings except the last one is ignored.
				@short    This is like addPage() just above, with the difference that the first  element is a list of strings.
	*/
	public native TQFrame addPage(String[] items, String header, TQPixmap pixmap);
	public native TQFrame addPage(String[] items, String header);
	public native TQFrame addPage(String[] items);
	/**
		 Add a page to the dialog when the class is used in <code>TreeList</code>,
		 <code>IconList</code> or <code>Tabbed</code> mode.
			 The returned widget must be used as the toplevel widget for
		 this particular page. The widget contains a TQVBoxLayout
		 layout so the widget children are lined up vertically.  You can
		 use it as follows:
			 <pre>
		 TQVBox page = addVBoxPage( i18n("Layout") );
		 TQLabel label = new TQLabel( i18n("Layout type"), page );
		 ..
		 </pre>
			@param itemName String used in the list or as tab item name.
			@param header Header text use in the list modes. Ignored in <code>Tabbed</code>
		        mode. If empty, the item text is used instead.
			@param pixmap Used in <code>IconList</code> mode. You should prefer a pixmap
		        with size 32x32 pixels.
				@return The page widget which must be used as the toplevel widget for
         the page.

		@short    Add a page to the dialog when the class is used in <code>TreeList</code>,  <code>IconList</code> or <code>Tabbed</code> mode.
	*/
	public native TQVBox addVBoxPage(String itemName, String header, TQPixmap pixmap);
	public native TQVBox addVBoxPage(String itemName, String header);
	public native TQVBox addVBoxPage(String itemName);
	/**
		 This is like addVBoxPage() just above, with the difference
		 that the first element is a list of strings.
			 These strings are used to form a path
		 of folders down to the given page. The initial elements are names
		 for the folders, while the last element is the name of the page.
		 Note: This does yet only work for the <code>TreeList</code> face. Later this may
		 be added for the <code>IconList</code> face too. In other faces than the
		 <code>TreeList</code>, all the strings except the last one is ignored.
				@short    This is like addVBoxPage() just above, with the difference  that the first element is a list of strings.
	*/
	public native TQVBox addVBoxPage(String[] items, String header, TQPixmap pixmap);
	public native TQVBox addVBoxPage(String[] items, String header);
	public native TQVBox addVBoxPage(String[] items);
	/**
		 Add a page to the dialog when the class is used in <code>TreeList</code>,
		 <code>IconList</code> or <code>Tabbed</code> mode.
			 The returned widget must be used as the
		 toplevel widget for this particular page. The widget contains a
		 TQHBoxLayout layout so the widget children are lined up horizontally.
		 You can use it as follows:
			@param itemName String used in the list or as tab item name.
			@param header Header text use in the list modes. Ignored in Tabbed
		        mode. If empty, the item text is used instead.
			@param pixmap Used in IconList mode. You should prefer a pixmap
		        with size 32x32 pixels.
				@return The page widget which must be used as the toplevel widget for
         the page.

		@short    Add a page to the dialog when the class is used in <code>TreeList</code>,  <code>IconList</code> or <code>Tabbed</code> mode.
	*/
	public native TQHBox addHBoxPage(String itemName, String header, TQPixmap pixmap);
	public native TQHBox addHBoxPage(String itemName, String header);
	public native TQHBox addHBoxPage(String itemName);
	/**
		 This is like addHBoxPage() just above, with the
		 difference that the first element is a list of strings.
			 These strings are used to form a path
		 of folders down to the given page. The initial elements are names
		 for the folders, while the last element is the name of the page.
		 Note: This does yet only work for the <code>TreeList</code> face. Later this may
		 be added for the <code>IconList</code> face too. In other faces than the
		 <code>TreeList</code>, all the strings except the last one is ignored.
				@short    This is like addHBoxPage() just above, with the  difference that the first element is a list of strings.
	*/
	public native TQHBox addHBoxPage(String[] items, String header, TQPixmap pixmap);
	public native TQHBox addHBoxPage(String[] items, String header);
	public native TQHBox addHBoxPage(String[] items);
	/**
		 Add a page to the dialog when the class is used in <code>TreeList</code>,
		 <code>IconList</code> or <code>Tabbed</code> mode.
			 The returned widget must be used as the
		 toplevel widget for this particular page. The widget contains a
		 TQGridLayout layout so the widget children are  positioned in a grid.
			@param n Specifies the number of columns if <code>dir</code> is Qt.Horizontal
		          or the number of rows if <code>dir</code> is Qt.Vertical.
			@param dir Can be Qt.Horizontal or Qt.Vertical.
			@param itemName String used in the list or as tab item name.
			@param header Header text use in the list modes <code>Ignored</code> in <code>Tabbed</code>
		        mode. If empty, the item text is used instead.
			@param pixmap Used in <code>IconList</code> mode. You should prefer a pixmap
		        with size 32x32 pixels.
				@return The page widget which must be used as the toplevel widget for
         the page.

		@short    Add a page to the dialog when the class is used in <code>TreeList</code>,  <code>IconList</code> or <code>Tabbed</code> mode.
	*/
	public native TQGrid addGridPage(int n, int dir, String itemName, String header, TQPixmap pixmap);
	public native TQGrid addGridPage(int n, int dir, String itemName, String header);
	public native TQGrid addGridPage(int n, int dir, String itemName);
	/**
		 This is like addGridPage() just above, with the difference
		 that the first element is a list of strings.
			 These strings are used to form a path
		 of folders down to the given page. The initial elements are names
		 for the folders, while the last element is the name of the page.
		 Note: This does yet only work for the <code>TreeList</code> face. Later this may
		 be added for the <code>IconList</code> face too. In other faces than the
		 <code>TreeList</code>, all the strings except the last one is ignored.
				@short    This is like addGridPage() just above, with the difference  that the first element is a list of strings.
	*/
	public native TQGrid addGridPage(int n, int dir, String[] items, String header, TQPixmap pixmap);
	public native TQGrid addGridPage(int n, int dir, String[] items, String header);
	public native TQGrid addGridPage(int n, int dir, String[] items);
	/**
		 Sets the icon used in <code>TreeList</code> Mode for the given path.
			@param path The path for which this icon should be shown.
			@param pixmap The icon used.
				@short    Sets the icon used in <code>TreeList</code> Mode for the given path.
	*/
	public native void setFolderIcon(String[] path, TQPixmap pixmap);
	/**
		 Make a main widget.
			 The function will make a TQFrame widget
		 and use setMainWidget() to register it. You can <b>not</b> use this
		 function more than once, <b>not</b> if you have already defined a
		 main widget with setMainWidget() and <b>not</b> if you have used the
		 constructor where you define the face (<code>Plain</code>, <code>Swallow</code>, <code>Tabbed</code>,
		 <code>TreeList</code>).
				@return The main widget or 0 if any of the rules described above
         were broken.

		@short    Make a main widget.
	*/
	public native TQFrame makeMainWidget();
	/**
		 Make a main widget.
			 The function will make a TQVBox widget
		 and use setMainWidget() to register it. You <b>can</b> use this
		 function more than once, but <b>not</b> if you have already defined a
		 main widget with setMainWidget() and <b>not</b> if you have used the
		 constructor where you define the face (<code>Plain</code>, <code>Swallow</code>, <code>Tabbed</code>,
		 <code>TreeList</code>, <code>IconList</code>).
				@return The main widget or 0 if any of the rules described above
         were broken.

		@short    Make a main widget.
	*/
	public native TQVBox makeVBoxMainWidget();
	/**
		 Make a main widget.
			 The function will make a TQHBox widget
		 and use setMainWidget() to register it. You can <b>not</b> use this
		 function more than once, <b>not</b> if you have already defined a
		 main widget with setMainWidget() and <code>not</code> if you have used the
		 constructor where you define the face (<code>Plain</code>, <code>Swallow</code>, <code>Tabbed</code>,
		 <code>TreeList</code>, <code>IconList</code>).
				@return The main widget or 0 if any of the rules described above
         were broken.

		@short    Make a main widget.
	*/
	public native TQHBox makeHBoxMainWidget();
	/**
		 Make a main widget.
			 The function will make a TQGrid widget
		 and use setMainWidget() to register it. You can <b>not</b> use this
		 function more than once, <b>not</b> if you have already defined a
		 main widget with setMainWidget and <b>not</b> if you have used the
		 constructor where you define the face (Plain, Swallow, Tabbed,
		 TreeList, IconList).
			@param n Specifies the number of columns if 'dir' is Qt.Horizontal
		          or the number of rows if 'dir' is Qt.Vertical.
			@param dir Can be Qt.Horizontal or Qt.Vertical.
				@return The main widget or 0 if any of the rules described above
         were broken.

		@short    Make a main widget.
	*/
	public native TQGrid makeGridMainWidget(int n, int dir);
	/**
		 Hide or display the a separator line drawn between the action
		 buttons an the main widget.
		     		@short    Hide or display the a separator line drawn between the action  buttons an the main widget.
	*/
	public native void enableButtonSeparator(boolean state);
	/**
		 Hide or display a general action button.
			  Only buttons that have
		 been created in the constructor can be displayed. This method will
		 not create a new button.
			@param id Button identifier.
			@param state true display the button(s).
		     		@short    Hide or display a general action button.
	*/
	public native void showButton(int id, boolean state);
	/**
		 Hide or display the OK button.
			  The OK button must have
		 been created in the constructor to be displayed.
			@param state If <code>true</code>, display the button(s).
		     		@short    Hide or display the OK button.
	*/
	public native void showButtonOK(boolean state);
	/**
		 Hide or display the Apply button.
			  The Apply button must have
		 been created in the constructor to be displayed.
			@param state true display the button(s).
		     		@short    Hide or display the Apply button.
	*/
	public native void showButtonApply(boolean state);
	/**
		 Hide or display the Cancel button. The Cancel button must have
		 been created in the constructor to be displayed.
			@param state <code>true</code> display the button(s).
		     		@short    Hide or display the Cancel button.
	*/
	public native void showButtonCancel(boolean state);
	/**
		 Sets the page with <code>index</code> to be displayed.
			 This method will only
		 work when the dialog is using the predefined shape of TreeList,
		 IconList or Tabbed.
			@param index Index of the page to be shown.
				@return <code>true</code> if the page is shown, <code>false</code> otherwise.

		@short    Sets the page with <code>index</code> to be displayed.
	*/
	public native boolean showPage(int index);
	/**
		 Returns the index of the active page.
			 This method will only work when the dialog is using the
		 predefined shape of Tabbed, TreeList or IconList.
				@return The page index or -1 if there is no active page.

		@short    Returns the index of the active page.
	*/
	public native int activePageIndex();
	/**
		 Returns the index of a page created with addPage(),
		 addVBoxPage(), addHBoxPage() or addGridPage().
		 You can can compare this index with the value returned from
		 activePageIndex() if you need to do some page specific actions
		 in your code.
			 The returned index will never change so you can safely use this
		 function once and save the value.
			@param widget The widget returned by addPage(), addVBoxPage(),
		 addHBoxPage() or addGridPage().
				@return The index or -1 if the face is not Tabbed, TreeList or
         IconList

		@short    Returns the index of a page created with addPage(),  addVBoxPage(), addHBoxPage() or addGridPage().
	*/
	public native int pageIndex(TQWidget widget);
	/**
		 Sets the main user definable widget.
			 If the dialog is using the predefined Swallow mode, the widget will
		 be reparented to the internal swallow control widget. If the dialog
		 is being used in the standard mode then the <code>widget</code> must have the
		 dialog as parent.
			@param widget The widget to be displayed as main widget. If it
		 is 0, then the dialog will show an empty space of 100x100 pixels
		 instead.
		     		@short    Sets the main user definable widget.
	*/
	public native void setMainWidget(TQWidget widget);
	/**
		 Returns the main widget if any.
				@return The current main widget. Can be 0 if no widget has been defined.

		@short    Returns the main widget if any.
	*/
	public native TQWidget mainWidget();
	/**
		 Convenience method.
			  Freezes the dialog size using the minimum size
		 of the dialog. This method should only be called right before
		 show() or exec().
		     		@short    Convenience method.
	*/
	public native void disableResize();
	/**
		 Convenience method. Sets the initial dialog size.
			  This method should
		 only be called right before show() or exec(). The initial
		 size will be
		 ignored if smaller than the dialog's minimum size.
			@param s Startup size.
			@param noResize If <code>true</code> the dialog cannot be resized.
		     		@short    Convenience method.
	*/
	public native void setInitialSize(TQSize s, boolean noResize);
	public native void setInitialSize(TQSize s);
	/**
		 Convenience method. Add a size to the default minimum size of a
		 dialog.
			 This method should only be called right before show() or
		 exec().
			@param s Size added to minimum size.
			@param noResize If <code>true</code> the dialog cannot be resized.
		     		@short    Convenience method.
	*/
	public native void incInitialSize(TQSize s, boolean noResize);
	public native void incInitialSize(TQSize s);
	/**
		 read the dialogs size from the configuration according to the screen size.
		 If no size is saved for one dimension of the screen, sizeHint() is returned.
			@param groupName Name of the group to read from. The old group
		                  of TDEGlobal.config is preserved.
		    		@short    read the dialogs size from the configuration according to the screen size.
	*/
	public native TQSize configDialogSize(String groupName);
	/**
		 read the dialogs size from the configuration according to the screen size.
		 If no size is saved for one dimension of the screen, sizeHint() is returned.
			@param config The TDEConfig object to read from
			@param groupName Name of the group to read from. The old group
		                  of TDEGlobal.config is preserved.
				@short    read the dialogs size from the configuration according to the screen size.
	*/
	public native TQSize configDialogSize(TDEConfig config, String groupName);
	/**
		 save the dialogs size dependant on the screen dimension either to the
		 global or application config file.
			@param groupName The group to which the dialogs size is saved. See configDialogSize
		 to read the size.
			@param global Set to true if the entry should go to the global config rather
		        than to the applications config. Default is false.
		    		@short    save the dialogs size dependant on the screen dimension either to the  global or application config file.
	*/
	public native void saveDialogSize(String groupName, boolean global);
	public native void saveDialogSize(String groupName);
	/**
		 save the dialogs size dependant on the screen dimension.
			@param config The TDEConfig object to write to.
			@param groupName The group to which the dialogs size is saved. See
		 configDialogSize to read the size.
			@param global Set to true if the entry should go to the global config.
		        Default is false.
				@short    save the dialogs size dependant on the screen dimension.
	*/
	public native void saveDialogSize(TDEConfig config, String groupName, boolean global);
	public native void saveDialogSize(TDEConfig config, String groupName);
	/**
		 Sets the appearance of the OK button.
			 If the default parameters are used
		 (that is, if no KGuiItem is given) KStdGuiItem.ok() is used.
			@param item KGuiItem.
				@short    Sets the appearance of the OK button.
	*/
	public native void setButtonOK(KGuiItem item);
	public native void setButtonOK();
	/**
		 Sets the appearance of the Apply button.
			 If the default parameters are used
		 (that is, if no KGuiItem is given) KStdGuiItem.apply() is used.
			@param item KGuiItem.
				@short    Sets the appearance of the Apply button.
	*/
	public native void setButtonApply(KGuiItem item);
	public native void setButtonApply();
	/**
		 Sets the appearance of the Cancel button.
			 If the default parameters are used
		 (that is, if no KGuiItem is given) KStdGuiItem.cancel() is used.
			@param item KGuiItem.
				@short    Sets the appearance of the Cancel button.
	*/
	public native void setButtonCancel(KGuiItem item);
	public native void setButtonCancel();
	/**
		 Sets the text of any button.
			@param id The button identifier.
			@param text Button text.
		     		@short    Sets the text of any button.
	*/
	public native void setButtonText(int id, String text);
	/**
		 Sets the tooltip text of any button.
			@param id The button identifier.
			@param text Button text.
		     		@short    Sets the tooltip text of any button.
	*/
	public native void setButtonTip(int id, String text);
	/**
		 Sets the "What's this?" text of any button.
			@param id The button identifier.
			@param text Button text.
		     		@short    Sets the "What's this?" text of any button.
	*/
	public native void setButtonWhatsThis(int id, String text);
	/**
		 Sets the KGuiItem directly for the button instead of using 3 methods to
		 set the text, tooltip and whatsthis strings. This also allows to set an
		 icon for the button which is otherwise not possible for the extra
		 buttons beside Ok, Cancel and Apply.
			@param id The button identifier.
			@param item The KGuiItem for the button.
				@short    Sets the KGuiItem directly for the button instead of using 3 methods to  set the text, tooltip and whatsthis strings.
	*/
	public native void setButtonGuiItem(int id, KGuiItem item);
	/**
		 This function has only effect in TreeList mode.
			 Defines how the tree list widget is resized when the dialog is
		 resized horizontally. By default the tree list keeps its width
		 when the dialog becomes wider.
			@param state The resize mode. If false (default) the tree list keeps
		        its current width when the dialog becomes wider.
		     		@short    This function has only effect in TreeList mode.
	*/
	public native void setTreeListAutoResize(boolean state);
	/**
		 This function has only effect in TreeList mode.
			 This tells the widgets whether the icons given in the addPage,
		 addVBoxPage, addHBoxPage, or addGridPage methods should
		 be shown in the TreeList.
			 Note: This method must be called before calling any of the methods
		 which add icons to the page.
			@param state If true the icons are shown.
				@short    This function has only effect in TreeList mode.
	*/
	public native void setShowIconsInTreeList(boolean state);
	/**
		 This function has only effect in TreeList mode.
			 This tells the widgets whether the root should be decorated.
		 For details see TQListView.setRootIsDecorated
			@param state Root will be decorated if true.
				@short    This function has only effect in TreeList mode.
	*/
	public native void setRootIsDecorated(boolean state);
	/**
		 This function has only effect in TreeList mode.
			 This tells the TreeList to unfold the whole tree so that all entries
		 are visible.
			 If the list is empty when you call this method newly created entries
		 will not automatically be opened. If the <code>persist</code> flag is set opened
		 entries cannot be closed again, though.
			@param persist If true the tree always stays unfolded.
				@short    This function has only effect in TreeList mode.
	*/
	public native void unfoldTreeList(boolean persist);
	public native void unfoldTreeList();
	/**
		 Add a widget at the bottom of the TreeList/IconList.
			@param widget The widget to be added. It will be reparented into the
		                KJanusWidget, therefor it will be deleted with the
		                KJanusWidget, too. To be on the save side just don't keep
		                the pointer to this widget.
		     		@short    Add a widget at the bottom of the TreeList/IconList.
	*/
	public native void addWidgetBelowList(TQWidget widget);
	/**
		 Add a button at the bottom of the TreeList/IconList.
			@param text The text on the PushButton.
			@param recv The object that is to receive the signal when the button
		                 is clicked.
			@param slot The slot to connect to the clicked signal of the button.
				@short    Add a button at the bottom of the TreeList/IconList.
	*/
	public native void addButtonBelowList(String text, TQObject recv, String slot);
	/**
		 The same as the above function, but with a KGuiItem providing the text
		 and icon for the button at the bottom of the TreeList/IconList.
			@param guiitem The text and icon on the PushButton.
			@param recv The object that is to receive the signal when the button
		                 is clicked.
			@param slot The slot to connect to the clicked signal of the button.
				@short    The same as the above function, but with a KGuiItem providing the text  and icon for the button at the bottom of the TreeList/IconList.
	*/
	public native void addButtonBelowList(KGuiItem guiitem, TQObject recv, String slot);
	/**
		 This function has only effect in IconList mode.
			 Defines how the icon list widget is displayed. By default it is
		 the widgets in the dialog pages that decide the minimum height
		 of the dialog. A vertical scrollbar can be used in the icon list
		 area.
			@param state The visibility mode. If true, the minimum height is
		        adjusted so that every icon in the list is visible at the
		        same time. The vertical scrollbar will never be visible.
		     		@short    This function has only effect in IconList mode.
	*/
	public native void setIconListAllVisible(boolean state);
	/**
		 Enable hiding of the background tile (if any).
			@param state <code>true</code> will make the tile visible.
		     		@short    Enable hiding of the background tile (if any).
	*/
	public native void showTile(boolean state);
	/**
		 Calculate the size hint for the dialog.
			 With this method it is easy to calculate a size hint for a
		 dialog derived from KDialogBase if you know the width and height of
		 the elements you add to the widget. The rectangle returned is
		 calculated so that all elements exactly fit into it. Thus, you may
		 set it as a minimum size for the resulting dialog.
			 You should not need to use this method and never if you use one of
		 the predefined shapes.
			@param w The width of you special widget.
			@param h The height of you special widget.
				@return The minimum width and height of the dialog using <code>w</code> and <code>h</code>
 as the size of the main widget.

		@short    Calculate the size hint for the dialog.
	*/
	public native TQSize calculateSize(int w, int h);
	/**
		 Returns the help link text.
			  If no text has been defined,
		 "Get help..." (internationalized) is returned.
				@return The help link text.

		@short    Returns the help link text.
	*/
	public native String helpLinkText();
	/**
		 Returns the action button that corresponds to the <code>id.</code>
			 Normally
		 you should not use this function. <b>Never</b> delete the object returned
		 by this function. See also enableButton(), showButton(),
		 setButtonTip(), setButtonWhatsThis(), and setButtonText().
			@param id Integer identifier of the button.
			 FIXME KDE 4: Return the actual KPushButton instead of TQPushButton (Martijn)
		     		@return The action button or 0 if the button does not exists.

		@short    Returns the action button that corresponds to the <code>id.</code>
	*/
	public native TQPushButton actionButton(int id);
	/**
		 Enable or disable (gray out) a general action button.
			@param id Button identifier.
			@param state <code>true</code> enables the button(s).
		     		@short    Enable or disable (gray out) a general action button.
	*/
	public native void enableButton(int id, boolean state);
	/**
		 Enable or disable (gray out) the OK button.
			@param state <code>true</code> enables the button.
		     		@short    Enable or disable (gray out) the OK button.
	*/
	public native void enableButtonOK(boolean state);
	/**
		 Enable or disable (gray out) the Apply button.
			@param state true enables the button.
		     		@short    Enable or disable (gray out) the Apply button.
	*/
	public native void enableButtonApply(boolean state);
	/**
		 Enable or disable (gray out) the Cancel button.
			@param state true enables the button.
		     		@short    Enable or disable (gray out) the Cancel button.
	*/
	public native void enableButtonCancel(boolean state);
	/**
		 Display or hide the help link area on the top of the dialog.
			@param state <code>true</code> will display the area.
		     		@short    Display or hide the help link area on the top of the dialog.
	*/
	public native void enableLinkedHelp(boolean state);
	/**
		 Destruct the Dialog delayed.
			 You can call this function from
		 slots like closeClicked() and hidden().
		 You should not use the dialog any more after
		 calling this function.
				@short    Destruct the Dialog delayed.
	*/
	public native void delayedDestruct();
	/**
		 Sets the text that is shown as the linked text.
			 If text is empty,
		 the text "Get help..." (internationalized) is used instead.
			@param text The link text.
		     		@short    Sets the text that is shown as the linked text.
	*/
	public native void setHelpLinkText(String text);
	/**
		 Sets the help path and topic.
			@param anchor Defined anchor in your docbook sources
			@param appname Defines the appname the help belongs to
		                If empty it's the current one
			 @note The help button works differently for the class
		 KCMultiDialog, so it does not make sense to call this
		 function for Dialogs of that type.  See
		 KCMultiDialog.slotHelp() for more information.
		     		@short    Sets the help path and topic.
	*/
	public native void setHelp(String anchor, String appname);
	public native void setHelp(String anchor);
	/**
		 Connected to help link label.
		     		@short    Connected to help link label.
	*/
	public native void helpClickedSlot(String arg1);
	/**
		 Sets the status of the Details button.
		     		@short    Sets the status of the Details button.
	*/
	public native void setDetails(boolean showDetails);
	/**
		 Sets the widget that gets shown when "Details" is enabled.
			 The dialog takes over ownership of the widget.
		 Any previously set widget gets deleted.
		     		@short    Sets the widget that gets shown when "Details" is enabled.
	*/
	public native void setDetailsWidget(TQWidget detailsWidget);
	/**
		 This method is called automatically whenever the background has
		 changed. You do not need to use this method.
		     		@short    This method is called automatically whenever the background has  changed.
	*/
	public native void updateBackground();
	/**
		 Force closing the dialog, setting its result code to the one Esc would set.
		 You shouldn't use this, generally (let the user make his choice!)
		 but it can be useful when you need to make a choice after a timeout
		 has happened, or when the parent widget has to go somewhere else
		 (e.g. html redirections).
				@short    Force closing the dialog, setting its result code to the one Esc would set.
	*/
	public native void cancel();
	/**
		 Check whether the background tile is set or not.
				@return <code>true</code> if there is defined a background tile.

		@short    Check whether the background tile is set or not.
	*/
	public static native boolean haveBackgroundTile();
	/**
		 Returns a pointer to the background tile if there is one.
				@return The tile pointer or 0 if no tile is defined.

		@short    Returns a pointer to the background tile if there is one.
	*/
	public static native TQPixmap backgroundTile();
	/**
		 Sets the background tile.
			  If it is Null (0), the background image is deleted.
			@param pix The background tile.
		     		@short    Sets the background tile.
	*/
	public static native void setBackgroundTile(TQPixmap pix);
	/**
		 Maps some keys to the actions buttons. F1 is mapped to the Help
		 button if present and Escape to the Cancel or Close if present. The
		 button action event is animated.
		     		@short    Maps some keys to the actions buttons.
	*/
	protected native void keyPressEvent(TQKeyEvent e);
	/**
		 Emits the #hidden signal. You can connect to that signal to
		 detect when a dialog has been closed.
		     		@short    Emits the #hidden signal.
	*/
	protected native void hideEvent(TQHideEvent arg1);
	/**
		 Detects when a dialog is being closed from the window manager
		 controls. If the Cancel or Close button is present then the button
		 is activated. Otherwise standard TQDialog behavior
		 will take place.
		     		@short    Detects when a dialog is being closed from the window manager  controls.
	*/
	protected native void closeEvent(TQCloseEvent e);
	/**
		 Activated when the Help button has been clicked. If a help
		 text has been defined, the help system will be activated.
		     		@short    Activated when the Help button has been clicked.
	*/
	protected native void slotHelp();
	/**
		 Activated when the Default button has been clicked.
		     		@short    Activated when the Default button has been clicked.
	*/
	protected native void slotDefault();
	/**
		 Activated when the Details button has been clicked.
				@short    Activated when the Details button has been clicked.
		@see #detailsClicked(boolean)
	*/
	protected native void slotDetails();
	/**
		 Activated when the User3 button has been clicked.
		     		@short    Activated when the User3 button has been clicked.
	*/
	protected native void slotUser3();
	/**
		 Activated when the User2 button has been clicked.
		     		@short    Activated when the User2 button has been clicked.
	*/
	protected native void slotUser2();
	/**
		 Activated when the User1 button has been clicked.
		     		@short    Activated when the User1 button has been clicked.
	*/
	protected native void slotUser1();
	/**
		 Activated when the Ok button has been clicked. The
		 TQDialog.accept() is activated.
		     		@short    Activated when the Ok button has been clicked.
	*/
	protected native void slotOk();
	/**
		 Activated when the Apply button has been clicked.
		     		@short    Activated when the Apply button has been clicked.
	*/
	protected native void slotApply();
	/**
		 Activated when the Try button has been clicked.
		     		@short    Activated when the Try button has been clicked.
	*/
	protected native void slotTry();
	/**
		 Activated when the Yes button has been clicked. The
		 TQDialog.done( Yes ) is activated.
		     		@short    Activated when the Yes button has been clicked.
	*/
	protected native void slotYes();
	/**
		 Activated when the Yes button has been clicked. The
		 TQDialog.done( No ) is activated.
		     		@short    Activated when the Yes button has been clicked.
	*/
	protected native void slotNo();
	/**
		 Activated when the Cancel button has been clicked. The
		 TQDialog.reject() is activated in regular mode and
		 TQDialog.done( Cancel ) when in message box mode.
		     		@short    Activated when the Cancel button has been clicked.
	*/
	protected native void slotCancel();
	/**
		 Activated when the Close button has been clicked. The
		 TQDialog.reject() is activated.
		     		@short    Activated when the Close button has been clicked.
	*/
	protected native void slotClose();
	/**
		 Updates the margins and spacings.
		     		@short    Updates the margins and spacings.
	*/
	public native void updateGeometry();
	/**
		 Deletes the dialog immediately. If you want to delete the dialog
		 delayed use delayedDestruct() or TQObject.deleteLater().
			 Attention: Do no use connect this slot to signals from user
		 actions!
		     		@short    Deletes the dialog immediately.
	*/
	protected native void slotDelayedDestruct();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
