/***************************************************************************
*   Copyright (C) 2003-2005                                               *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "dietviewdialog.h"

#include <kiconloader.h>
#include <tdelocale.h>
#include <tdestandarddirs.h>

DietViewDialog::DietViewDialog( TQWidget *parent, const RecipeList &recipeList, int dayNumber, int mealNumber, const TQValueList <int> &dishNumbers )
		: KDialogBase( parent, "dietViewDialog", true, TQString::null,
		    KDialogBase::User2 | KDialogBase::Close | KDialogBase::User1, KDialogBase::User2,
		    false, KStdGuiItem::print() )
{
	setButtonText( KDialogBase::User2, i18n( "Create &Shopping List" ) );

	// Design the dialog
	TQVBox *page = makeVBoxMainWidget();

	// The html part
	dietView = new TDEHTMLPart( page );

	setInitialSize( TQSize(350, 450) );

	setSizeGripEnabled( true );

	connect ( this, TQ_SIGNAL( user2Clicked() ), this, TQ_SLOT( slotOk() ) );
 	connect ( this, TQ_SIGNAL( closeClicked() ), this, TQ_SLOT( close() ) );
	connect ( this, TQ_SIGNAL( user1Clicked() ), this, TQ_SLOT( print() ) );

	// Show the diet
	showDiet( recipeList, dayNumber, mealNumber, dishNumbers );
}

DietViewDialog::~DietViewDialog()
{}

void DietViewDialog::showDiet( const RecipeList &recipeList, int dayNumber, int mealNumber, const TQValueList <int> &dishNumbers )
{


	// Header
	TQString htmlCode = TQString( "<html><head><title>%1</title>" ).arg( i18n( "Diet" ) );

	// CSS
	htmlCode += "<STYLE type=\"text/css\">\n";
	htmlCode += "#calendar{border: thin solid black}";
	htmlCode += ".dayheader{ background-color: #D6D6D6; color: black; border:none;}";
	htmlCode += ".day{ background-color: #E5E5E5; color: black; border:medium solid #D6D6D6;}";
	htmlCode += ".meal{ background-color: #CDD4FF; color: black; border:thin solid #B4BEFF; text-align:center;}";
	htmlCode += ".dish{font-size: smaller; overflow: hidden; height:2.5em;}";
	htmlCode += "</STYLE>";


	htmlCode += "</head><body>"; //  /Header

	// Calendar border
	htmlCode += TQString( "<div id=\"calendar\">" );

	// Title
	htmlCode += TQString( "<center><div STYLE=\"width: 100%\">" );
	htmlCode += TQString( "<h1>%1</h1></div></center>" ).arg( i18n( "Diet" ) );

	// Diet table
	htmlCode += TQString( "<center><div STYLE=\"width: 98%\">" );
	htmlCode += TQString( "<table><tbody>" );


	TQValueList <int>::ConstIterator it;
	it = dishNumbers.begin();
	RecipeList::ConstIterator rit;
	rit = recipeList.begin();

	for ( int row = 0, day = 0; row <= ( ( dayNumber - 1 ) / 7 ); row++ )  // New row (week)
	{
		htmlCode += TQString( "<tr>" );

		for ( int col = 0; ( col < 7 ) && ( day < dayNumber ); col++, day++ )  // New column (day)
		{
			htmlCode += TQString( "<td><div class=\"day\">" );
			htmlCode += TQString( "<div class=\"dayheader\"><center>" );
			htmlCode += TQString( i18n( "Day %1" ) ).arg( day + 1 );
			htmlCode += TQString( "</center></div>" );
			for ( int meal = 0;meal < mealNumber;meal++ )  // Meals in each cell
			{
				int dishNumber = *it;
				htmlCode += TQString( "<div class=\"meal\">" );
				for ( int dish = 0; dish < dishNumber;dish++ )  // Dishes in each Meal
				{
					htmlCode += TQString( "<div class=\"dish\">" );
					htmlCode += ( *rit ).title;
					htmlCode += "<br>";
					htmlCode += TQString( "</div>" );
					rit++;
				}
				it++;
				htmlCode += TQString( "</div>" );
			}
			it = dishNumbers.begin(); // meals have same dish number everyday
			htmlCode += TQString( "</div></td>" );
		}

		htmlCode += TQString( "</tr>" );
	}

	htmlCode += TQString( "</tbody></table>" );
	htmlCode += TQString( "</div></center>" );
	htmlCode += TQString( "</div></body></html>" );

	resize( TQSize( 600, 400 ) );

	// Display it
	dietView->begin( KURL( locateLocal( "tmp", "/" ) ) ); // Initialize to tmp dir, where photos and logos can be stored
	dietView->write( htmlCode );
	dietView->end();
}

void DietViewDialog::print( void )
{
	dietView->view()->print();
}

void DietViewDialog::slotOk( void )
{
	emit signalOk();
	close();
}

#include "dietviewdialog.moc"
