/*
 * Kivio - Visual Modelling and Flowcharting
 * Copyright (C) 2000-2001 theKompany.com & Dave Marotti
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef KIVIO_SCREEN_PAINTER_H
#define KIVIO_SCREEN_PAINTER_H

#include "kivio_painter.h"

#include <tqfont.h>
#include <tqpainter.h>
#include <tqpixmap.h>

class KivioPoint;


class KivioScreenPainter : public KivioPainter
{
protected:
    TQPainter *m_pPainter;
    float m_transX, m_transY;
    int m_rotation;

public:
    KivioScreenPainter();
    KivioScreenPainter(TQPainter* painter);
    virtual ~KivioScreenPainter();

    virtual bool start( TQPaintDevice * );
    virtual bool stop();

    TQPainter *painter() { return m_pPainter; }
    void setPainter(TQPainter* p) { m_pPainter = p; }

    /*\
    |*|
    |*| PRIMITIVE IMPLEMENTATIONS
    |*|
    |*|
    \*/
    void drawLine( float, float, float, float );
    void drawArc( float, float, float, float, float, float );

    void drawBezier( TQPointArray & );

    void drawRect( float, float, float, float );
    void fillRect( float, float, float, float );

    void drawRoundRect( float, float, float, float, float, float );
    void fillRoundRect( float, float, float, float, float, float );

    void drawPie( float, float, float, float, float, float );
    void fillPie( float, float, float, float, float, float );

    void drawChord( float, float, float, float, float, float );
    void fillChord( float, float, float, float, float, float );

    void drawEllipse( float, float, float, float );
    void fillEllipse( float, float, float, float );

    void drawLineArray( TQPtrList<KivioPoint> * );


    void drawPolyline( TQPtrList<KivioPoint> * );
    void drawPolygon( TQPtrList<KivioPoint> * );

    void drawPolyline( TQPointArray & );
    void drawPolygon( TQPointArray & );
    void drawLineArray( TQPointArray & );

    void drawClosedPath( TQPtrList<KivioPoint> * );
    void drawOpenPath( TQPtrList<KivioPoint> * );

    void setFont( const TQFont & );
    void drawText( int x, int y, int w, int h, int tf,
                const TQString &str );
    virtual TQRect boundingRect( int, int, int, int, int, const TQString & );

    void drawPixmap( float, float, const TQPixmap & );

    void drawHandle( float, float, int );
    virtual void drawSelectionBox( const TQRect& );

    virtual void saveState();
    virtual void restoreState();
    virtual void setTranslation(float, float);
    virtual void translateBy(float, float);
    virtual void setRotation(int);
    virtual void rotateBy(int);
    virtual int rotation();

    virtual void setWorldMatrix(TQWMatrix, bool);
};

#endif


