/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 * 
 * Date        : 2005-04-21
 * Description : a widget to edit time stamp.
 *
 * Copyright (C) 2005 Tom Albers <tomalbers@kde.nl>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// TQt includes.

#include <tqdatetimeedit.h>

// KDE includes.

#include "kdateedit.h"
#include "kdatetimeedit.h"
#include "kdatetimeedit.moc"

namespace Digikam
{

KDateTimeEdit::KDateTimeEdit(TQWidget *parent, const char *name)
             : TQHBox(parent, name)
{
    m_datePopUp = new KDateEdit(this, "datepopup");
    m_timePopUp = new TQTimeEdit(TQTime::currentTime(), this);

    connect(m_datePopUp, TQ_SIGNAL(dateChanged(const TQDate& )),
            TQ_SLOT(slotDateTimeChanged()) );
    connect(m_timePopUp, TQ_SIGNAL(valueChanged(const TQTime& )),
            TQ_SLOT(slotDateTimeChanged()) );
}

KDateTimeEdit::~KDateTimeEdit()
{
    delete m_datePopUp;
    m_datePopUp = 0;

    delete m_timePopUp;
    m_timePopUp = 0;
}

TQDateTime KDateTimeEdit::dateTime()
{
    return TQDateTime(m_datePopUp->date(), m_timePopUp->time());
}

void KDateTimeEdit::setDateTime(const TQDateTime dateTime)
{
    m_datePopUp->setDate(dateTime.date());
    m_timePopUp->setTime(dateTime.time());
}

void KDateTimeEdit::slotDateTimeChanged()
{
    emit dateTimeChanged(dateTime());
}

}  // namespace Digikam
