/***************************************************************************
 *   Copyright (C) 2006-2012 by Thomas Schweitzer                          *
 *   thomas-schweitzer(at)arcor.de                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2.0 as   *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program in the file LICENSE.GPL; if not, write to the *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "MainWindow.h"

#include "SettingsPaths.h"
#include "UiGuiVersion.h"

#include <tqapplication.h>
#include <tqglobal.h>
#include <tqstring.h>
#include <tqtextcodec.h>

#include <iostream>

#include <tclap/CmdLine.h>

/*!
    /brief Entry point to UniversalIndentGUI-TQt application.
 */
int main(int argc, char *argv[])
{
 	TQString file2OpenOnStart = "";
 	bool tclapExitExceptionThrown = false;
 	int returnValue = 0;
 
	// Wrap everything in a try block. Do this every time,
	// because exceptions will be thrown for problems.
	try
	{
 		// Define the command line object.
 		TCLAP::CmdLine cmd("Starts full gui", ' ', PROGRAM_VERSION_STRING);
 		cmd.setExceptionHandling(false);
 
 		// Define a value argument and add it to the command line.
    TCLAP::UnlabeledValueArg<std::string> filenameArg("file",
				    "Opens the by filename defined file on start" , false, "", "filename");
 		cmd.add(filenameArg);
 
 		// Parse the args.
 		cmd.parse(argc, argv);
 
 		// Get the value parsed by each arg.
    file2OpenOnStart = filenameArg.getValue().c_str();
	}
 	catch (TCLAP::ArgException &e)
	{
		// catch arg exceptions
 		std::cerr << std::endl << "error: " << e.error() << ". " << e.argId() << std::endl;
 		returnValue = 1;
 	}
 	catch (TCLAP::ExitException &e)
	{
		// catch exit exceptions
 		tclapExitExceptionThrown = true;
 		returnValue = e.getExitStatus();
 	}
	catch (...)
	{
		// catch any exceptions
		std::cerr << std::endl << "There was an error! Maybe faulty "
			      "command line arguments set. See --help." << std::endl;
		returnValue = 1;
	}

	if (returnValue != 0 || tclapExitExceptionThrown)
	{
		return returnValue;
	}

  TQApplication app(argc, argv);
  MainWindow *mainWindow = NULL;

  // Setting UTF-8 as default 8-Bit encoding
  TQTextCodec::setCodecForCStrings(TQTextCodec::codecForName("UTF-8"));
  TQTextCodec::setCodecForLocale(TQTextCodec::codecForName("UTF-8"));

  mainWindow = new MainWindow(file2OpenOnStart);
  mainWindow->show();

  try
	{
		app.connect(&app, TQ_SIGNAL(lastWindowClosed()), &app, TQ_SLOT(quit()));
    returnValue = app.exec();
  }
  catch (std::exception &ex)
	{
    tqDebug(TQString() + __LINE__ + " " + __FUNCTION__ + ": Something went terribly wrong: " + ex.what());
  }

	delete mainWindow;
  return returnValue;
}
