/***************************************************************************
                          textedit.cpp - Rich text editing widget 
                             -------------------
    copyright            : (C) 2002-2003 Marc Britton <consume@optusnet.com.au>
                           (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>
    email                : consume@optusnet.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* QT INCLUDES */
#include <tqlayout.h>
#include <tqlineedit.h>
#include <tqstringlist.h>
#include <tqevent.h>

/* OTHER INCLUDES */
#include <specials.h>
#include "textedit.h"
#include <tdelocale.h>
#include <kommanderplugin.h>

enum Functions {
  FirstFunction = 450, //CHANGE THIS NUMBER TO AN UNIQUE ONE!!!
  TE_setModified,
  TE_selectText,
  TE_paragraphs,
  TE_length,
//  TE_getCursorPosition,
  TE_paragraphLength,
  TE_linesOfParagraph,
  TE_findText,
  TE_VAsuperScript,
  TE_VAnormalScript,
  LastFunction
};

TextEdit::TextEdit(TQWidget * a_parent, const char *a_name):KTextEdit(a_parent, a_name),
KommanderWidget(TQT_TQOBJECT(this))
{
  TQStringList states;
  states << "default";
  setStates(states);
  setDisplayStates(states);

  connect(this, TQT_SIGNAL(textChanged()), this, TQT_SLOT(setTextChanged()));

  KommanderPlugin::setDefaultGroup(Group::DCOP);
  KommanderPlugin::registerFunction(TE_setModified, "setModified(TQString widget, bool Modified)",  i18n("Set widget modified status."), 1);
  KommanderPlugin::registerFunction(TE_selectText, "selectText(TQString widget, int paraFrom, int indexFrom, int paraTo, int indexTo)",  i18n("Select a block of text using the paragraph number and character index of the line. You can use the cursorPositionChanged(int, int) signal to get this data in real time into a script."), 5);
  KommanderPlugin::registerFunction(TE_findText, "findText(TQString widget, TQString Text, bool Case-Sensitive, bool Forward)",  i18n("Search for text from the cursor or a specified position. You can specifiy case sensitive search and forward or backward."), 5);
//  KommanderPlugin::registerFunction(TE_findText, "findText(TQString widget, TQString Text, bool Case-Sensitive, bool Forward, int Paragraph, int Index)",  i18n("Search for text from the cursor or a specified position. You can specifiy case sensitive search and forward or backward."), 5, 7);
  KommanderPlugin::registerFunction(TE_paragraphs, "paragraphs(TQString widget)",  i18n("Get the number of paragraphs in the widget."), 1);
  KommanderPlugin::registerFunction(TE_length, "length(TQString widget)",  i18n("Get the total length of all text."), 1);
//  KommanderPlugin::registerFunction(TE_getCursorPosition, "getCursorPosition(TQString widget)",  i18n("Get the cursor postion in the form of paragraph and postion integers."), 1);
  KommanderPlugin::registerFunction(TE_paragraphLength, "paragraphLength(TQString widget, int Paragraph)",  i18n("Get the length of the paragraph."), 2);
  KommanderPlugin::registerFunction(TE_linesOfParagraph, "linesOfParagraph(TQString widget, int Paragraph)",  i18n("Get the number of lines in the paragraph."), 2);
  KommanderPlugin::registerFunction(TE_VAsuperScript, "setSuperScript(TQString widget)",  i18n("Use to set superscript."), 1);
  KommanderPlugin::registerFunction(TE_VAnormalScript, "setNormalScript(TQString widget)",  i18n("Use to revert from superscript to normal script."), 1);
}

TQString TextEdit::currentState() const
{
  return TQString("default");
}

TextEdit::~TextEdit()
{
}

bool TextEdit::isKommanderWidget() const
{
  return true;
}

TQStringList TextEdit::associatedText() const
{
  return KommanderWidget::associatedText();
}

void TextEdit::setAssociatedText(const TQStringList & a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void TextEdit::setPopulationText(const TQString & a_text)
{
  KommanderWidget::setPopulationText(a_text);
}

TQString TextEdit::populationText() const
{
  return KommanderWidget::populationText();
}

void TextEdit::populate()
{
  setWidgetText(KommanderWidget::evalAssociatedText(populationText()));
}

void TextEdit::setWidgetText(const TQString & a_text)
{
  setText(a_text);
  emit widgetTextChanged(text());
}

void TextEdit::setTextChanged()
{
  emit widgetTextChanged(text());
}

void TextEdit::focusOutEvent( TQFocusEvent * e)
{
  TQTextEdit::focusOutEvent(e);
  emit lostFocus();
}

void TextEdit::focusInEvent( TQFocusEvent * e)
{
  TQTextEdit::focusInEvent(e);
  emit gotFocus();
}

void TextEdit::showEvent(TQShowEvent * e)
{
  TQTextEdit::showEvent(e);
  emit widgetOpened();
}

void TextEdit::contextMenuEvent( TQContextMenuEvent * e )
{
  e->accept();
  TQPoint p = e->globalPos();
  emit contextMenuRequested(p.x(), p.y());
}

bool TextEdit::isFunctionSupported(int f)
{
  return f == DCOP::text || f == DCOP::setText || f == DCOP::selection || f == DCOP::setSelection || f == DCOP::clear || f == DCOP::setEditable || f == DCOP::geometry || f == DCOP::hasFocus || f == DCOP::getBackgroundColor || f == DCOP::setBackgroundColor || f == DCOP::isModified || (f >= FirstFunction && f <= LastFunction);
}

TQString TextEdit::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::text:
      return text();
    case DCOP::setText:
      setWidgetText(args[0]);
      break;
    case DCOP::selection:
      return selectedText();
    case DCOP::setSelection:
      insert(args[0]);
      break;
    case DCOP::clear:
      setWidgetText(TQString());
      break;
    case DCOP::setEditable:
      setReadOnly(args[0] == "false" || args[0] == "0");
      break;
    case DCOP::getBackgroundColor:
      return this->paletteBackgroundColor().name();
      break;
    case DCOP::setBackgroundColor:
    {
      TQColor color;
      color.setNamedColor(args[0]);
      this->setPaletteBackgroundColor(color);
      break;
    }
    case DCOP::isModified:
      return isModified() ? "1" : "0";
      break;
    case TE_setModified:
      this->setModified(args[0].toInt());
      break;
    case TE_selectText:
      TQTextEdit::setSelection(args[0].toInt(), args[1].toInt(), args[2].toInt(), args[3].toInt());
      break;
    case TE_length:
      return TQString::number(TQTextEdit::length() );
      break;
    /*case TE_getCursorPosition:
      return TQString::number(TQTextEdit::getCursorPosition() );
      break;*/
    case TE_paragraphLength:
      return TQString::number(TQTextEdit::paragraphLength(args[0].toInt() ) );
      break;
    case TE_linesOfParagraph:
      return TQString::number(TQTextEdit::linesOfParagraph(args[0].toInt() ) );
      break;
    case TE_findText:
    {
//      int para = args[3].toInt();
//      int idx = args[4].toInt();
//      return TQString::number(TQTextEdit::find(args[0], args[1].toUInt(), false, args[2].toUInt(), para, idx ));
      return TQString::number(TQTextEdit::find(args[0], args[1].toUInt(), false ));
      break;
    }
    case TE_VAsuperScript:
      break;
      TQTextEdit::setVerticalAlignment(AlignSuperScript);
    case TE_VAnormalScript:
      TQTextEdit::setVerticalAlignment(AlignNormal);
      break;
    case DCOP::geometry:
    {
      TQString geo = TQString::number(this->x())+" "+TQString::number(this->y())+" "+TQString::number(this->width())+" "+TQString::number(this->height());
      return geo;
      break;
    }
    case DCOP::hasFocus:
      return TQString::number(this->hasFocus());
      break;
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}


#include "textedit.moc"
