/***************************************************************************
*   Copyright (C) 1998 by Sandy Meier                                     *
*   smeier@rz.uni-potsdam.de                                              *
*   Copyright (C) 2002 by Bernd Gehrmann                                  *
*   bernd@kdevelop.org                                                    *
*   Copyright (C) 2003 by Alexander Dymo                                  *
*   cloudtemple@mksat.net                                                 *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef _CPPNEWCLASSDLG_H_
#define _CPPNEWCLASSDLG_H_

#include <tqlineedit.h>
#include <tqlistview.h>
#include <tqwidgetstack.h>

#include "codemodel.h"
#include "cppnewclassdlgbase.h"

class CppSupportPart;
class KDevProject;
class TQPopupMenu;
class TDECompletion;
class CodeModel;


template <class T>
class PCheckListItem: public TQCheckListItem
{
public:

	PCheckListItem ( T item, TQCheckListItem * parent, const TQString & text, Type tt = Controller ) :
			TQCheckListItem ( parent, text, tt ), m_item( item )
	{}

	PCheckListItem ( T item, TQCheckListItem * parent, TQListViewItem * after, const TQString & text, Type tt = Controller ) :
			TQCheckListItem ( parent, after, text, tt ), m_item( item )
	{}

	PCheckListItem ( T item, TQListViewItem * parent, const TQString & text, Type tt = Controller ) :
			TQCheckListItem ( parent, text, tt ), m_item( item )
	{}

	PCheckListItem ( T item, TQListViewItem * parent, TQListViewItem * after, const TQString & text, Type tt = Controller ) :
			TQCheckListItem ( parent, after, text, tt ), m_item( item )
	{}

	PCheckListItem ( T item, TQListView * parent, const TQString & text, Type tt = Controller ) :
			TQCheckListItem ( parent, text, tt ), m_item( item )
	{}

	PCheckListItem ( T item, TQListView * parent, TQListViewItem * after, const TQString & text, Type tt = Controller ) :
			TQCheckListItem ( parent, after, text, tt ), m_item( item )
	{}

	PCheckListItem ( T item, TQListViewItem * parent, const TQString & text, const TQPixmap & p ) :
			TQCheckListItem ( parent, text, p ), m_item( item )
	{}

	PCheckListItem ( T item, TQListView * parent, const TQString & text, const TQPixmap & p ) :
			TQCheckListItem ( parent, text, p ), m_item( item )
	{}

	T item()
	{
		return m_item;
	}

	TQString templateAddition;

private:
	T m_item;
};

template <class T>
class PListViewItem: public TQListViewItem
{
public:

	PListViewItem ( T item, TQListViewItem * parent, TQListViewItem * after, const TQString & text ) :
			TQListViewItem ( parent, after, text ), m_item( item )
	{}

	PListViewItem ( T item, TQListViewItem * parent, const TQString & text ) :
			TQListViewItem ( parent, text ), m_item( item )
	{}

	PListViewItem ( T item, TQListView * parent, const TQString & text ) :
			TQListViewItem ( parent, text ), m_item( item )
	{}

	PListViewItem ( T item, TQListView * parent, TQListViewItem * after, const TQString & text ) :
			TQListViewItem ( parent, after, text ), m_item( item )
	{}

	T item()
	{
		return m_item;
	}

	TQString templateAddition;
private:
	T m_item;
};


class CppNewClassDialog : public CppNewClassDialogBase
{
	TQ_OBJECT
  

public:
	CppNewClassDialog( CppSupportPart *part, TQWidget *parent = 0, const char *name = 0 );
	~CppNewClassDialog();

protected:
	virtual void accept();
	virtual void classNameChanged( const TQString &text );
	virtual void classNamespaceChanged( const TQString &text );
	virtual void headerChanged();
	virtual void implementationChanged();
	virtual void nameHandlerChanged( const TQString &text );
	virtual void baseclassname_changed( const TQString &text );
	virtual void baseIncludeChanged( const TQString &text );

	virtual void addBaseClass();
	virtual void remBaseClass();
	virtual void remBaseClassOnly();
	virtual void currBaseNameChanged( const TQString &text );
	virtual void currBasePrivateSet();
	virtual void currBaseProtectedSet();
	virtual void currBasePublicSet();
	virtual void currBaseVirtualChanged( int val );
	virtual void currBaseSelected( TQListViewItem *it );
	virtual void scopeboxActivated( int value );

	virtual void checkObjCInheritance( int val );
	virtual void checkTQWidgetInheritance( int val );

	virtual void upbaseclass_button_clicked();
	virtual void downbaseclass_button_clicked();
	virtual void baseclasses_view_selectionChanged();

	virtual void newTabSelected( const TQString &text );
	virtual void newTabSelected( TQWidget *w );
	virtual void access_view_mouseButtonPressed( int button, TQListViewItem * item, const TQPoint &p, int c );
	virtual void changeToPrivate();
	virtual void changeToProtected();
	virtual void changeToPublic();
	virtual void changeToInherited();
	virtual void methods_view_mouseButtonPressed( int button , TQListViewItem * item, const TQPoint&p , int c );
	virtual void extendFunctionality();
	virtual void replaceFunctionality();
	virtual void to_constructors_list_clicked();
	virtual void clear_selection_button_clicked();
	virtual void selectall_button_clicked();
	virtual void gtk_box_stateChanged( int val );
	virtual void qobject_box_stateChanged( int val );
	virtual void headeronly_box_stateChanged(int val);

	void reloadAdvancedInheritance( bool clean = false );
	void parseClass( TQString clName, TQString inheritance );
	void parsePCSClass( TQString clName, TQString inheritance );
	void addToConstructorsList( TQCheckListItem *myClass, FunctionDom method );
	void addToMethodsList( TQListViewItem *parent, FunctionDom method );
	void addToUpgradeList( TQListViewItem *parent, FunctionDom method, TQString modifier );
	void addToUpgradeList( TQListViewItem *parent, VariableDom attr, TQString modifier );
	void clearConstructorsList( bool clean = false );
	void clearMethodsList( bool clean = false );
	void clearUpgradeList( bool clean = false );
	bool isConstructor( TQString className, const FunctionDom &method );
	bool isDestructor( TQString className, const FunctionDom &method );

private:

	bool headerModified;
	bool baseincludeModified;
	bool implementationModified;
	TQString m_parse;
	TQPopupMenu *accessMenu;
	TQPopupMenu *overMenu;
	CppSupportPart *m_part;
	CodeModel *myModel;

	// configuration variables
	TQString interface_url;
	TQString implementation_url;
	TQString interface_suffix;
	TQString implementation_suffix;
	TQStringList currNamespace;
	bool lowercase_filenames;
	TQStringList currBaseClasses;
	TDECompletion * compBasename;
	TDECompletion * compNamespace;

	void setCompletionBasename( CodeModel *model );
	void addCompletionBasenameNamespacesRecursive( const NamespaceDom & namespaceDom, const TQString & namespaceParent = "" );
	void setCompletionNamespaceRecursive( const NamespaceDom & namespaceDom, const TQString & namespaceParent = "" );
	void setStateOfInheritanceEditors( bool state, bool hideList = true );
	void setAccessForBase( TQString baseclass, TQString newAccess );
	void setAccessForItem( TQListViewItem *curr, TQString newAccess, bool isPublic );
	void remClassFromAdv( TQString text );
	void checkUpButtonState();
	void checkDownButtonState();
	void updateConstructorsOrder();

	TQString classNameFormatted();
	TQString templateStrFormatted();
	TQString templateParamsFormatted();
	TQString classNameFormatted( const TQString & );
	TQString templateStrFormatted( const TQString & );
	TQString templateParamsFormatted( const TQString & );
	TQString templateActualParamsFormatted( const TQString & );
	void removeTemplateParams( TQString & );

	friend class ClassGenerator;

	//! The class that translates UI input to a class
	class ClassGenerator
	{

	public:
		ClassGenerator( CppNewClassDialog& _dlg ) : dlg( _dlg )
		{}
		bool generate();

	private:
		bool validateInput();
		void common_text();
		void gen_implementation();
		void gen_interface();
		void genMethodDeclaration( FunctionDom method, TQString className, TQString templateStr,
		                           TQString *adv_h, TQString *adv_cpp, bool extend, TQString baseClassName );

		void beautifyHeader( TQString &templ, TQString &headerGuard,
		                     TQString &includeBaseHeader, TQString &author, TQString &doc, TQString &className, TQString &templateStr,
		                     TQString &baseclass, TQString &inheritance, TQString &qobjectStr, TQString &args,
		                     TQString &header, TQString &namespaceBeg, TQString &constructors, TQString &advH_public,
		                     TQString &advH_public_slots,
		                     TQString &advH_protected, TQString &advH_protected_slots, TQString &advH_private, TQString &advH_private_slots,
		                     TQString &namespaceEnd );
		void beautifySource( TQString &templ, TQString &header, TQString &className, TQString &namespaceBeg,
		                     TQString &constructors, TQString &advCpp, TQString &namespaceEnd, TQString &implementation );

		TQString className;
		TQString templateStr;
		TQString templateParams;
		TQString header;
		TQString implementation;

		TQString advConstructorsHeader;
		TQString advConstructorsSource;

		KDevProject *project;
		TQString subDir, headerPath, implementationPath;
		TQString doc;
		TQString namespaceStr;
		bool childClass;
		bool objc;
		bool qobject;
		bool gtk;
		bool headeronly;
		TQStringList namespaces;
		TQString namespaceBeg, namespaceEnd;
		TQString argsH;
		TQString argsCpp;

		TQString advH_public;
		TQString advH_public_slots;
		TQString advH_protected;
		TQString advH_protected_slots;
		TQString advH_private;
		TQString advH_private_slots;
		TQString advCpp;


		CppNewClassDialog& dlg;
	};


	//! workaround to make gcc 2.95.x happy
	friend class CppNewClassDialog::ClassGenerator;
};

#endif 
