
#include "plugin_%{APPNAMELC}.h"

#include <tdehtml_part.h>
#include <tdeaction.h>
#include <kinstance.h>
#include <tdemessagebox.h>
#include <tdelocale.h>
#include <tdeglobal.h>

Plugin%{APPNAME}::Plugin%{APPNAME}( TQObject* parent, const char* name )
    : Plugin( parent, name )
{
    // Instantiate all of your actions here.  These will appear in
    // Konqueror's menu and toolbars.
    (void) new TDEAction( i18n("&Plugin Action"), "%{APPNAMELC}", 0,
                        this, TQ_SLOT(slotAction()),
                        actionCollection(), "plugin_action" );
}

Plugin%{APPNAME}::~Plugin%{APPNAME}()
{
}

void Plugin%{APPNAME}::slotAction()
{
    // This plugin assumes TDEHTMLPart.  If your plugin can handle more
    // than this or a different Part than this, simply delete or
    // change the following block.
    if ( !parent()->inherits("TDEHTMLPart") )
    {
        TQString title( i18n( "Cannot Translate Source" ) );
        TQString text( i18n( "You cannot translate anything except web pages "
                            "with this plugin." ) );

        KMessageBox::sorry( 0, text, title );
        return;
    }

    // Get a handle on our parent so we may get the necessary data for
    // processing
    TDEHTMLPart *part = dynamic_cast<TDEHTMLPart *>(parent());

    // This plugin only uses the URL.  You may use whatever data you
    // need.
    KURL url( part->url() );

    // This is a standard check to make sure we are dealing with a
    // valid URL
    if ( !url.isValid() )
    {
        TQString title( i18n( "Malformed URL" ) );
        TQString text( i18n( "The URL you entered is not valid, please "
                            "correct it and try again" ) );

        KMessageBox::sorry( 0, text, title );
        return;
    }

// The following block is very plugin specific.  In this example, we
// translate the current page with AltaVista's BabelFish.  You will
// definitely want to change this.
// BEGIN
    KURL work( "http://babel.altavista.com/translate.dyn" );

    TQString query( "urltext=" );
    query += KURL::encode_string( url.url() );
    work.setQuery( query );
// END

    // Finally, execute the request
    part->openURL( work );
}

%{APPNAME}Factory::%{APPNAME}Factory()
  : KLibFactory()
{
}

%{APPNAME}Factory::~%{APPNAME}Factory()
{
  delete s_instance;
  s_instance = 0;
}

TQObject* %{APPNAME}Factory::createObject( TQObject* parent, const char* name, const char*, const TQStringList & )
{
  return new Plugin%{APPNAME}( parent, name );
}

TDEInstance *%{APPNAME}Factory::instance()
{
  if ( !s_instance )
    s_instance = new TDEInstance( "%{APPNAMELC}" );
  return s_instance;
}

extern "C"
{
  void* init_lib%{APPNAMELC}plugin()
  {
    TDEGlobal::locale()->insertCatalogue("%{APPNAMELC}");
    return new %{APPNAME}Factory;
  }
}

TDEInstance* %{APPNAME}Factory::s_instance = 0L;

#include "plugin_%{APPNAMELC}.moc"
