/***************************************************************************
                        cppcodecompletion.h  -  description
                           -------------------
  begin                : Sat Jul 21 2001
  copyright            : (C) 2001 by Victor R�er
  email                : victor_roeder@gmx.de
  copyright            : (C) 2002,2003 by Roberto Raggi
  email                : roberto@kdevelop.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __CPPCODECOMPLETION_H__
#define __CPPCODECOMPLETION_H__

#include "cppsupportpart.h"
#include "declarationinfo.h"

#include <ast.h>
#include <codemodel.h>
#include <set>

#include <tdetexteditor/viewcursorinterface.h>
#include <tdetexteditor/editinterface.h>
#include <tdetexteditor/codecompletioninterface.h>
#include <tdetexteditor/texthintinterface.h>
#include <tdetexteditor/cursorinterface.h>
#include <tdetexteditor/view.h>

#include <tqobject.h>
#include <tqmutex.h>
#include <tqstringlist.h>
#include <tqtimer.h>
#include <tqguardedptr.h>
#include <tqregexp.h>

#include "driver.h"
///A little debugging class
#include <tqpopupmenu.h>
class PopupTracker : public TQObject {
	TQ_OBJECT
  
public:
	static PopupTracker* pt;
	
	static uint pendingPopups;
	
	static TQPopupMenu* createPopup( TQWidget* parent ) {
		if( !pt ) pt = new PopupTracker();
		TQPopupMenu* m = new TQPopupMenu( parent );
		++pendingPopups;
		connect( m, TQT_SIGNAL(destroyed()), pt, TQT_SLOT(destroyedPopup()) );
		return m;
	}
	
	static void print() {
		if( pendingPopups )
			kdDebug( 9007 ) << "PopupTracker: " << pendingPopups << " popups are still alive" << endl;
	}
	
public slots:
	void destroyedPopup() {
		--pendingPopups;
	}
};


class CodeCompletionEntry;
class CodeInformationRepository;
class SimpleContext;
class SimpleType;
class SimpleTypeNamespace;
class CppCodeCompletionData;
class SimpleTypeConfiguration;
class TypeDesc;
struct PopupFillerHelpStruct;
struct PopupClassViewFillerHelpStruct;
class SimpleTypeImpl;
class TranslationUnitAST;
namespace CppEvaluation
{
  class EvaluationResult;
}
struct ExpressionInfo;

typedef TDESharedPtr<SimpleTypeImpl> TypePointer;

class CppCodeCompletion : public TQObject
{
	TQ_OBJECT
  
public:
    friend class SimpleType;
	enum CompletionMode
	{
	    NormalCompletion,
	    SignalCompletion,
	    SlotCompletion,
	    VirtualDeclCompletion
	};
	enum MemberAccessOp
	{
		NoOp,
		DotOp,
		ArrowOp
	};
    
public:
	CppCodeCompletion( CppSupportPart* part );
	virtual ~CppCodeCompletion();

	CodeInformationRepository* repository()
	{
		return m_repository;
	}
	CompletionMode completionMode() const
	{
		return m_completionMode;
	}

	TQString createTypeInfoString( int line, int column );
	
    TQString replaceCppComments( const TQString& contents );
    int expressionAt( const TQString& text, int index );
	TQStringList splitExpression( const TQString& text );
	
    CppEvaluation::EvaluationResult evaluateExpression( ExpressionInfo expr, SimpleContext* ctx );

    CppEvaluation::EvaluationResult evaluateExpressionAt( int line, int column, SimpleTypeConfiguration& conf, bool ifUnknownSetType = false );
    
    void contextEvaluationMenus ( TQPopupMenu *popup, const Context *context, int line, int col );

	CppSupportPart* cppSupport() const;

    HashedStringSet getIncludeFiles( const TQString& file = TQString() );

    static CppCodeCompletion* instance() {
      return m_instance;
    }

    ///Adds a string that will be ticked through the status-bar
    void addStatusText( TQString text, int timeout );
    void clearStatusText();

    TQString activeFileName() const {
      return m_activeFileName;
    }
  
public slots:
	/**
	 * @param invokedOnDemand if true and there is exactly one matching entry
	 *        complete the match immediately without showing the completion box.
	 *        This is only true, when the users invokes the completion himself
	 *        (eg presses the completion shortcut CTRL+space)
	 */
	void completeText( bool invokedOnDemand = false );
private slots:
    void emptyCache();
	void slotPartAdded( KParts::Part *part );
	void slotActivePartChanged( KParts::Part *part );
	void slotArgHintHidden();
	void slotCompletionBoxHidden();
	void slotTextChanged();
	void slotFileParsed( const TQString& fileName );
	void slotCodeModelUpdated( const TQString& fileName );
    void slotTimeout();
    void slotStatusTextTimeout();
    void computeFileEntryList();
    bool isTypeExpression( const TQString& expr );
	void slotTextHint( int line, int col, TQString &text );
    void popupAction( int number );
	void popupDefinitionAction( int number );
    void popupClassViewAction( int number );
	void synchronousParseReady( const TQString& file, ParsedFilePointer unit );
	void slotJumpToDefCursorContext();
	void slotJumpToDeclCursorContext();
	
private:
	enum FunctionType { Declaration, Definition };
	
    TypePointer createGlobalNamespace();
	bool functionContains( FunctionDom f , int line, int col );
	void getFunctionBody( FunctionDom f , int& line, int& col );
	void selectItem( ItemDom item );
    void addTypePopups( TQPopupMenu* parent, TypeDesc d, TQString depthAdd, TQString prefix = "" );
    void addTypeClassPopups( TQPopupMenu* parent, TypeDesc d, TQString depthAdd, TQString prefix = "" );
  TQValueList<TQStringList> computeSignatureList( CppEvaluation::EvaluationResult function );
	void integratePart( KParts::Part* part );
	void setupCodeInformationRepository();
	FunctionDefinitionAST* functionDefinition( AST* node );
	void computeRecoveryPoints( ParsedFilePointer unit );
	void computeRecoveryPointsLocked();
	void jumpCursorContext( FunctionType );
	bool getIncludeInfo( int line, TQString& includeFileName, TQString& includeFilePath, bool& usedProjectFiles );
	
    enum EvaluateExpressionOptions {
        IncludeStandardExpressions = 1,
        IncludeTypeExpression = 2,
        CompletionOption = 4, ///Cut off the last word because it is incomplete
	    SearchInFunctions = 8,
        SearchInClasses = 16,
        DefaultAsTypeExpression = 32, ///This makes the evaluation interpret any unidentified expression as a type-expression
        DefaultEvaluationOptions = 1 | 2 | 8 | 16,
        DefaultCompletionOptions = 1 | 4 | 8 | 16
    };
    
    bool mayBeTypeTail( int line, int column, TQString& append, bool inFunction = false );
    bool canBeTypePrefix( const TQString& prefix, bool inFunction = false );
    

    ExpressionInfo findExpressionAt( int line, int col, int startLine, int startCol, bool inFunction = false );
	SimpleContext* computeFunctionContext( FunctionDom f, int line, int col, SimpleTypeConfiguration& conf );
    
    CppEvaluation::EvaluationResult evaluateExpressionType( int line, int column, SimpleTypeConfiguration& conf, EvaluateExpressionOptions opt = DefaultCompletionOptions  );
    SimpleType unTypeDef( SimpleType scope , TQMap<TQString, TQString>& typedefs );
    
  //    TQString buildSignature( TypePointer currType );
    SimpleType typeOf( TQValueList<Tag>& tags, MemberAccessOp accessOp );
    
	/// @todo remove isInstance
	void computeCompletionEntryList( TQValueList<CodeCompletionEntry>& entryList, SimpleContext* ctx, bool isInstance, int depth = 0 );
	void computeCompletionEntryList( SimpleType type, TQValueList<CodeCompletionEntry>&
                entryList, const TQStringList& typeList, SimpleTypeNamespace* ns, std::set<HashedString>& ignore, bool isInstance, int depth = 0  );
	void computeCompletionEntryList( SimpleType type, TQValueList<CodeCompletionEntry>&
                entryList, const TQStringList& typeList, bool isInstance, int depth = 0  );
	void computeCompletionEntryList( SimpleType type, TQValueList<CodeCompletionEntry>& entryList, TQValueList<Tag>& tags, bool isInstance, int depth  );
	void computeCompletionEntryList( SimpleType type, TQValueList<CodeCompletionEntry>& entryList, ClassDom klass, bool isInstance, int depth   );
	void computeCompletionEntryList( SimpleType type, TQValueList<CodeCompletionEntry>& entryList, NamespaceDom scope, bool isInstance, int depth   );
	void computeCompletionEntryList( SimpleType type, TQValueList<CodeCompletionEntry>& entryList, const FunctionList& methods, bool isInstance, int depth );
	void computeCompletionEntryList( SimpleType type, TQValueList<CodeCompletionEntry>& entryList, const VariableList& attributes, bool isInstance, int depth );
	void computeCompletionEntryList( TQString parent, SimpleType type, TQValueList<CodeCompletionEntry>& entryList, const ClassList& lst, bool isInstance, int depth );
	void computeCompletionEntryList( TQString parent, SimpleType type, TQValueList<CodeCompletionEntry>& entryList, const TypeAliasList& lst, bool isInstance, int depth );
	void computeCompletionEntryList( SimpleType type, TQValueList<CodeCompletionEntry>& entryList, const NamespaceList& lst, bool isInstance, int depth );

	SimpleContext* computeContext( FunctionDefinitionAST* ast, int line, int col, int lineOffset, int colOffset );
	void computeContext( SimpleContext*& ctx, StatementAST* ast, int line, int col );
	void computeContext( SimpleContext*& ctx, StatementListAST* ast, int line, int col );
	void computeContext( SimpleContext*& ctx, IfStatementAST* ast, int line, int col );
	void computeContext( SimpleContext*& ctx, ForStatementAST* ast, int line, int col );
	void computeContext( SimpleContext*& ctx, DoStatementAST* ast, int line, int col );
	void computeContext( SimpleContext*& ctx, WhileStatementAST* ast, int line, int col );
	void computeContext( SimpleContext*& ctx, SwitchStatementAST* ast, int line, int col );
	void computeContext( SimpleContext*& ctx, TryBlockStatementAST* ast, int line, int col );
	void computeContext( SimpleContext*& ctx, CatchStatementListAST* ast, int line, int col );
	void computeContext( SimpleContext*& ctx, CatchStatementAST* ast, int line, int col );
	void computeContext( SimpleContext*& ctx, DeclarationStatementAST* ast, int line, int col );
	void computeContext( SimpleContext*& ctx, ConditionAST* ast, int line, int col );
	bool inContextScope( AST* ast, int line, int col, bool checkStart = true, bool checkEnd = true );

	TQString getText( int startLine, int startColumn, int endLine, int endColumn, int omitLine = -1 );
	
    
private:
    
    friend class SimpleTypeCatalog;
    friend class SimpleTypeCodeModel;
    friend class SimpleTypeImpl;
    friend class ExpressionEvaluation;
    friend class PopupFillerHelpStruct;
    friend class PopupClassViewFillerHelpStruct;
    TQGuardedPtr<CppSupportPart> m_pSupport;
	TQTimer* m_ccTimer;
    TQTimer* m_showStatusTextTimer;
    TQValueList<TQPair<int, TQString> > m_statusTextList;

    void fitContextItem( int nLine, int nColumn );
	void needRecoveryPoints();
    
	TQString m_activeFileName;
	KTextEditor::ViewCursorInterface* m_activeCursor;
	KTextEditor::EditInterface* m_activeEditor;
    KTextEditor::TextHintInterface* m_activeHintInterface;
	KTextEditor::CodeCompletionInterface* m_activeCompletion;
	KTextEditor::View* m_activeView;
	
	bool m_bArgHintShow;
	bool m_bCompletionBoxShow;
	bool m_blockForKeyword;
	bool m_demandCompletion;

	unsigned int m_ccLine;
	unsigned int m_ccColumn;
    static CppCodeCompletion* m_instance;

	CodeInformationRepository* m_repository;
	CppCodeCompletionData* d;
	CompletionMode m_completionMode;

	TQTime m_lastHintTime;

    //If more then the given count of comments were requested, all following ones will be blank.(Performance-reasons)
    void setMaxComments( int count );
    
    TQString commentFromItem( const SimpleType& parent, const ItemDom& item );
    TQString commentFromTag( const SimpleType& parent, Tag& tag );
        
    ItemDom m_cachedFromContext;  ///Can be a function or a class, representing the position from where the last completion was started. Necessary as long as all imports are put into the global namespace.
	
	TQRegExp m_includeRx;
	TQRegExp m_cppCodeCommentsRx;
	TQRegExp m_codeCompleteChRx;
	TQRegExp m_codeCompleteCh2Rx;
    TQValueList<KTextEditor::CompletionEntry> m_fileEntryList;

    int m_maxComments;
    
    typedef TQMap<int, DeclarationInfo> PopupActions;
    typedef TQMap<int, ItemDom> PopupClassViewActions;
    PopupActions m_popupActions;
    PopupActions m_popupDefinitionActions;
    PopupClassViewActions m_popupClassViewActions;
	
	// we need something to plug actions that are not in any menu 
	// into in order for their shortcuts to work
	TQWidget m_DummyActionWidget;
};

#endif 
