/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#if defined(DESIGNER)
#include "database.h"
#else
#include "database2.h"
#endif

#ifndef TQT_NO_SQL

#if defined(DESIGNER)
#include "formwindow.h"
#include "mainwindow.h"
#endif

#include <tqsqldatabase.h>
#include <tqsqlform.h>
#include <tqsqlcursor.h>
#include <tqsqlrecord.h>

DatabaseSupport::DatabaseSupport()
{
    con = 0;
    frm = 0;
    parent = 0;
}

void DatabaseSupport::initPreview( const TQString &connection, const TQString &table, TQObject *o,
				   const TQMap<TQString, TQString> &databaseControls )
{
    tbl = table;
    dbControls = databaseControls;
    parent = o;

    if ( connection != "(default)" )
	con = TQSqlDatabase::database( connection );
    else
	con = TQSqlDatabase::database();
    frm = new TQSqlForm( o, table );
    for ( TQMap<TQString, TQString>::Iterator it = dbControls.begin(); it != dbControls.end(); ++it ) {
	TQObject *chld = parent->child( it.key(), "TQWidget" );
	if ( !chld )
	    continue;
	frm->insert( (TQWidget*)chld, *it );
    }
}

QDesignerDataBrowser::QDesignerDataBrowser( TQWidget *parent, const char *name )
    : TQDataBrowser( parent, name )
{
}

bool QDesignerDataBrowser::event( TQEvent* e )
{
    bool b = TQDataBrowser::event( e );
#if defined(DESIGNER)
    if ( MainWindow::self->isPreviewing() ) {
#endif
	if ( e->type() == TQEvent::Show ) {
	    if ( con ) {
		TQSqlCursor* cursor = new TQSqlCursor( tbl, TRUE, con );
		setSqlCursor( cursor, TRUE );
		setForm( frm );
		refresh();
		first();
	    }
	    return TRUE;
	}
#if defined(DESIGNER)
    }
#endif
    return b;
}

QDesignerDataView::QDesignerDataView( TQWidget *parent, const char *name )
    : TQDataView( parent, name )
{
}

bool QDesignerDataView::event( TQEvent* e )
{
    bool b = TQDataView::event( e );
#if defined(DESIGNER)
    if ( MainWindow::self->isPreviewing() ) {
#endif
	if ( e->type() == TQEvent::Show ) {
	    setForm( frm );
	    readFields();
	    return TRUE;
	}
#if defined(DESIGNER)
    }
#endif
    return b;
}


#endif
