/*
 * Copyright (C) 2003 Helge Deller <deller@kde.org>
 */

#ifndef _KMOBILE_H_
#define _KMOBILE_H_

#include <tdeapplication.h>
#include <tdemainwindow.h>
#include <ktrader.h>

#include "kmobileview.h"

class TDEToggleAction;
class SystemTray;

/**
 * This class serves as the main window for KMobile.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 */
class KMobile : public TDEMainWindow
{
    Q_OBJECT
  
public:
    /**
     * Default Constructor
     */
    KMobile();

    /**
     * Default Destructor
     */
    virtual ~KMobile();

    KMobileView * mainView() const { return m_view; };

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    void saveProperties(TDEConfig *);

    /**
     * This function is called when this app is restored.  The TDEConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    void readProperties(TDEConfig *);

public slots:

    void saveAll();
    void restoreAll();

private slots:
    void dockApplication();
    void slotQuit();
    void showMinimized();

    void fileSave();
    void optionsShowToolbar();
    void optionsShowStatusbar();
    void optionsConfigureKeys();
    void optionsConfigureToolbars();

    void addDevice();
    void removeDevice();
    void configDevice();

    void renameDevice();

    void optionsPreferences();

    void newToolbarConfig();

    void changeStatusbar(const TQString& text);

private:
    void setupAccel();
    void setupActions();

    bool queryExit();
    bool queryClose();

private:
    TDEConfig *m_config;

    KMobileView *m_view;
    SystemTray *m_systemTray;

    TDEToggleAction *m_toolbarAction;
    TDEToggleAction *m_statusbarAction;
};

#endif // _KMOBILE_H_
