/***************************************************************************
 *
 * tdenetman-devicestore_dbus.cpp - A NetworkManager frontend for TDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig        <thoenig@suse.de>, <thoenig@nouse.net>
 *         Valentine Sinitsyn <e_val@inbox.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// tqt headers
#include <tqwidget.h>
#include <tqlineedit.h>
#include <tqcheckbox.h>
#include <tqlayout.h>

// tdenm headers
#include "tdenetman-connection_setting_info_widget.h"

using namespace ConnectionSettings;

InfoWidgetImpl::InfoWidgetImpl(TDENetworkConnection* conn, TQWidget* parent, const char* name, WFlags fl)
	: WidgetInterface(parent, name, fl)
{
	_infosetting = conn;
	_parentdialog = dynamic_cast<ConnectionSettingsDialogImpl*>(parent);

	TQVBoxLayout* layout = new TQVBoxLayout(this, 1, 1);
	_mainWid = new ConnectionSettingInfoWidget(this);
	layout->addWidget(_mainWid);

	Init();
}

void
InfoWidgetImpl::Init()
{
	connect(_mainWid->txtConnectionName, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(slotNameChanged(const TQString&)));
	connect(_mainWid->chkAutoConnect, TQ_SIGNAL(toggled(bool)), this, TQ_SLOT(slotAutoconnectChanged(bool)));
}

void
InfoWidgetImpl::Activate()
{
	_mainWid->txtConnectionName->setText(_infosetting->friendlyName);
	_mainWid->chkAutoConnect->setChecked(_infosetting->autoConnect);
}

void
InfoWidgetImpl::slotNameChanged(const TQString& name)
{
	_infosetting->friendlyName = name;
	if (_parentdialog) _parentdialog->slotEnableButtons();	// Update lockouts
}

void
InfoWidgetImpl::slotAutoconnectChanged(bool autoconnect)
{
	_infosetting->autoConnect = autoconnect;
	if (_parentdialog) _parentdialog->slotEnableButtons();	// Update lockouts
}

#include "tdenetman-connection_setting_info_widget.moc"
