/*
 *  Copyright (C) 2015 Timothy Pearson <kb9vqf@pearsoncomputing.net>.
 *  LibVNCServer (C) 2001 Johannes E. Schindelin <Johannes.Schindelin@gmx.de>
 *  Original OSXvnc (C) 2001 Dan McGuirk <mcguirk@incompleteness.net>.
 *  Original Xvnc (C) 1999 AT&T Laboratories Cambridge.
 *  All Rights Reserved.
 *
 *  see GPL (latest version) for full details
 */

#ifndef _MAIN_H
#define _MAIN_H

class ControlPipeHandlerObject : public TQObject
{
	TQ_OBJECT

	public:
		ControlPipeHandlerObject();
		~ControlPipeHandlerObject();

	public slots:
		void run();
		void requestExit() { d.requestExit = true; }

	public:
		struct Data
		{
		  rfbScreenInfoPtr rfbData;
		  bool requestExit;
		};
		Data d;
};

class OnHoldClientHandlerObject : public TQObject
{
	TQ_OBJECT

	public:
		OnHoldClientHandlerObject();
		~OnHoldClientHandlerObject();

	public slots:
		void run();
		void requestExit() { d.requestExit = true; }

	public:
		struct Data
		{
		  rfbClientPtr rfbData;
		  bool requestExit;
		};
		Data d;
};

class ClientOutputHandlerObject : public TQObject
{
	TQ_OBJECT

	public:
		ClientOutputHandlerObject();
		~ClientOutputHandlerObject();

	public slots:
		void run();
		void requestExit() { d.requestExit = true; }

	public:
		struct Data
		{
		  rfbClientPtr rfbData;
		  bool requestExit;
		};
		Data d;
};

#endif // _MAIN_H

