/***************************************************************************
                            kbattleshipclient.cpp
                             -------------------
    Developers: (c) 2000-2001 Nikolas Zimmermann <wildfox@kde.org>
                (c) 2000-2001 Daniel Molkentin <molkentin@kde.org>

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <unistd.h>
#ifdef HAVE_STROPTS_H
#include <stropts.h>
#endif
#ifdef HAVE_SYS_FILIO_H
#include <sys/filio.h>
#endif
#include <sys/ioctl.h>
#include <tqsocketnotifier.h>
#include "kmessage.h"
#include "kbattleshipclient.moc"

KBattleshipClient::KBattleshipClient(const TQString &host, int port) : KExtendedSocket(host, port, inetSocket)
{
}

void KBattleshipClient::init()
{
	if(connect())
	{
		emit sigSocketFailure(status());
		return;
	}

	m_readNotifier = new TQSocketNotifier(fd(), TQSocketNotifier::Read, TQT_TQOBJECT(this));
	TQObject::connect(m_readNotifier, TQT_SIGNAL(activated(int)), TQT_SLOT(slotReadData()));
	emit sigConnected();
}

void KBattleshipClient::sendMessage(KMessage *msg)
{
	TQCString post = msg->sendStream().utf8();
	writeBlock(post.data(), post.length());
	emit sigMessageSent(msg);
}

void KBattleshipClient::slotReadData()
{
	int len;
	ioctl(fd(), FIONREAD, &len);
	if(!len)
	{
		delete m_readNotifier;
		m_readNotifier = 0;
		emit sigEndConnect();
		return;
	}

	char *buf = new char[len + 1];
	readBlock(buf, len);
	buf[len] = 0;
	m_readBuffer += TQString::fromUtf8(buf);
	delete []buf;
	int pos;
	while ((pos = m_readBuffer.find("</kmessage>")) >= 0)
	{
		pos += 11; // Length of "</kmessage>"
		KMessage *msg = new KMessage();
		msg->setDataStream(m_readBuffer.left(pos));
		m_readBuffer.remove(0, pos);
		emit sigNewMessage(msg);
	}
}
