import org.trinitydesktop.qt.*;

public class ApplicationWindow extends TQMainWindow {
	private TQPrinter printer;
	private TQMultiLineEdit e;
	private String filename;

	private final String fileOpenText = "<img source=\"fileopen\"> "+
					"Click this button to open a <em>new file</em>. <br><br>"+
					"You can also select the <b>Open command</b> from the File menu.";
	private final String fileSaveText = "Click this button to save the file you are "+
					"editing.  You will be prompted for a file name.\n\n"+
					"You can also select the Save command from the File menu.\n\n"+
					"Note that implementing this function is left as an exercise for the reader.";
	private final String filePrintText = "Click this button to print the file you "+
					"are editing.\n\n"+
					"You can also select the Print command from the File menu.";

	private final String[] fileopen = {
		"    16    13        5            1",
		". c #040404",
		"# c #808304",
		"a c None",
		"b c #f3f704",
		"c c #f3f7f3",
		"aaaaaaaaa...aaaa",
		"aaaaaaaa.aaa.a.a",
		"aaaaaaaaaaaaa..a",
		"a...aaaaaaaa...a",
		".bcb.......aaaaa",
		".cbcbcbcbc.aaaaa",
		".bcbcbcbcb.aaaaa",
		".cbcb...........",
		".bcb.#########.a",
		".cb.#########.aa",
		".b.#########.aaa",
		"..#########.aaaa",
		"...........aaaaa"
	};

	private final String[] filesave = {
		"    14    14        4            1",
		". c #040404",
		"# c #808304",
		"a c #bfc2bf",
		"b c None",
		"..............",
		".#.aaaaaaaa.a.",
		".#.aaaaaaaa...",
		".#.aaaaaaaa.#.",
		".#.aaaaaaaa.#.",
		".#.aaaaaaaa.#.",
		".#.aaaaaaaa.#.",
		".##........##.",
		".############.",
		".##.........#.",
		".##......aa.#.",
		".##......aa.#.",
		".##......aa.#.",
		"b............."
	};
	
	private final String[] fileprint = {
		"    16    14        6            1",
		". c #000000",
		"# c #848284",
		"a c #c6c3c6",
		"b c #ffff00",
		"c c #ffffff",
		"d c None",
		"ddddd.........dd",
		"dddd.cccccccc.dd",
		"dddd.c.....c.ddd",
		"ddd.cccccccc.ddd",
		"ddd.c.....c....d",
		"dd.cccccccc.a.a.",
		"d..........a.a..",
		".aaaaaaaaaa.a.a.",
		".............aa.",
		".aaaaaa###aa.a.d",
		".aaaaaabbbaa...d",
		".............a.d",
		"d.aaaaaaaaa.a.dd",
		"dd...........ddd"
	};
	
	
	
	
	public ApplicationWindow() {
		super(null, "example application main window", WDestructiveClose);

		// create a printer

		printer = new TQPrinter();


		// create user interface actions

		TQAction fileNewAction, fileOpenAction, fileSaveAction,
				fileSaveAsAction, filePrintAction, fileCloseAction,
				fileQuitAction;

		fileNewAction = new TQAction("New", "&New", new TQKeySequence(CTRL+Key_N), this, "new", false);
		connect(fileNewAction, TQ_SIGNAL("activated()"), this, TQ_SLOT("newDoc()"));

		fileOpenAction = new TQAction("Open File", new TQIconSet(new TQPixmap(fileopen)), "&Open", new TQKeySequence(CTRL+Key_O), this, "open", false);
		connect(fileOpenAction, TQ_SIGNAL("activated()"), this, TQ_SLOT("load()"));
		TQMimeSourceFactory.defaultFactory().setPixmap("fileopen", new TQPixmap(fileopen));
		fileOpenAction.setWhatsThis(fileOpenText);

		fileSaveAction = new TQAction("Save File", new TQIconSet(new TQPixmap(filesave)), "&Save", new TQKeySequence(CTRL+Key_S), this, "save", false);
		connect(fileSaveAction, TQ_SIGNAL("activated()"), this, TQ_SLOT("save()"));
		fileSaveAction.setWhatsThis(fileSaveText);

		fileSaveAsAction = new TQAction("Save File As", "Save &as", new TQKeySequence(), this, "save as", false);
		connect(fileSaveAsAction, TQ_SIGNAL("activated()"), this, TQ_SLOT("saveAs()"));
		fileSaveAsAction.setWhatsThis(fileSaveText);

		filePrintAction = new TQAction("Print File", new TQIconSet(new TQPixmap(fileprint)), "&Print", new TQKeySequence(CTRL+Key_P), this, "print", false);
		connect(filePrintAction, TQ_SIGNAL("activated()"), this, TQ_SLOT("print()"));
		filePrintAction.setWhatsThis(filePrintText);

		fileCloseAction = new TQAction("Close", "&Close", new TQKeySequence(CTRL+Key_W), this, "close", false);
		connect(fileCloseAction, TQ_SIGNAL("activated()"), this, TQ_SLOT("close()"));

		fileQuitAction = new TQAction("Quit", "&Quit", new TQKeySequence(CTRL+Key_Q), this, "quit", false);
		connect(fileQuitAction, TQ_SIGNAL("activated()"), tqApp(), TQ_SLOT("closeAllWindows()"));


		// populate a tool bar with some actions

		TQToolBar fileTools = new TQToolBar(this, "file operations");
		fileTools.setLabel(tr("File Operations"));
		fileOpenAction.addTo(fileTools);
		fileSaveAction.addTo(fileTools);
		filePrintAction.addTo(fileTools);
		TQWhatsThis.whatsThisButton(fileTools);
		

		// popuplate a menu with all actions
		
		TQPopupMenu file = new TQPopupMenu(this, "file");
		menuBar().insertItem("&File", file);
		fileNewAction.addTo(file);
		fileOpenAction.addTo(file);
		fileSaveAction.addTo(file);
		fileSaveAsAction.addTo(file);
		file.insertSeparator();
		filePrintAction.addTo(file);
		file.insertSeparator();
		fileCloseAction.addTo(file);
		fileQuitAction.addTo(file);


		// add a help menu

		TQPopupMenu help = new TQPopupMenu(this, "help");
		menuBar().insertSeparator();
		menuBar().insertItem("&Help", help);
		help.insertItem("&About", this, TQ_SLOT("about()"), new TQKeySequence(Key_F1), -1, -1);
		help.insertItem("About &Qt", this, TQ_SLOT("aboutTQt()"));
		help.insertSeparator();
		help.insertItem("What's &This", this, TQ_SLOT("whatsThis()"), new TQKeySequence(SHIFT+Key_F1), -1, -1);


		// create and define the central widget

		e = new TQMultiLineEdit(this, "editor");
		e.setFocus();
		setCentralWidget(e);
		statusBar().message("Ready", 2000);
		resize(450, 600);
	}

	private void newDoc() {
		ApplicationWindow ed = new ApplicationWindow();
		ed.show();
	}

	private void load() {
		String fn = TQFileDialog.getOpenFileName("", "", this);
		if (!(fn.length()==0))
			load(fn);
		else
			statusBar().message("Loading aborted", 2000);
	}


	private void load(String fileName) {
		TQFile f = new TQFile(fileName);
		if (!f.open(1))
			return;

		filename = fileName;

		e.setAutoUpdate(false);
		e.clear();

		TQTextStream t = new TQTextStream(f);
		while (!t.eof()) {
			String s = t.readLine();
			e.append(s);
		}
		f.close();

		e.setAutoUpdate(true);
		e.repaint();
		e.setEdited(false);
		setCaption(fileName);
		String s = "Loaded document "+fileName;
		statusBar().message(s, 2000);
	}

	private void save() {
		if (filename.length()==0) {
			saveAs();
			return;
		}

		String text = e.text();
		TQFile f = new TQFile(filename);
		if (!f.open(2)) {
			statusBar().message("Could not write to "+filename, 2000);
			return;
		}

		TQTextStream t = new TQTextStream(f);
		t.writeRawBytes(text, text.length());
		f.close();

		e.setEdited(false);

		setCaption(filename);

		statusBar().message("File "+filename+" saved", 2000);
	}


	private void saveAs() {
		String fn = TQFileDialog.getSaveFileName("", "", this);
		if (!(fn.length()==0)) {
			filename = fn;
			save();
		} else {
			statusBar().message("Saving aborted", 2000);
		}
	}

	private void print() {
		final int Margin = 10;
		int pageNo = 1;

		if (printer.setup(this)) {   // printer dialog
			statusBar().message("Printing...");
			TQPainter p = new TQPainter();
			p.begin(printer);     // paint on printer
			p.setFont(e.font());
			int yPos = 0;      // y position for each line
			TQFontMetrics fm = p.fontMetrics();
			
			// need width/height of printer surface
			TQPaintDeviceMetrics metrics = new TQPaintDeviceMetrics(printer);
			
			for(int i = 0 ; i < e.numLines() ; i++) {
				if (Margin + yPos > metrics.height() - Margin) {
					String msg = "Printing (page ";
					msg += ++pageNo;
					msg += ")...";
					statusBar().message(msg);
					printer.newPage();   // no more room on this page
					yPos = 0;     // back to top of page
				}
				p.drawText(Margin, Margin + yPos, metrics.width(),
						fm.lineSpacing(), ExpandTabs | DontClip, e.textLine(i));
				yPos = yPos + fm.lineSpacing();
			}
			p.end();        // send job to printer
			statusBar().message("Printing completed", 2000);
		} else {
			statusBar().message("Printing aborted", 2000);
		}
	}

	protected void closeEvent(TQCloseEvent ce) {
		if (!e.edited()) {
			ce.accept();
			return;
		}

		switch(TQMessageBox.information(this, "Qt Application Example",
					"The document has been changed since the last save.",
					"Save Now", "Cancel", "Leave Anyway", 0, 1)) {
			case 0:
				save();
				ce.accept();
				break;
			case 1:
			default: // just for sanity
				ce.ignore();
				break;
			case 2:
				ce.accept();
				break;
		}
	}

	private void about() {
		TQMessageBox.about(this, "Qt Application Example",
				"This example demonstrates simple use of "+
				"TQMainWindow,\nTQMenuBar and TQToolBar.");
	}


	private void aboutTQt() {
		TQMessageBox.aboutTQt(this, "Qt Application Example");
	}
}
