
#include "logviewer.h"
#include "logger.h"

#include <tqlayout.h>
#include <tqstring.h>
#include <tqheader.h>
#include <tqcolor.h>

#include <tdelocale.h>
#include <kiconloader.h>
#include <tdelistview.h>
#include <kpushbutton.h>
#include <kurl.h>
//#include <kdebug.h>

// ### soundkonverter 0.4: make sub items for the output

LogViewerItem::LogViewerItem( TDEListView* parent, LogViewerItem* after, TQString label1 )
    : TDEListViewItem( parent, after, label1 )
{
    converting = false;
}

LogViewerItem::LogViewerItem( LogViewerItem* parent, LogViewerItem* after, TQString label1 )
    : TDEListViewItem( parent, after, label1 )
{
    converting = false;
}

LogViewerItem::~LogViewerItem()
{}

void LogViewerItem::paintCell( TQPainter *p, const TQColorGroup &cg, int column, int width, int alignment )
{
    // NOTE calculate the red color

    TQColorGroup _cg( cg );
    TQColor c;

    if( isSelected() && converting ) {
        _cg.setColor( TQColorGroup::Highlight, TQColor( 215, 62, 62 ) );
        TQListViewItem::paintCell( p, _cg, column, width, alignment );
        return;
    }
    else if( converting && column != listView()->sortColumn() ) {
        _cg.setColor( TQColorGroup::Base, TQColor( 255, 234, 234 ) );
        TQListViewItem::paintCell( p, _cg, column, width, alignment );
        return;
    }
    else if( converting && column == listView()->sortColumn() ) {
        _cg.setColor( TQColorGroup::Base, TQColor( 247, 227, 227 ) );
        TQListViewItem::paintCell( p, _cg, column, width, alignment );
        return;
    }

    TDEListViewItem::paintCell( p, _cg, column, width, alignment );
}


LogViewerList::LogViewerList( TQWidget* parent, const char* name )
    : TDEListView( parent, name )
{}

LogViewerList::~LogViewerList()
{}


LogViewer::LogViewer( Logger* _logger, TQWidget *parent, const char *name, bool modal, WFlags f )
    : KDialog( parent, name, modal, f )
{
    logger = _logger;
    connect( logger, TQT_SIGNAL(removedProcess(int)),
               this, TQT_SLOT(processRemoved(int))
             );
    connect( logger, TQT_SIGNAL(updateProcess(int)),
               this, TQT_SLOT(updateProcess(int))
             );

    // create an icon loader object for loading icons
    TDEIconLoader* iconLoader = new TDEIconLoader();

    setCaption( i18n("Log Viewer") );
    resize( 600, 400 );
    setIcon( iconLoader->loadIcon("view_text",TDEIcon::Small) );

    TQGridLayout *grid = new TQGridLayout( this, 4, 1, 11, 6 );

    lLogs = new LogViewerList( this, "lLogs" );
    lLogs->addColumn( i18n("Job/File") );
    //lLogs->setSelectionMode( TQListView::Extended );
    //lLogs->setAllColumnsShowFocus( true );
    lLogs->setResizeMode( TQListView::LastColumn );
    lLogs->setSorting( -1 );
    lLogs->setRootIsDecorated( true );
    lLogs->header()->setClickEnabled( false );
    grid->addWidget( lLogs, 0, 0 );

    TQHBoxLayout *buttonBox = new TQHBoxLayout();
    grid->addLayout( buttonBox, 3, 0 );

    pReload = new KPushButton(iconLoader->loadIcon("reload",TDEIcon::Small), i18n("Reload"), this, "pReload" );
    buttonBox->addWidget( pReload );
    connect( pReload, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(refillLogs())
             );

    buttonBox->addStretch();

    pOk = new KPushButton(iconLoader->loadIcon("system-log-out",TDEIcon::Small), i18n("Close"), this, "pOk" );
    pOk->setFocus();
    buttonBox->addWidget( pOk );
    connect( pOk, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(accept())
             );

    // delete the icon loader object
    delete iconLoader;

    refillLogs();
}

LogViewer::~LogViewer()
{}

void LogViewer::refillLogs()
{
    LogViewerItem *parent = 0, *last = 0;

    lLogs->clear();
    TQValueList<LoggerItem*> logs = logger->getLogs();
    for( TQValueList<LoggerItem*>::Iterator a = logs.begin(); a != logs.end(); ++a ) {
        parent = new LogViewerItem( lLogs, parent, KURL::decode_string((*a)->filename).replace("%2f","/").replace("%%","%") + " - " + TQString::number((*a)->id) );
        parent->converting = !(*a)->completed;
        //parent->setOpen( true );
        last = 0;
        for( TQStringList::Iterator b = (*a)->data.begin(); b != (*a)->data.end(); ++b ) {
            last = new LogViewerItem( parent, last, *b );
            last->setMultiLinesEnabled( true );
            last->converting = !(*a)->completed;
        }
    }
}

void LogViewer::processRemoved( int id )
{
    LoggerItem* item = logger->getLog( id ); // this is ok, because the item still exists.
                                             // it will be deleted after is function is completed

    TQListViewItem* it = lLogs->firstChild();

    while( it != 0 ) {
        if( it->text(0) == KURL::decode_string(item->filename).replace("%2f","/").replace("%%","%") + " - " + TQString::number(item->id) ) {
            delete it;
            return;
        }
        it = it->nextSibling();
    }
}

void LogViewer::updateProcess( int id )
{
    LoggerItem* item = logger->getLog( id );

    LogViewerItem* it = lLogs->firstChild();

    LogViewerItem *lastItem = 0, *oldItem = 0;

    while( it != 0 ) {
        if( it->text(0) == KURL::decode_string(item->filename).replace("%2f","/").replace("%%","%") + " - " + TQString::number(item->id) ) {
            LogViewerItem *a = it->firstChild(), *b;
            while( a != 0 ) {
                b = a->nextSibling();
                delete a;
                a = b;
            }
            it->converting = !item->completed;
            LogViewerItem* last = 0;
            for( TQStringList::Iterator b = item->data.begin(); b != item->data.end(); ++b ) {
                last = new LogViewerItem( (LogViewerItem*)it, last, *b );
                last->setMultiLinesEnabled( true );
            }
            return;
        }
        it = it->nextSibling();
    }

    LogViewerItem *parent = 0;

    // get the last list view item
    for( TQListViewItem* it = lLogs->firstChild(); it != 0; it = it->nextSibling() ) {
        lastItem = (LogViewerItem*)it;
    }

    parent = new LogViewerItem( lLogs, lastItem, KURL::decode_string(item->filename).replace("%2f","/").replace("%%","%") + " - " + TQString::number(item->id) );
    parent->converting = !item->completed;
    LogViewerItem* last = 0;
    for( TQStringList::Iterator b = item->data.begin(); b != item->data.end(); ++b ) {
        last = new LogViewerItem( parent, last, *b );
        last->setMultiLinesEnabled( true );
    }
}


