/***************************************************************************
    smb4ksearchdialog_part  -  This Part encapsulates the search dialog
    of Smb4K.
                             -------------------
    begin                : Fr Jun 1 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// TQt includes
#include <tqimage.h>
#include <tqpixmap.h>

// KDE includes
#include <tdeaboutdata.h>
#include <kinstance.h>
#include <kdebug.h>
#include <kiconeffect.h>
#include <kiconloader.h>
#include <kcombobox.h>

// application specific includes
#include "smb4ksearchdialog_part.h"
#include "smb4ksearchdialog.h"
#include "smb4ksearchdialogitem.h"
#include "../core/smb4kcore.h"
#include "../core/smb4knetworkitems.h"
#include "../core/smb4kdefs.h"

TDEInstance *Smb4KSearchDialogPartFactory::m_instance = 0L;
TDEAboutData *Smb4KSearchDialogPartFactory::m_about = 0L;


Smb4KSearchDialogPart::Smb4KSearchDialogPart( TQWidget *parentWidget, const char *widgetName,
                                              TQObject *parent, const char *name )
: KParts::Part( parent, name )
{
  // First of all we need an instance:
  setInstance( Smb4KSearchDialogPartFactory::instance() );

  // Set the XML file:
//   setXMLFile( "smb4ksearchdialog_part.rc" );

  // Set the widget of this part:
  m_widget = new Smb4KSearchDialog( parentWidget, widgetName );
  setWidget( m_widget );

  m_serial_number = 0;

  // Connections:
  connect( m_widget,              TQ_SIGNAL( buttonPressed( int ) ),
           this,                  TQ_SLOT( slotButtonPressed( int ) ) );

  connect( m_widget->listView(),  TQ_SIGNAL( doubleClicked( TQListViewItem * ) ),
           this,                  TQ_SLOT( slotItemDoubleClicked( TQListViewItem * ) ) );

  connect( Smb4KCore::scanner(),  TQ_SIGNAL( searchResult( Smb4KHostItem * ) ),
           this,                  TQ_SLOT( slotReceivedSearchResult( Smb4KHostItem * ) ) );

  connect( Smb4KCore::scanner(),  TQ_SIGNAL( hostListChanged() ),
           this,                  TQ_SLOT( slotCheckItemIsKnown() ) );
}


Smb4KSearchDialogPart::~Smb4KSearchDialogPart()
{
}


void Smb4KSearchDialogPart::customEvent( TQCustomEvent *e )
{
  switch ( e->type() )
  {
    case EVENT_LOAD_SETTINGS:
    {
      // Not needed at the moment.

      break;
    }
    case EVENT_SET_FOCUS:
    {
      m_widget->toolBar()->getCombo( Smb4KSearchDialog::Combo )->lineEdit()->setFocus();

      break;
    }
    default:
    {
      break;
    }
  }

  KParts::Part::customEvent( e );
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS (Smb4KSearchDialogPart)
/////////////////////////////////////////////////////////////////////////////

void Smb4KSearchDialogPart::slotButtonPressed( int button_id )
{
  switch ( button_id )
  {
    case Smb4KSearchDialog::Search:
    {
      Smb4KCore::scanner()->search( m_widget->searchString() );

      break;
    }
    case Smb4KSearchDialog::Add:
    {
      Smb4KSearchDialogItem *search_item = static_cast<Smb4KSearchDialogItem *>( m_widget->listView()->currentItem() );

      if ( search_item && !search_item->isKnown() )
      {
        Smb4KCore::scanner()->insertHost( search_item->hostItem() );
      }
      else
      {
        // Do nothing
      }

      break;
    }
    default:
    {
      break;
    }
  }
}


void Smb4KSearchDialogPart::slotReceivedSearchResult( Smb4KHostItem *item )
{
  if ( item )
  {
    // Create a Smb4KSearchDialogItem. This will also add it
    // to the list box.
    (void) new Smb4KSearchDialogItem( m_widget->listView(), item, m_serial_number++ );

    // Enable the combo box and set the focus:
    m_widget->toolBar()->setItemEnabled( Smb4KSearchDialog::Combo, true );
    m_widget->toolBar()->getCombo( Smb4KSearchDialog::Combo )->setFocus();

    // Now select the text, so that the user can easily
    // remove it.
    int string_length = m_widget->toolBar()->getCombo( Smb4KSearchDialog::Combo )->lineEdit()->text().length();
    m_widget->toolBar()->getCombo( Smb4KSearchDialog::Combo )->lineEdit()->setSelection( 0, string_length );

    slotCheckItemIsKnown();
  }
}


void Smb4KSearchDialogPart::slotCheckItemIsKnown()
{
  TQListViewItemIterator it( m_widget->listView() );

  while ( it.current() )
  {
    Smb4KSearchDialogItem *item = static_cast<Smb4KSearchDialogItem *>( it.current() );

    if ( item && item->isRegular() )
    {
      Smb4KHostItem *host = Smb4KCore::scanner()->getHost( item->hostItem()->name(), item->hostItem()->workgroup() );

      item->setKnown( (host ? true : false) );
    }
    else
    {
      // Do nothing
    }

    ++it;
  }
}


void Smb4KSearchDialogPart::slotItemDoubleClicked( TQListViewItem *item )
{
  if ( item )
  {
    // If we have got an item, enable the "Add" button if the
    // item is regular. Otherwise disable the button.
    Smb4KSearchDialogItem *search_item = static_cast<Smb4KSearchDialogItem *>( item );

    if ( search_item && search_item->isRegular() && !search_item->isKnown() )
    {
      Smb4KCore::scanner()->insertHost( search_item->hostItem() );
    }
    else
    {
      // Do nothing
    }
  }
}


/////////////////////////////////////////////////////////////////////////////
// FACTORY STUFF
/////////////////////////////////////////////////////////////////////////////

Smb4KSearchDialogPartFactory::Smb4KSearchDialogPartFactory()
: KParts::Factory()
{
}


Smb4KSearchDialogPartFactory::~Smb4KSearchDialogPartFactory()
{
  delete m_instance;
  delete m_about;

  m_instance = 0L;
}


KParts::Part *Smb4KSearchDialogPartFactory::createPartObject( TQWidget *parentWidget, const char *widgetName,
TQObject *parent, const char *name, const char *, const TQStringList & )
{
  Smb4KSearchDialogPart *obj = new Smb4KSearchDialogPart( parentWidget, widgetName, parent, name );

  // See if we are to be read-write or not
//   if (TQCString(classname) == "KParts::ReadOnlyPart")
//   {
//     obj->setReadWrite(false);
//   }

  return obj;
}


TDEInstance *Smb4KSearchDialogPartFactory::instance()
{
  if( !m_instance )
  {
    m_about = new TDEAboutData( "smb4ksearchdialogpart", I18N_NOOP( "Smb4KSearchDialogPart" ), "1.0" );
    m_about->addAuthor("Alexander Reinholdt", 0, "dustpuppy@users.berlios.de");
    m_about->setLicense( TDEAboutData::License_GPL );
    m_instance = new TDEInstance( m_about );
  }

  return m_instance;
}


/////////////////////////////////////////////////////////////////////////////
// INIT
/////////////////////////////////////////////////////////////////////////////

extern "C"
{
  TDE_EXPORT void *init_libsmb4ksearchdialog()
  {
    TDEGlobal::locale()->insertCatalogue( "smb4k" );
    return new Smb4KSearchDialogPartFactory;
  }
}

#include "smb4ksearchdialog_part.moc"
