/***************************************************************************
    smb4kglobal  -  This is the global namespace for Smb4K.
                             -------------------
    begin                : Sa Apr 2 2005
    copyright            : (C) 2005-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4TDEGLOBAL_H
#define SMB4TDEGLOBAL_H

#include <tqstring.h>
#include <tqtimer.h>

#include <kdemacros.h>
#include <tdeconfig.h>

// forward declarations:
class Smb4KPasswordHandler;
class Smb4KSambaOptionsHandler;
class Smb4KHomesSharesHandler;

/**
 * This is the global namespace for the core classes of Smb4K.
 *
 * @author    Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

namespace Smb4TDEGlobal KDE_EXPORT
{
  /**
   * This returns the pointer to the global timer for the application.
   * WARNING: Du *NOT* stop this timer anywhere in the program or all
   * actions that need a timer are stopped all over the application!
   *
   * @returns           A pointer to the global timer.
   */
  TQTimer *timer() KDE_DEPRECATED;

  /**
   * This function returns the interval of the timer.
   *
   * @returns           The interval of the timer in msec.
   */
  const int timerInterval();

  /**
   * This function will open a dialog where the user has to define a
   * user name to access a 'homes' share. Besides returning this name,
   * this function will also store the name in the configuration file.
   *
   * @param host        The host where the homes share is located
   *
   * @param parent      The parent widget
   *
   * @param name        The name of this dialog
   *
   * @returns           A user name
   */
  const TQString specifyUser( const TQString &host, TQWidget *parent = 0, const char *name = 0 );

  /**
   * This function returns the password handler.
   *
   * @returns           a pointer to the global password handler object.
   */
  Smb4KPasswordHandler *passwordHandler();

  /**
   * This function returns a pointer to the global Smb4KOptionsHandler object.
   * You need to use it if you want to retrieve (a) the custom options defined for
   * a share, (b) the argument strings for the 'net', 'smbclient', or 'nmblookup'
   * command, or (c) the options in the global section of the smb.conf configuration
   * file.
   *
   * @returns           a pointer to the global options handler object.
   */
  Smb4KSambaOptionsHandler *optionsHandler();

  /**
   * This function creates a temporary directory and returns its name. If it already
   * exists, only the name will be returned. If an failure occurrs, an error message
   * will be shown and an empty string is returned.
   *
   * @returns           the name of the temporary directory.
   */
  const TQString &tempDir();

  /**
   * Get the user names that are defined for a homes share.
   *
   * @param host        The name of the host where the 'homes' share is located.
   *
   * @returns           the list of user names for this homes share.
   */
  const TQStringList homesUsers( const TQString &host );
};

#endif
