/***************************************************************************
    smb4ksearchdialog  -  The search dialog widget of Smb4K.
                             -------------------
    begin                : Sa Jun 2 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// TQt includes
#include <tqlayout.h>
#include <tqstringlist.h>
#include <tqheader.h>

// KDE includes
#include <tdelocale.h>
#include <kdebug.h>
#include <kcombobox.h>

// application specific includes
#include "smb4ksearchdialog.h"
#include "smb4ksearchdialogitem.h"
#include "../core/smb4knetworkitems.h"

Smb4KSearchDialog::Smb4KSearchDialog( TQWidget *parent, const char *name )
: TQWidget( parent, name )
{
  TQGridLayout *layout = new TQGridLayout( this );
  layout->setSpacing( 5 );

  // Tool bar
  m_tool_bar = new TDEToolBar( this, "SearchDialogToolBar", true, true );

  m_tool_bar->insertCombo( TQStringList(), Combo, true, TQT_SIGNAL( returnPressed() ),
                           TQT_TQOBJECT(this), TQT_SLOT( slotReturnPressed() ), true,
                           i18n( "Enter the search string here." ), -1, Combo );
  m_tool_bar->setItemAutoSized( Combo, true );

  m_tool_bar->insertSeparator();

  m_tool_bar->insertButton( "edit-find", Search, false, i18n( "Search" ) );
  m_tool_bar->insertButton( "edit-delete", Clear, false, i18n( "Clear" ) );
  m_tool_bar->insertButton( "button_ok", Add, false, i18n( "Add" ) );

  // List view
  m_list_view = new TDEListView( this, "SearchDialogListView" );
  m_list_view->addColumn( i18n( "Search Results" ), -1 );
  m_list_view->header()->hide();
  m_list_view->setSelectionMode( TQListView::Single );

  layout->addWidget( m_tool_bar, 0, 0, 0 );
  layout->addWidget( m_list_view, 1, 0, 0 );

  m_search_string = TQString();

  // Connections:
  connect( m_tool_bar->getCombo( Combo ), TQT_SIGNAL( textChanged( const TQString & ) ),
           this,                          TQT_SLOT( slotTextChanged( const TQString & ) ) );

  connect( m_tool_bar,                    TQT_SIGNAL( pressed( int ) ),
           this,                          TQT_SLOT( slotButtonPressed( int ) ) );

  connect( m_list_view,                   TQT_SIGNAL( clicked( TQListViewItem * )  ),
           this,                          TQT_SLOT( slotItemClicked( TQListViewItem * ) ) );

  connect( m_list_view,                   TQT_SIGNAL( selectionChanged( TQListViewItem * )  ),
           this,                          TQT_SLOT( slotSelectionChanged( TQListViewItem * ) ) );
}


Smb4KSearchDialog::~Smb4KSearchDialog()
{
}


const TQString &Smb4KSearchDialog::searchString()
{
  m_search_string = m_tool_bar->getCombo( Combo )->currentText();

  return m_search_string;
}


/////////////////////////////////////////////////////////////////////////////
// TQT_SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KSearchDialog::slotReturnPressed()
{
  slotButtonPressed( Search );
}


void Smb4KSearchDialog::slotTextChanged( const TQString &text )
{
  m_tool_bar->setItemEnabled( Search, !text.isEmpty() );
  m_tool_bar->setItemEnabled( Clear, !text.isEmpty() );
}


void Smb4KSearchDialog::slotButtonPressed( int button_id )
{
  switch( button_id )
  {
    case Search:
    {
      // We will not remove the text from the edit line of the combo
      // box like in earlier versions of Smb4K, but it will be selected
      // later on, so that the user can easily remove it, if he wants to.
      // We disable the combo box until the search process returns.
      m_tool_bar->setItemEnabled( Combo, false );

      break;
    }
    case Clear:
    {
      // Clear the combo box and the list view. The buttons
      // will be disabled by slotTextChanged().
      m_tool_bar->getCombo( Combo )->clear();
      m_list_view->clear();

      m_tool_bar->setItemEnabled( Search, false );
      m_tool_bar->setItemEnabled( Clear, false );
      m_tool_bar->setItemEnabled( Add, false );

      break;
    }
    default:
    {
      break;
    }
  }

  emit buttonPressed( button_id );
}


void Smb4KSearchDialog::slotItemClicked( TQListViewItem *item )
{
  if ( !item )
  {
    // If there is no item, it means that the user clicked onto
    // the viewport. In this case, disable the "Add" button and
    // clear the current selection.
    m_tool_bar->setItemEnabled( Add, false );

    m_list_view->clearSelection();
  }
  else
  {
    // This is done by slotSelectionChanged().
  }
}


void Smb4KSearchDialog::slotSelectionChanged( TQListViewItem *item )
{
  if ( item )
  {
    // If we have got an item, enable the "Add" button if the
    // item is regular. Otherwise disable the button.
    Smb4KSearchDialogItem *search_item = static_cast<Smb4KSearchDialogItem *>( item );

    if ( search_item->isRegular() )
    {
      m_tool_bar->setItemEnabled( Add, true );
    }
    else
    {
      m_tool_bar->setItemEnabled( Add, false );
    }
  }
  else
  {
    // If there is no item, it means that the user clicked onto
    // the viewport. In this case, disable the "Add" button and
    // clear the current selection.
    m_tool_bar->setItemEnabled( Add, false );

    m_list_view->clearSelection();
  }
}

#include "smb4ksearchdialog.moc"
