/***************************************************************************
    smb4kauthoptions  -  The configuration page for the authentication
    settings of Smb4K
                             -------------------
    begin                : Sa Nov 15 2003
    copyright            : (C) 2003-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// TQt includes
#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tqgroupbox.h>
#include <tqbuttongroup.h>
#include <tqlabel.h>
#include <tqwhatsthis.h>

// KDE includes
#include <tdelocale.h>
#include <klineedit.h>

// application specific includes
#include "smb4kauthoptions.h"

Smb4KAuthOptions::Smb4KAuthOptions( TQWidget *parent, const char *name )
: TQWidget( parent, name )
{
  //
  // Default Authentication
  //
  TQGridLayout *grid = new TQGridLayout( this );
  grid->setSpacing( 10 );

  TQButtonGroup *password_group = new TQButtonGroup( 1, Qt::Horizontal,
                                 i18n( "Password Storage" ), this );
  TQCheckBox *use_wallet =        new TQCheckBox( i18n( "Save the authentication data in a wallet" ),
                                 password_group, "kcfg_UseWallet" );
  (void) new TQCheckBox( i18n( "If no wallet is used, remember authentication data during run time" ),
                                 password_group, "kcfg_RememberPasswords" );

  TQGroupBox *login_box =         new TQGroupBox( 1, Qt::Horizontal, i18n( "Default Login" ),
                                 this, "DefaultLoginBox" );
//   login_box->setInsideMargin( 10 );

  TQCheckBox *default_auth =      new TQCheckBox( i18n( "Use default login" ),
                                 login_box, "kcfg_UseDefaultLogin" );

  TQWidget *auth_widget =         new TQWidget( login_box, "DefaultAuthWidget" );
  TQGridLayout *auth_grid =       new TQGridLayout( auth_widget );
  auth_grid->setSpacing( 5 );

  TQLabel *login =                new TQLabel( i18n( "User:" ), auth_widget );
  KLineEdit *default_login =     new KLineEdit( auth_widget, "DefaultUserName" );
  default_login->setMinimumWidth( 150 );
  TQWhatsThis::add( default_login, i18n( "This login name is used by default to authenticate to a remote server." ) );
  TQLabel *password =             new TQLabel( i18n( "Password:" ), auth_widget );
  KLineEdit *default_password =  new KLineEdit( auth_widget, "DefaultPassword" );
  default_password->setEchoMode( KLineEdit::Password );
  default_password->setMinimumWidth( 150 );
  TQWhatsThis::add( default_password, i18n( "This password is used by default to authenticate to a remote server. It may be empty." ) );

  auth_grid->addWidget( login, 0, 0 );
  auth_grid->addWidget( default_login, 0, 1 );
  auth_grid->addWidget( password, 1, 0 );
  auth_grid->addWidget( default_password, 1, 1 );

  TQSpacerItem *spacer2 =         new TQSpacerItem( 0, 0, TQSizePolicy::Preferred, TQSizePolicy::Expanding );

  grid->addWidget( password_group, 0, 0, 0 );
  grid->addWidget( login_box, 1, 0, 0 );
  grid->addItem( spacer2, 2, 0 );

  connect( use_wallet,  TQT_SIGNAL( stateChanged( int ) ),
           this,          TQT_SLOT( slotTDEWalletButtonState( int ) ) );
  connect( default_auth, TQT_SIGNAL( stateChanged( int ) ),
           this,          TQT_SLOT( slotDefaultAuthButtonState( int ) ) );

  slotTDEWalletButtonState( use_wallet->state() );
  slotDefaultAuthButtonState( default_auth->state() );
}


Smb4KAuthOptions::~Smb4KAuthOptions()
{
}

/////////////////////////////////////////////////////////////////////////////
// TQT_SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KAuthOptions::slotTDEWalletButtonState( int state )
{
  if ( state == TQCheckBox::On )
  {
    static_cast<TQCheckBox *>( TQT_TQWIDGET(child( "DefaultLoginBox", "TQGroupBox", true )) )->setEnabled( true );
  }
  else if ( state == TQCheckBox::Off )
  {
    static_cast<TQCheckBox *>( TQT_TQWIDGET(child( "DefaultLoginBox", "TQGroupBox", true )) )->setEnabled( false );
  }
}


void Smb4KAuthOptions::slotDefaultAuthButtonState( int state )
{
  if ( state == TQCheckBox::On )
  {
    static_cast<TQCheckBox *>( TQT_TQWIDGET(child( "DefaultAuthWidget", "TQWidget", true )) )->setEnabled( true );
  }
  else if ( state == TQCheckBox::Off )
  {
    static_cast<TQCheckBox *>( TQT_TQWIDGET(child( "DefaultAuthWidget", "TQWidget", true )) )->setEnabled( false );
  }
}



#include "smb4kauthoptions.moc"
