/***************************************************************************
    smb4ksambaoptions.cpp  -  This is the configuration page for the
    Samba settings of Smb4K
                             -------------------
    begin                : Mo Jan 26 2004
    copyright            : (C) 2004-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSAMBAOPTIONS_H
#define SMB4KSAMBAOPTIONS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// TQt includes
#include <tqtabwidget.h>


/**
 * This class manages the configuration dialog of the options
 * that can be passed to smbmount and other programs of the
 * Samba software suite.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */


class Smb4KSambaOptions : public TQTabWidget
{
  Q_OBJECT
  

  public:
    /**
     * The constructor.
     *
     * @param parent            The parent widget
     *
     * @param name              This widget's name
     */
    Smb4KSambaOptions( TQWidget *parent = 0, const char *name = 0 );

    /**
     * The destructor.
     */
    ~Smb4KSambaOptions();

    /**
     * This enumeration is used for the list view in the "Custom" tab.
     */
#ifndef __FreeBSD__
    enum Columns{ ItemName = 0, Protocol = 1, FileSystem = 2, WriteAccess = 3, Kerberos = 4, UID = 5, GID = 6, Port = 7 };
#else
    enum Columns{ ItemName = 0, Protocol = 1, Kerberos = 2, UID = 3, GID = 4, Port = 5 };
#endif

    /**
     * Reset the 'Custom' options tab.
     */
    void resetCustomTab();

  signals:
    /**
     * This signal is emitted everytime the custom settings were changed by the
     * user. That may mean, that only one setting has has been altered but also
     * that all custom entries have been deleted. You have to figure out what
     * happened in the slot that's connected to this signal.
     */
    void customSettingsChanged();

  protected slots:
    /**
     * Enables/disables widgets according to the choice of the filesystem (SMBFS/CIFS).
     *
     * This slot is connected to the combo box that stores the file systems.
     *
     * @param item_index          The index of the item in the combo box.
     */
    void slotSambaFileSystem( int item_index );

    /**
     * This slot is invoked if an item in the list of custom options has been
     * clicked. It will put the values that are carried by the list view item
     * into the editor combo boxes, num inputs, etc.
     *
     * @param item             The item that has been clicked/highlighted.
     */
    void slotCustomItemClicked( TQListViewItem *item );

    /**
     * Commit the new custom protocol to the list view item.
     *
     * @param index            The index number of the new protocol
     */
    void slotCustomProtocolChanged( int index );

    /**
     * Commit the new custom file system to the list view item.
     *
     * @param index            The index number of the new file system
     */
    void slotCustomFileSystemChanged( int index );

    /**
     * Commit the new custom write access setting to the list view item.
     *
     * @param index            The index number of the new setting
     */
    void slotCustomWriteAccessChanged( int index );

    /**
     * Commit the new custom Kerberos setting to the list view item.
     *
     * @param index            The index number of the new setting
     */
    void slotCustomKerberosChanged( int index );

    /**
     * Commit the new custom UID to the list view item.
     *
     * @param uid              The new UID in text form
     */
    void slotCustomUIDChanged( const TQString &uid );

    /**
     * This slot is invoked if the value for the custom GID setting changed.
     *
     * @param gid              The new GID in text form
     */
    void slotCustomGIDChanged( const TQString &gid );

    /**
     * Commit the new custom port number to the list view item.
     *
     * @param port             The port number
     */
    void slotCustomPortChanged( int port );

    /**
     * Remove the highlighted item from the custom options list.
     */
    void slotRemoveCustomOption();

    /**
     * Remove all items from the custom options list.
     */
    void slotRemoveAllCustomOptions();
};

#endif
