/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEEDITUNITDIALOG_H
#define QALCULATEEDITUNITDIALOG_H

#include <kdialogbase.h>

class TQLabel;
class KComboBox;
class KLineEdit;
class TQCheckBox;
class TQPushButton;
class TQSpinBox;
class MathStructure;
class QalculateEditNamesDialog;
class Unit;
class TQGroupBox;

/**
@author Niklas Knutsson
*/
class QalculateEditUnitDialog : public KDialogBase {

	Q_OBJECT

public:

	QalculateEditUnitDialog(TQWidget *parent = 0, const char *name = 0);
	virtual ~QalculateEditUnitDialog();

	Unit *editUnit(TQString category = TQString::null, Unit *u = NULL);

	QalculateEditNamesDialog *names_edit_dialog;
	Unit *edited_unit;
	KComboBox *categoryCombo, *classCombo, *systemCombo;
	KLineEdit *nameEdit, *titleEdit, *baseEdit, *relationEdit, *inverseRelationEdit;
	TQLabel *namesLabel, *exponentLabel, *relationLabel, *inverseRelationLabel;
	TQCheckBox *relationExactButton, *hideButton;
	TQPushButton *namesButton;
	TQSpinBox *exponentBox;
	TQGroupBox *grid1, *grid2, *grid3;

public slots:

	void editNames();
	void classChanged(int);
	void nameChanged(const TQString&);

protected slots:
	
	void slotHelp();
	void slotOk();

};

#endif
