# Copyright (c) 2002 Detlev Offenbach <detlev@die-offenbachs.de>

from PyTQt.tqt import *

class MyWidget(TQMainWindow):

    def __init__(self, parent=None, name=None):
        TQMainWindow.__init__(self, parent, name)
        
        self.central = TQVBox(self)
        self.central.setMargin(5)
        self.central.setSpacing(5)
        self.setCentralWidget(self.central)
        
        self.setCaption(self.trUtf8("""Internationalization Example"""))
        
        self.file = TQPopupMenu(self)
        self.file.insertItem(self.trUtf8("E&xit"), tqApp, TQ_SLOT("quit()"),
                TQKeySequence(self.trUtf8("Ctrl+Q","File|Quit")))
        self.menuBar().insertItem(self.trUtf8("&File"), self.file)
        
        self.statusBar().message(self.trUtf8('''Language: English'''))
        
        self.label = TQLabel(self.trUtf8("The Main Window"), self.central)
        
        self.gbox = TQButtonGroup(1, TQGroupBox.Horizontal,
                self.trUtf8("View"), self.central)
        rb = TQRadioButton(tqApp.translate(b'MyWidget',b'Perspective'), self.gbox)
        rb = TQRadioButton(tqApp.translate(b'MyWidget',b'Isometric'), self.gbox)
        rb = TQRadioButton(tqApp.translate(b'MyWidget',b'Oblique'), self.gbox)
        
        self.initChoices(self.central)
        
    choices = [
        TQT_TRANSLATE_NOOP("MyWidget", "First"),
        TQT_TRANSLATE_NOOP("MyWidget", "Second"),
        TQT_TRANSLATE_NOOP("MyWidget", "Third")
        ]
        
    def initChoices(self, parent):
        self.lb = TQListBox(parent)
        for ch in self.choices:
            self.lb.insertItem(self.trUtf8(ch))
            
    def closeEvent(self, e):
        TQWidget.closeEvent(self, e)
        self.emit(PYSIGNAL('closed'), ())
