#!/usr/bin/env python

"""**************************************************************************
** $Id: listbox.py,v 1.1 2003/05/30 17:47:57 phil Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for TQt.  This example
** program may be used, distributed and modified without limitation.
**
***************************************************************************"""

import sys
from PyTQt.tqt import *

FALSE = 0
TRUE  = 1

class ListBoxDemo( TQWidget ):
    def __init__( self, parent=None, name=None ):
        TQWidget.__init__( self, parent, name )
        b = FALSE
        g = TQGridLayout( self, 2, 2, 6 )

        g.addWidget( TQLabel( "<b>Configuration:</b>", self ), 0, 0 )
        g.addWidget( TQLabel( "<b>Result:</b>", self ), 0, 1 )

        self.l = TQListBox( self )
        g.addWidget( self.l, 1, 1 )
        self.l.setFocusPolicy( TQWidget.StrongFocus )

        v = TQVBoxLayout( )
        g.addLayout( v, 1, 0 )
                
        bg = TQButtonGroup( self, None )

        b = TQRadioButton( "Fixed number of columns,\n"
                          "as many rows as needed.",
                          self )
        bg.insert( b )
        v.addWidget( b )
        b.setChecked( TRUE )
        self.connect( b, SIGNAL("clicked()"), self.setNumCols )
        h = TQHBoxLayout()
        v.addLayout( h )
        h.addSpacing( 30 )
        h.addSpacing( 100 )
        h.addWidget( TQLabel( "Columns:", self ) )
        self.columns = TQSpinBox( self )
        h.addWidget( self.columns )

        v.addSpacing( 12 )

        b = TQRadioButton( "As many columns as fit on-screen,\n"
                          "as many rows as needed.",
                          self )
        bg.insert( b )
        v.addWidget( b )
        self.connect( b, SIGNAL("clicked()"), self.setColsByWidth )

        v.addSpacing( 12 )

        b = TQRadioButton( "Fixed number of rows,\n"
                          "as many columns as needed.",
                          self )
        bg.insert( b )
        v.addWidget( b )
        self.connect( b, SIGNAL("clicked()"), self.setNumRows )
        h = TQHBoxLayout()
        v.addLayout( h )
        h.addSpacing( 30 )
        h.addSpacing( 100 )
        h.addWidget( TQLabel( "Rows:", self ) )
        self.rows = TQSpinBox( self )
        self.rows.setEnabled( FALSE )
        h.addWidget( self.rows )

        v.addSpacing( 12 )

        b = TQRadioButton( "As many rows as fit on-screen,\n"
                          "as many columns as needed.",
                          self )
        bg.insert( b )
        v.addWidget( b )
        self.connect( b, SIGNAL("clicked()"), self.setRowsByHeight )

        v.addSpacing( 12 )

        cb = TQCheckBox( "Variable-height rows", self )
        cb.setChecked( TRUE )
        self.connect( cb, SIGNAL("toggled(bool)"), self.setVariableHeight )
        v.addWidget( cb )
        v.addSpacing( 6 )
        
        cb = TQCheckBox( "Variable-width columns", self )
        self.connect( cb, SIGNAL("toggled(bool)"), self.setVariableWidth )
        v.addWidget( cb )

        cb = TQCheckBox( "Extended-Selection", self )
        self.connect( cb, SIGNAL("toggled(bool)"), self.setMultiSelection )
        v.addWidget( cb )

        pb = TQPushButton( "Sort ascending", self )
        self.connect( pb, SIGNAL("clicked()"), self.sortAscending )
        v.addWidget( pb )

        pb = TQPushButton( "Sort descending", self )
        self.connect( pb, SIGNAL("clicked()"), self.sortDescending )
        v.addWidget( pb )

        v.addStretch( 100 )

        i = 0
        while i <= 2560:
            i+=1
            self.l.insertItem( str(TQString.fromLatin1( "Item " )) + str(TQString.number( i )), i )
        self.columns.setRange( 1, 256 )
        self.columns.setValue( 1 )
        self.rows.setRange( 1, 256 )
        self.rows.setValue( 256 )

        self.connect( self.columns, SIGNAL("valueChanged(int)"), self.setNumCols )
        self.connect( self.rows, SIGNAL("valueChanged(int)"), self.setNumRows )

    # slots
    def setNumCols( self ):
        self.columns.setEnabled( TRUE )
        self.rows.setEnabled( FALSE )
        self.l.setColumnMode( self.columns.value() )

    def setNumRows( self ):
        self.columns.setEnabled( FALSE )
        self.rows.setEnabled( TRUE )
        self.l.setRowMode( self.rows.value() )

    def setRowsByHeight( self ):
        self.columns.setEnabled( FALSE )
        self.rows.setEnabled( FALSE )
        self.l.setRowMode( TQListBox.FitToHeight )

    def setColsByWidth( self ):
        self.columns.setEnabled( FALSE )
        self.rows.setEnabled( FALSE )
        self.l.setColumnMode( TQListBox.FitToWidth )

    def setVariableWidth( self, b ):
        self.l.setVariableWidth( b )

    def setVariableHeight( self, b ):
        self.l.setVariableHeight( b )

    def setMultiSelection( self, b ):
        self.l.clearSelection()
        if b :
            self.l.setSelectionMode( TQListBox.Extended )
        else:
            self.l.setSelectionMode( TQListBox.Single )
            
    def sortAscending( self ):
        self.l.sort( TRUE )

    def sortDescending( self ):
        self.l.sort( FALSE )

    
def main( args ):
    a = TQApplication( args )
    t = ListBoxDemo()
    t.setCaption( "TQt Example - Listbox" )
    a.setMainWidget( t )
    t.show()
    
    a.exec_loop()
    
if __name__=="__main__":
    main(sys.argv)
