#!/usr/bin/env python

# TQt tutorial 5.

import sys
from PyTQt import tqt


class MyWidget(tqt.TQVBox):
    def __init__(self, parent=None, name=None):
        tqt.TQVBox.__init__(self, parent, name)

        quit = tqt.TQPushButton("Quit", self, "quit")
        quit.setFont(tqt.TQFont("Times", 18, tqt.TQFont.Bold))

        self.connect(quit, tqt.SIGNAL("clicked()"), tqt.tqApp, tqt.SLOT("quit()"))

        lcd = tqt.TQLCDNumber(2, self, "lcd")

        slider = tqt.TQSlider(tqt.TQt.Horizontal, self, "slider")
        slider.setRange(0, 99)
        slider.setValue(0)

        self.connect(slider, tqt.SIGNAL("valueChanged(int)"), lcd, tqt.SLOT("display(int)"))


a = tqt.TQApplication(sys.argv)

w = MyWidget()
a.setMainWidget(w)
w.show()
sys.exit(a.exec_loop())
