"""
This template constructs an application with menus, toolbar and statusbar.
It uses an XML file (menuapp3ui.rc) to specify the menu layout; all menu
items have a corresponding action defined, but no menus are created
explicitly in code. This app has the same menu layout as menuapp2.py
"""

"""
Copyright 2003 Jim Bublitz

Terms and Conditions

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

Except as contained in this notice, the name of the copyright holder shall
not be used in advertising or otherwise to promote the sale, use or other
dealings in this Software without prior written authorization from the
copyright holder.
"""


False = 0
True  = not False


import sys

from PyTQt.tqt import TQPopupMenu, SIGNAL

from tdecore import TDEApplication, TDECmdLineArgs, TDEAboutData, i18n, TDEShortcut
from tdeui import TDEMainWindow, KMessageBox, KStdAction, TDEAction, TDEActionCollection

STATUSBAR_LEFT   = 1
STATUSBAR_MIDDLE = 2
STATUSBAR_RIGHT  = 3

class MainWin (TDEMainWindow):
    def __init__ (self, *args):
        apply (TDEMainWindow.__init__, (self,) + args)

        self.initActions ()
        self.createGUI ()
        self.initStatusBar ()

        self.saveAction.setEnabled (False)
        self.saveAsAction.setEnabled (False)

    def initActions (self):
        # "File" menu items
        self.newAction    = KStdAction.openNew (self.slotNew, self.actionCollection ())
        self.openAction   = KStdAction.open (self.slotOpen, self.actionCollection ())
        self.saveAction   = KStdAction.save (self.slotSave, self.actionCollection ())
        self.saveAsAction = KStdAction.saveAs (self.slotSaveAs, self.actionCollection ())
        self.printAction  = KStdAction.print_ (self.slotPrint, self.actionCollection ())
        self.quitAction   = KStdAction.quit (self.slotQuit, self.actionCollection ())


        # "Edit" menu items
        self.undoAction     = KStdAction.undo (self.slotUndo, self.actionCollection ())
        self.redoAction     = KStdAction.redo (self.slotRedo, self.actionCollection ())
        self.cutAction      = KStdAction.cut (self.slotCut, self.actionCollection ())
        self.copyAction     = KStdAction.copy (self.slotCopy, self.actionCollection ())
        self.pasteAction    = KStdAction.paste (self.slotPaste, self.actionCollection ())
        self.findAction     = KStdAction.find (self.slotFind, self.actionCollection ())
        self.findNextAction = KStdAction.findNext (self.slotFindNext, self.actionCollection ())
        self.replaceAction  = KStdAction.replace (self.slotReplace, self.actionCollection ())
        self.specialAction  = TDEAction (i18n ("Special"), TDEShortcut.null (), self.slotSpecial, self.actionCollection (), "specialActionName")

    def initStatusBar (self):
        self.statusBar ().insertItem ("", STATUSBAR_LEFT, 1000, True)
        self.statusBar ().insertItem ("", STATUSBAR_MIDDLE, 1000, True)
        self.statusBar ().insertItem ("", STATUSBAR_RIGHT, 1000, True)

#-------------------- slots -----------------------------------------------

    def slotNew (self, id = -1):
        self.notImpl ("New")

    def slotOpen(self, id = -1):
        self.notImpl ("Open")

    def slotSave (self, id = -1):
        self.notImpl ("Save")

    def slotSaveAs (self):
        self.notImpl ("Save As")

    def slotPrint (self):
        self.notImpl ("Print")

    def slotQuit (self):
        self.notImpl ("Quit")

    def slotUndo (self):
        self.notImpl ("Undo")

    def slotRedo (self):
        self.notImpl ("Redo")

    def slotCut (self, id = -1):
        self.notImpl ("Cut")

    def slotCopy (self, id = -1):
        self.notImpl ("Copy")

    def slotPaste (self, id = -1):
        self.notImpl ("Paste")

    def slotFind (self):
        self.notImpl ("Find")

    def slotFindNext (self):
        self.notImpl ("Find Next")

    def slotReplace (self):
        self.notImpl ("Replace")

    def slotSpecial (self):
        self.notImpl ("Special")

    def notImpl (self, item = "Feature"):
        self.statusBar ().changeItem ("%s not implemented" % item, STATUSBAR_LEFT)
        KMessageBox.error (self, "%s not implemented" % item, "Not Implemented")
        self.statusBar ().changeItem ("", STATUSBAR_LEFT)


#-------------------- main ------------------------------------------------

description = "A basic application template"
version     = "1.0"
aboutData   = TDEAboutData ("menuapp3", "",\
    version, description, TDEAboutData.License_GPL,\
    "(C) 2003 whoever the author is")

aboutData.addAuthor ("author1", "whatever they did", "email@somedomain")
aboutData.addAuthor ("author2", "they did something else", "another@email.address")

TDECmdLineArgs.init (sys.argv, aboutData)

TDECmdLineArgs.addCmdLineOptions ([("+files", "File to open")])

app = TDEApplication ()
mainWindow = MainWin (None, "main window")
mainWindow.show()
app.exec_loop()

