/***************************************************************************
                           kxearchiveextssettings.cpp
                           --------------------
    begin                : Tue Dec 02 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : hartig@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxearchiveextssettings.h"
#include "kxearchiveextssettingspage.h"

#include <tdelocale.h>
#include <tdeconfig.h>

#include <tqframe.h>
#include <tqlistbox.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>

#define CONF_ENTRY_NAME_EXTS_TARGZ "Extensions"

KXEArchiveExtsSettings::KXEArchiveExtsSettings( TQObject * pParent, const char * pszName )
 : KXESettings( "TarGz Extensions", pParent, pszName ),
   m_pDialogPage(0)
{
}


void KXEArchiveExtsSettings::write( TDEConfig * pConfig ) const
{
	pConfig->writeEntry( CONF_ENTRY_NAME_EXTS_TARGZ, m_lstExtensions );
}


void KXEArchiveExtsSettings::read( const TDEConfig * pConfig )
{
	m_lstExtensions = pConfig->readListEntry( CONF_ENTRY_NAME_EXTS_TARGZ );
}

TQString KXEArchiveExtsSettings::dialogPageName() const
{
	return i18n( "Archive Extensions" );
}

TQString KXEArchiveExtsSettings::dialogPageHeader() const
{
	return i18n( "Specify Archive Extensions" );
}

TQString KXEArchiveExtsSettings::dialogPageIcon() const
{
	return "filetypes";
}

TQWidget * KXEArchiveExtsSettings::dialogPage( TQFrame * pParent )
{
	if ( ! m_pDialogPage )
	{
		// create the page if necessary
		m_pDialogPage = new KXEArchiveExtsSettingsPage( pParent, "archive extensions config.dialog page" );

		// and fill its widgets with the corresponding values
		updatePage();

		connect( m_pDialogPage->m_pExtensions, SIGNAL(highlighted(const TQString&)), this, SLOT(slotPageEditExtension(const TQString&)) );
		connect( m_pDialogPage->m_pBtnNew, SIGNAL(clicked()), this, SLOT(slotPageAddExtension()) );
		connect( m_pDialogPage->m_pBtnDelete, SIGNAL(clicked()), this, SLOT(slotPageDeleteExtension()) );
		connect( m_pDialogPage->m_pExtension, SIGNAL(textChanged(const TQString&)), this, SLOT(slotPageUpdateExtension(const TQString&)) );

		connect( m_pDialogPage->m_pBtnNew, SIGNAL(clicked()), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pBtnDelete, SIGNAL(clicked()), this, SIGNAL(sigDialogPageChanged()) );
	}

	return m_pDialogPage;
}


void KXEArchiveExtsSettings::setFromPage()
{
	if ( m_pDialogPage )
	{
		m_lstExtensions.clear();
		TQListBoxItem * pTmpItem = m_pDialogPage->m_pExtensions->firstItem();
		while ( pTmpItem )
		{
			m_lstExtensions << pTmpItem->text();
			pTmpItem = pTmpItem->next();
		}
	}
}

void KXEArchiveExtsSettings::updatePage() const
{
	if ( m_pDialogPage )
	{
		m_pDialogPage->m_pExtensions->clear();
		m_pDialogPage->m_pExtensions->insertStringList( m_lstExtensions );
		m_pDialogPage->m_pExtension->setDisabled( true );
	}
}


//////////////////////////////////////////////////////////////////////
// additional slots for the corresponding configuration dialog page //
//////////////////////////////////////////////////////////////////////

void KXEArchiveExtsSettings::slotPageEditExtension( const TQString & strText )
{
	m_pDialogPage->m_pExtension->setText( strText );
	m_pDialogPage->m_pExtension->setEnabled( true );
	m_pDialogPage->m_pExtension->setFocus();
}

void KXEArchiveExtsSettings::slotPageAddExtension()
{
	m_pDialogPage->m_pExtensions->insertItem( "zip", 0 );
	m_pDialogPage->m_pExtensions->setCurrentItem( 0 );
	m_pDialogPage->m_pExtension->selectAll();
	m_pDialogPage->m_pExtension->setFocus();
	m_pDialogPage->m_pExtension->setEnabled( true );
}

void KXEArchiveExtsSettings::slotPageDeleteExtension()
{
	m_pDialogPage->m_pExtensions->removeItem( m_pDialogPage->m_pExtensions->currentItem() );

	if ( m_pDialogPage->m_pExtensions->count() == 0 )
	{
		m_pDialogPage->m_pExtension->clear();
		m_pDialogPage->m_pExtension->setDisabled( true );
	}
	else
		m_pDialogPage->m_pExtensions->setSelected( m_pDialogPage->m_pExtensions->currentItem(), true );
}

void KXEArchiveExtsSettings::slotPageUpdateExtension( const TQString & strText )
{
	if ( ( m_pDialogPage->m_pExtensions->count() > 0 ) &&
	     ( m_pDialogPage->m_pExtensions->currentText() != m_pDialogPage->m_pExtension->text() ) )
	{
		m_pDialogPage->m_pExtensions->changeItem( strText, m_pDialogPage->m_pExtensions->currentItem() );
		emit sigDialogPageChanged();
	}
}

#include "kxearchiveextssettings.moc"
