/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "profileipsecoptions.h"

#include <klineedit.h>
#include <tdelocale.h>
#include <kcombobox.h>
#include <tqcheckbox.h>
#include <tqgroupbox.h>
#include <tqlabel.h>
#include <tqwhatsthis.h>
#include "widgetnotifyhelper.h"
#include <iostream>

ProfileIpsecOptions::ProfileIpsecOptions(TQWidget *parent) : ProfileIpsecOptionsBase(parent)
{
}


ProfileIpsecOptions::~ProfileIpsecOptions()
{
}
void ProfileIpsecOptions::useRightNextHopToggled(bool)
{
	if (UseRightNextHopCheckBox->isChecked())
		RightNextHopLineEdit->setEnabled(true);
	else
		RightNextHopLineEdit->setEnabled(false);
}


void ProfileIpsecOptions::useLeftNextHopToggled(bool)
{
	if (UseLeftNextHopCheckBox->isChecked())
		LeftNextHopLineEdit->setEnabled(true);
	else
		LeftNextHopLineEdit->setEnabled(false);
}


void ProfileIpsecOptions::dialogChanged()
{
// 	std::cout << "ProfileIpsecOptions::dialogChanged()" << std::endl;
	dialogModified=true;
}

void ProfileIpsecOptions::useIkeToggled(bool)
{
	if (UseCustomIkeCheckBox->isChecked())
		IkeGroupBox->setEnabled(true);
	else
		IkeGroupBox->setEnabled(false);
}


void ProfileIpsecOptions::useEspToogled(bool)
{
	if (UseCustomEspCheckBox->isChecked())
		EspGroupBox->setEnabled(true);
	else
		EspGroupBox->setEnabled(false);
}

void ProfileIpsecOptions::localIDTypeToggled(const TQString& text)
{
	if (text == "asn1dn" || text == i18n("Certificate ID"))
	{
		LocalIDLineEdit->setDisabled(true);
		LocalIDLabel->setDisabled(true);
	}
	else
	{
		LocalIDLineEdit->setDisabled(false);
		LocalIDLabel->setDisabled(false);
	}
}

void ProfileIpsecOptions::remoteIDTypeToggled(const TQString& text)
{
	if (text == "asn1dn" || text == "none")
	{
		RemoteIDLineEdit->setDisabled(true);
		RemoteIDLabel->setDisabled(true);
	}
	else
	{
		RemoteIDLineEdit->setDisabled(false);
		RemoteIDLabel->setDisabled(false);
	}
}



void ProfileIpsecOptions::ikeHelpClicked(int,int)
{
	TQWhatsThis::display ( i18n("<h1>IPSec IKE algorithms</h1><p>You have to specify the IKE values in the following format:\n<nobr>&lt;encryption algorithm&gt;-&lt;authentication algorithm&gt;</nobr>\nor\n<nobr>&lt;encryption algorithm&gt;-&lt;authentication algorithm&gt;-&lt;diffie helman group&gt;</nobr></p>"), TQCursor::pos ( ), (TQWidget *)IkeHelpActiveLabel);
}



void ProfileIpsecOptions::espHelpClicked(int,int)
{
	TQWhatsThis::display ( i18n("<h1>IPSec ESP algorithms</h1><nobr>You have to specify the ESP values in the following format:\n<b>&lt;encryption algorithm&gt;-&lt;authentication algorithm&gt;</nobr>\nor\n<nobr>&lt;encryption algorithm&gt;-&lt;authentication algorithm&gt</nobr></p>"), TQCursor::pos ( ), (TQWidget *)EspHelpActiveLabel);
}



void ProfileIpsecOptions::usePfsToogled(bool)
{
	if (PerfectForwardSecurityCheckbox->isChecked())
		PerfectForwardSecrecyCombobox->setEnabled(true);
	else
		PerfectForwardSecrecyCombobox->setEnabled(false);
}

#include "profileipsecoptions.moc"
